/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.webui;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestCollection;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.webui.PrivateInternals_UiActionDescription;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityUtils;
import com.google.inject.Provider;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiActions {
    private static final Logger log = LoggerFactory.getLogger(UiActions.class);

    public static Predicate<UiAction.Description> enabled() {
        return UiAction.Description::isEnabled;
    }

    public static <R extends RestResource> FluentIterable<UiAction.Description> from(RestCollection<?, R> collection, R resource, Provider<CurrentUser> userProvider) {
        return UiActions.from(collection.views(), resource, userProvider);
    }

    public static <R extends RestResource> FluentIterable<UiAction.Description> from(DynamicMap<RestView<R>> views, R resource, Provider<CurrentUser> userProvider) {
        return FluentIterable.from(views).transform(e -> {
            RestView view;
            int d = e.getExportName().indexOf(46);
            if (d < 0) {
                return null;
            }
            try {
                view = (RestView)e.getProvider().get();
            }
            catch (RuntimeException err) {
                log.error("error creating view {}.{}", e.getPluginName(), e.getExportName(), err);
                return null;
            }
            if (!(view instanceof UiAction)) {
                return null;
            }
            try {
                CapabilityUtils.checkRequiresCapability(userProvider, e.getPluginName(), view.getClass());
            }
            catch (AuthException exc) {
                return null;
            }
            UiAction.Description dsc = ((UiAction)view).getDescription(resource);
            if (dsc == null || !dsc.isVisible()) {
                return null;
            }
            String name = e.getExportName().substring(d + 1);
            PrivateInternals_UiActionDescription.setMethod(dsc, e.getExportName().substring(0, d));
            PrivateInternals_UiActionDescription.setId(dsc, "gerrit".equals(e.getPluginName()) ? name : e.getPluginName() + '~' + name);
            return dsc;
        }).filter(Objects::nonNull);
    }

    private UiActions() {
    }
}

