/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.ReviewNoteMerger;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.notes.NoteMapMerger;
import org.eclipse.jgit.notes.NoteMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class NotesBranchUtil {
    private static final int MAX_LOCK_FAILURE_CALLS = 10;
    private static final int SLEEP_ON_LOCK_FAILURE_MS = 25;
    private final PersonIdent gerritIdent;
    private final GitReferenceUpdated gitRefUpdated;
    private final Project.NameKey project;
    private final Repository db;
    private final ObjectInserter inserter;
    private RevCommit baseCommit;
    private NoteMap base;
    private RevCommit oursCommit;
    private NoteMap ours;
    private RevWalk revWalk;
    private ObjectReader reader;
    private boolean overwrite;
    private ReviewNoteMerger noteMerger;

    @Inject
    public NotesBranchUtil(@GerritPersonIdent PersonIdent gerritIdent, GitReferenceUpdated gitRefUpdated, @Assisted Project.NameKey project, @Assisted Repository db, @Assisted ObjectInserter inserter) {
        this.gerritIdent = gerritIdent;
        this.gitRefUpdated = gitRefUpdated;
        this.project = project;
        this.db = db;
        this.inserter = inserter;
    }

    public final void commitAllNotes(NoteMap notes, String notesBranch, PersonIdent commitAuthor, String commitMessage) throws IOException, ConcurrentRefUpdateException {
        this.overwrite = true;
        this.commitNotes(notes, notesBranch, commitAuthor, commitMessage);
    }

    public final NoteMap commitNewNotes(NoteMap notes, String notesBranch, PersonIdent commitAuthor, String commitMessage) throws IOException, ConcurrentRefUpdateException {
        this.overwrite = false;
        this.commitNotes(notes, notesBranch, commitAuthor, commitMessage);
        NoteMap newlyCreated = NoteMap.newEmptyMap();
        for (Note n : notes) {
            if (this.base != null && this.base.contains(n)) continue;
            newlyCreated.set(n, n.getData());
        }
        return newlyCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitNotes(NoteMap notes, String notesBranch, PersonIdent commitAuthor, String commitMessage) throws IOException, ConcurrentRefUpdateException {
        try {
            this.revWalk = new RevWalk(this.db);
            this.reader = this.db.newObjectReader();
            this.loadBase(notesBranch);
            if (this.overwrite) {
                this.addAllNotes(notes);
            } else {
                this.addNewNotes(notes);
            }
            this.oursCommit = this.base != null ? this.createCommit(this.ours, commitAuthor, commitMessage, this.baseCommit) : this.createCommit(this.ours, commitAuthor, commitMessage, new RevCommit[0]);
            this.updateRef(notesBranch);
        }
        finally {
            this.revWalk.close();
            this.reader.close();
        }
    }

    private void addNewNotes(NoteMap notes) throws IOException {
        for (Note n : notes) {
            if (this.ours.contains(n)) continue;
            this.ours.set(n, n.getData());
        }
    }

    private void addAllNotes(NoteMap notes) throws IOException {
        for (Note n : notes) {
            if (this.ours.contains(n)) {
                ObjectId noteContent = this.getNoteMerger().merge(null, n, this.ours.getNote(n), this.reader, this.inserter).getData();
                this.ours.set(n, noteContent);
                continue;
            }
            this.ours.set(n, n.getData());
        }
    }

    private NoteMerger getNoteMerger() {
        if (this.noteMerger == null) {
            this.noteMerger = new ReviewNoteMerger();
        }
        return this.noteMerger;
    }

    private void loadBase(String notesBranch) throws IOException {
        Ref branch = this.db.getRefDatabase().exactRef(notesBranch);
        if (branch != null) {
            this.baseCommit = this.revWalk.parseCommit(branch.getObjectId());
            this.base = NoteMap.read(this.revWalk.getObjectReader(), this.baseCommit);
        }
        this.ours = this.baseCommit != null ? NoteMap.read(this.revWalk.getObjectReader(), this.baseCommit) : NoteMap.newEmptyMap();
    }

    private RevCommit createCommit(NoteMap map, PersonIdent author, String message, RevCommit ... parents) throws IOException {
        CommitBuilder b = new CommitBuilder();
        b.setTreeId(map.writeTree(this.inserter));
        b.setAuthor(author != null ? author : this.gerritIdent);
        b.setCommitter(this.gerritIdent);
        if (parents.length > 0) {
            b.setParentIds(parents);
        }
        b.setMessage(message);
        ObjectId commitId = this.inserter.insert(b);
        this.inserter.flush();
        return this.revWalk.parseCommit(commitId);
    }

    private void updateRef(String notesBranch) throws IOException, MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, ConcurrentRefUpdateException {
        RefUpdate.Result result;
        if (this.baseCommit != null && this.oursCommit.getTree().equals(this.baseCommit.getTree())) {
            return;
        }
        int remainingLockFailureCalls = 10;
        RefUpdate refUpdate = this.createRefUpdate(notesBranch, this.oursCommit, this.baseCommit);
        while (true) {
            if ((result = refUpdate.update()) == RefUpdate.Result.LOCK_FAILURE) {
                if (--remainingLockFailureCalls > 0) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new ConcurrentRefUpdateException("Failed to lock the ref: " + notesBranch, refUpdate.getRef(), result);
            }
            if (result != RefUpdate.Result.REJECTED) break;
            RevCommit theirsCommit = this.revWalk.parseCommit(refUpdate.getOldObjectId());
            NoteMap theirs = NoteMap.read(this.revWalk.getObjectReader(), theirsCommit);
            NoteMapMerger merger = new NoteMapMerger(this.db, this.getNoteMerger(), MergeStrategy.RESOLVE);
            NoteMap merged = merger.merge(this.base, this.ours, theirs);
            RevCommit mergeCommit = this.createCommit(merged, this.gerritIdent, "Merged note commits\n", theirsCommit, this.oursCommit);
            refUpdate = this.createRefUpdate(notesBranch, mergeCommit, theirsCommit);
            remainingLockFailureCalls = 10;
        }
        if (result == RefUpdate.Result.IO_FAILURE) {
            throw new IOException("Couldn't update " + notesBranch + ". " + result.name());
        }
        this.gitRefUpdated.fire(this.project, refUpdate, null);
    }

    private RefUpdate createRefUpdate(String notesBranch, ObjectId newObjectId, ObjectId expectedOldObjectId) throws IOException {
        RefUpdate refUpdate = this.db.updateRef(notesBranch);
        refUpdate.setNewObjectId(newObjectId);
        if (expectedOldObjectId == null) {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        } else {
            refUpdate.setExpectedOldObjectId(expectedOldObjectId);
        }
        return refUpdate;
    }

    public static interface Factory {
        public NotesBranchUtil create(Project.NameKey var1, Repository var2, ObjectInserter var3);
    }
}

