/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

@Singleton
class ReceiveConfig {
    final boolean checkMagicRefs;
    final boolean checkReferencedObjectsAreReachable;
    final boolean allowDrafts;
    private final int systemMaxBatchChanges;

    @Inject
    ReceiveConfig(@GerritServerConfig Config config) {
        this.checkMagicRefs = config.getBoolean("receive", null, "checkMagicRefs", true);
        this.checkReferencedObjectsAreReachable = config.getBoolean("receive", null, "checkReferencedObjectsAreReachable", true);
        this.allowDrafts = config.getBoolean("change", null, "allowDrafts", true);
        this.systemMaxBatchChanges = config.getInt("receive", "maxBatchChanges", 0);
    }

    public int getEffectiveMaxBatchChangesLimit(CurrentUser user) {
        if (user.getCapabilities().canPerform("batchChangesLimit")) {
            return user.getCapabilities().getRange("batchChangesLimit").getMax();
        }
        return this.systemMaxBatchChanges;
    }
}

