/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.FooterConstants;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.client.ChangeKind;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.server.ApprovalCopier;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.change.ChangeKindCache;
import com.google.gerrit.server.extensions.events.CommentAdded;
import com.google.gerrit.server.extensions.events.RevisionCreated;
import com.google.gerrit.server.git.MergedByPushOp;
import com.google.gerrit.server.git.ReceiveCommits;
import com.google.gerrit.server.git.SendEmailExecutor;
import com.google.gerrit.server.mail.MailUtil;
import com.google.gerrit.server.mail.send.ReplacePatchSetSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.RepoContext;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gwtorm.server.OrmException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceOp
implements BatchUpdateOp {
    private static final Logger log = LoggerFactory.getLogger(ReplaceOp.class);
    private static final String CHANGE_IS_CLOSED = "change is closed";
    private final AccountResolver accountResolver;
    private final ApprovalCopier approvalCopier;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeControl.GenericFactory changeControlFactory;
    private final ChangeData.Factory changeDataFactory;
    private final ChangeKindCache changeKindCache;
    private final ChangeMessagesUtil cmUtil;
    private final ExecutorService sendEmailExecutor;
    private final RevisionCreated revisionCreated;
    private final CommentAdded commentAdded;
    private final MergedByPushOp.Factory mergedByPushOpFactory;
    private final PatchSetUtil psUtil;
    private final ReplacePatchSetSender.Factory replacePatchSetFactory;
    private final ProjectControl projectControl;
    private final Branch.NameKey dest;
    private final boolean checkMergedInto;
    private final PatchSet.Id priorPatchSetId;
    private final RevCommit priorCommit;
    private final PatchSet.Id patchSetId;
    private final RevCommit commit;
    private final PatchSetInfo info;
    private final ReceiveCommits.MagicBranchInput magicBranch;
    private final PushCertificate pushCertificate;
    private List<String> groups = ImmutableList.of();
    private final Map<String, Short> approvals = new HashMap<String, Short>();
    private final MailUtil.MailRecipients recipients = new MailUtil.MailRecipients();
    private Change change;
    private PatchSet newPatchSet;
    private ChangeKind changeKind;
    private ChangeMessage msg;
    private String rejectMessage;
    private MergedByPushOp mergedByPushOp;
    private RequestScopePropagator requestScopePropagator;
    private boolean updateRef;

    @AssistedInject
    ReplaceOp(AccountResolver accountResolver, ApprovalCopier approvalCopier, ApprovalsUtil approvalsUtil, ChangeControl.GenericFactory changeControlFactory, ChangeData.Factory changeDataFactory, ChangeKindCache changeKindCache, ChangeMessagesUtil cmUtil, RevisionCreated revisionCreated, CommentAdded commentAdded, MergedByPushOp.Factory mergedByPushOpFactory, PatchSetUtil psUtil, ReplacePatchSetSender.Factory replacePatchSetFactory, @SendEmailExecutor ExecutorService sendEmailExecutor, @Assisted ProjectControl projectControl, @Assisted Branch.NameKey dest, @Assisted boolean checkMergedInto, @Assisted(value="priorPatchSetId") PatchSet.Id priorPatchSetId, @Assisted(value="priorCommit") RevCommit priorCommit, @Assisted(value="patchSetId") PatchSet.Id patchSetId, @Assisted(value="commit") RevCommit commit, @Assisted PatchSetInfo info, @Assisted List<String> groups, @Assisted @Nullable ReceiveCommits.MagicBranchInput magicBranch, @Assisted @Nullable PushCertificate pushCertificate) {
        this.accountResolver = accountResolver;
        this.approvalCopier = approvalCopier;
        this.approvalsUtil = approvalsUtil;
        this.changeControlFactory = changeControlFactory;
        this.changeDataFactory = changeDataFactory;
        this.changeKindCache = changeKindCache;
        this.cmUtil = cmUtil;
        this.revisionCreated = revisionCreated;
        this.commentAdded = commentAdded;
        this.mergedByPushOpFactory = mergedByPushOpFactory;
        this.psUtil = psUtil;
        this.replacePatchSetFactory = replacePatchSetFactory;
        this.sendEmailExecutor = sendEmailExecutor;
        this.projectControl = projectControl;
        this.dest = dest;
        this.checkMergedInto = checkMergedInto;
        this.priorPatchSetId = priorPatchSetId;
        this.priorCommit = priorCommit;
        this.patchSetId = patchSetId;
        this.commit = commit;
        this.info = info;
        this.groups = groups;
        this.magicBranch = magicBranch;
        this.pushCertificate = pushCertificate;
        this.updateRef = true;
    }

    @Override
    public void updateRepo(RepoContext ctx) throws Exception {
        Ref mergedInto;
        this.changeKind = this.changeKindCache.getChangeKind(this.projectControl.getProject().getNameKey(), ctx.getRepository(), this.priorCommit, this.commit);
        if (this.checkMergedInto && (mergedInto = this.findMergedInto(ctx, this.dest.get(), this.commit)) != null) {
            this.mergedByPushOp = this.mergedByPushOpFactory.create(this.requestScopePropagator, this.patchSetId, mergedInto.getName());
        }
        if (this.updateRef) {
            ctx.addRefUpdate(new ReceiveCommand(ObjectId.zeroId(), this.commit, this.patchSetId.toRefName()));
        }
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws RestApiException, OrmException, IOException {
        boolean draft;
        this.change = ctx.getChange();
        if (this.change == null || this.change.getStatus().isClosed()) {
            this.rejectMessage = CHANGE_IS_CLOSED;
            return false;
        }
        if (this.groups.isEmpty()) {
            PatchSet prevPs = this.psUtil.current(ctx.getDb(), ctx.getNotes());
            this.groups = prevPs != null ? prevPs.getGroups() : ImmutableList.of();
        }
        ChangeUpdate update = ctx.getUpdate(this.patchSetId);
        update.setSubjectForCommit("Create patch set " + this.patchSetId.get());
        String reviewMessage = null;
        String psDescription = null;
        if (this.magicBranch != null) {
            this.recipients.add(this.magicBranch.getMailRecipients());
            reviewMessage = this.magicBranch.message;
            psDescription = this.magicBranch.message;
            this.approvals.putAll(this.magicBranch.labels);
            Set<String> hashtags = this.magicBranch.hashtags;
            if (hashtags != null && !hashtags.isEmpty()) {
                hashtags.addAll(ctx.getNotes().getHashtags());
                update.setHashtags(hashtags);
            }
            if (this.magicBranch.topic != null && !this.magicBranch.topic.equals(ctx.getChange().getTopic())) {
                update.setTopic(this.magicBranch.topic);
            }
        }
        boolean bl = draft = this.magicBranch != null && this.magicBranch.draft;
        if (this.change.getStatus() == Change.Status.DRAFT && !draft) {
            update.setStatus(Change.Status.NEW);
        }
        this.newPatchSet = this.psUtil.insert(ctx.getDb(), ctx.getRevWalk(), update, this.patchSetId, this.commit, draft, this.groups, this.pushCertificate != null ? this.pushCertificate.toTextWithSignature() : null, psDescription);
        update.setPsDescription(psDescription);
        this.recipients.add(MailUtil.getRecipientsFromFooters(ctx.getDb(), this.accountResolver, draft, this.commit.getFooterLines()));
        this.recipients.remove(ctx.getAccountId());
        ChangeData cd = this.changeDataFactory.create(ctx.getDb(), ctx.getControl());
        MailUtil.MailRecipients oldRecipients = MailUtil.getRecipientsFromReviewers(cd.reviewers());
        Iterable<PatchSetApproval> newApprovals = this.approvalsUtil.addApprovalsForNewPatchSet(ctx.getDb(), update, this.projectControl.getLabelTypes(), this.newPatchSet, ctx.getControl(), this.approvals);
        this.approvalCopier.copy(ctx.getDb(), ctx.getControl(), this.newPatchSet, newApprovals);
        this.approvalsUtil.addReviewers(ctx.getDb(), update, this.projectControl.getLabelTypes(), this.change, this.newPatchSet, this.info, this.recipients.getReviewers(), oldRecipients.getAll());
        if (this.magicBranch != null && !this.magicBranch.labels.isEmpty()) {
            update.putReviewer(ctx.getAccountId(), ReviewerStateInternal.REVIEWER);
        }
        this.recipients.add(oldRecipients);
        String approvalMessage = ApprovalsUtil.renderMessageWithApprovals(this.patchSetId.get(), this.approvals, this.scanLabels(ctx, this.approvals));
        String kindMessage = this.changeKindMessage(this.changeKind);
        StringBuilder message = new StringBuilder(approvalMessage);
        if (!Strings.isNullOrEmpty(kindMessage)) {
            message.append(kindMessage);
        } else {
            message.append('.');
        }
        if (!Strings.isNullOrEmpty(reviewMessage)) {
            message.append("\n").append(reviewMessage);
        }
        this.msg = ChangeMessagesUtil.newMessage(this.patchSetId, ctx.getUser(), ctx.getWhen(), message.toString(), "autogenerated:gerrit:newPatchSet");
        this.cmUtil.addChangeMessage(ctx.getDb(), update, this.msg);
        if (this.mergedByPushOp == null) {
            this.resetChange(ctx);
        } else {
            this.mergedByPushOp.setPatchSetProvider(Providers.of(this.newPatchSet)).updateChange(ctx);
        }
        return true;
    }

    private String changeKindMessage(ChangeKind changeKind) {
        switch (changeKind) {
            case MERGE_FIRST_PARENT_UPDATE: 
            case TRIVIAL_REBASE: 
            case NO_CHANGE: {
                return ": Patch Set " + this.priorPatchSetId.get() + " was rebased.";
            }
            case NO_CODE_CHANGE: {
                return ": Commit message was updated.";
            }
        }
        return null;
    }

    private Map<String, PatchSetApproval> scanLabels(ChangeContext ctx, Map<String, Short> approvals) throws OrmException {
        HashMap<String, PatchSetApproval> current = new HashMap<String, PatchSetApproval>();
        if (!approvals.isEmpty()) {
            for (PatchSetApproval a : this.approvalsUtil.byPatchSetUser(ctx.getDb(), ctx.getControl(), this.priorPatchSetId, ctx.getAccountId())) {
                LabelType lt;
                if (a.isLegacySubmit() || (lt = this.projectControl.getLabelTypes().byLabel(a.getLabelId())) == null) continue;
                current.put(lt.getName(), a);
            }
        }
        return current;
    }

    private void resetChange(ChangeContext ctx) {
        Change change = ctx.getChange();
        if (!change.currentPatchSetId().equals(this.priorPatchSetId)) {
            return;
        }
        if (this.magicBranch != null && this.magicBranch.topic != null) {
            change.setTopic(this.magicBranch.topic);
        }
        if (change.getStatus() != Change.Status.DRAFT || !this.newPatchSet.isDraft()) {
            change.setStatus(Change.Status.NEW);
        }
        change.setCurrentPatchSet(this.info);
        List<String> idList = this.commit.getFooterLines(FooterConstants.CHANGE_ID);
        if (idList.isEmpty()) {
            change.setKey(new Change.Key("I" + this.commit.name()));
        } else {
            change.setKey(new Change.Key(idList.get(idList.size() - 1).trim()));
        }
    }

    @Override
    public void postUpdate(final Context ctx) throws Exception {
        if (this.changeKind != ChangeKind.TRIVIAL_REBASE) {
            Runnable sender = new Runnable(){

                @Override
                public void run() {
                    try {
                        ReplacePatchSetSender cm = ReplaceOp.this.replacePatchSetFactory.create(ReplaceOp.this.projectControl.getProject().getNameKey(), ReplaceOp.this.change.getId());
                        cm.setFrom(ctx.getAccount().getId());
                        cm.setPatchSet(ReplaceOp.this.newPatchSet, ReplaceOp.this.info);
                        cm.setChangeMessage(ReplaceOp.this.msg.getMessage(), ctx.getWhen());
                        if (ReplaceOp.this.magicBranch != null) {
                            cm.setNotify(((ReplaceOp)ReplaceOp.this).magicBranch.notify);
                            cm.setAccountsToNotify(ReplaceOp.this.magicBranch.getAccountsToNotify());
                        }
                        cm.addReviewers(ReplaceOp.this.recipients.getReviewers());
                        cm.addExtraCC(ReplaceOp.this.recipients.getCcOnly());
                        cm.send();
                    }
                    catch (Exception e) {
                        log.error("Cannot send email for new patch set " + ReplaceOp.this.newPatchSet.getId(), e);
                    }
                }

                public String toString() {
                    return "send-email newpatchset";
                }
            };
            if (this.requestScopePropagator != null) {
                Future<?> future = this.sendEmailExecutor.submit(this.requestScopePropagator.wrap(sender));
            } else {
                sender.run();
            }
        }
        NotifyHandling notify = this.magicBranch != null && this.magicBranch.notify != null ? this.magicBranch.notify : NotifyHandling.ALL;
        this.revisionCreated.fire(this.change, this.newPatchSet, ctx.getAccount(), ctx.getWhen(), notify);
        try {
            this.fireCommentAddedEvent(ctx);
        }
        catch (Exception e) {
            log.warn("comment-added event invocation failed", e);
        }
        if (this.mergedByPushOp != null) {
            this.mergedByPushOp.postUpdate(ctx);
        }
    }

    private void fireCommentAddedEvent(Context ctx) throws OrmException {
        if (this.approvals.isEmpty()) {
            return;
        }
        ChangeControl changeControl = this.changeControlFactory.controlFor(ctx.getDb(), this.change, ctx.getUser());
        List<LabelType> labels = changeControl.getLabelTypes().getLabelTypes();
        HashMap<String, Short> allApprovals = new HashMap<String, Short>();
        HashMap<String, Short> oldApprovals = new HashMap<String, Short>();
        for (LabelType labelType : labels) {
            allApprovals.put(labelType.getName(), (short)0);
            oldApprovals.put(labelType.getName(), null);
        }
        for (Map.Entry entry : this.approvals.entrySet()) {
            if ((Short)entry.getValue() == 0) continue;
            allApprovals.put((String)entry.getKey(), (Short)entry.getValue());
            oldApprovals.put((String)entry.getKey(), (short)0);
        }
        this.commentAdded.fire(this.change, this.newPatchSet, ctx.getAccount(), null, allApprovals, oldApprovals, ctx.getWhen());
    }

    public PatchSet getPatchSet() {
        return this.newPatchSet;
    }

    public Change getChange() {
        return this.change;
    }

    public String getRejectMessage() {
        return this.rejectMessage;
    }

    public ReplaceOp setUpdateRef(boolean updateRef) {
        this.updateRef = updateRef;
        return this;
    }

    public ReplaceOp setRequestScopePropagator(RequestScopePropagator requestScopePropagator) {
        this.requestScopePropagator = requestScopePropagator;
        return this;
    }

    private Ref findMergedInto(Context ctx, String first, RevCommit commit) {
        try {
            RefDatabase refDatabase = ctx.getRepository().getRefDatabase();
            Ref firstRef = refDatabase.exactRef(first);
            if (firstRef != null && ReplaceOp.isMergedInto(ctx.getRevWalk(), commit, firstRef)) {
                return firstRef;
            }
            for (Ref ref : refDatabase.getRefs("refs/heads/").values()) {
                if (!ReplaceOp.isMergedInto(ctx.getRevWalk(), commit, ref)) continue;
                return ref;
            }
            return null;
        }
        catch (IOException e) {
            log.warn("Can't check for already submitted change", e);
            return null;
        }
    }

    private static boolean isMergedInto(RevWalk rw, RevCommit commit, Ref ref) throws IOException {
        return rw.isMergedInto(commit, rw.parseCommit(ref.getObjectId()));
    }

    public static interface Factory {
        public ReplaceOp create(ProjectControl var1, Branch.NameKey var2, boolean var3, @Assisted(value="priorPatchSetId") PatchSet.Id var4, @Assisted(value="priorCommit") RevCommit var5, @Assisted(value="patchSetId") PatchSet.Id var6, @Assisted(value="commit") RevCommit var7, PatchSetInfo var8, List<String> var9, @Nullable ReceiveCommits.MagicBranchInput var10, @Nullable PushCertificate var11);
    }
}

