/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.LabelId;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.GroupCollector;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.LabelNormalizer;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.SubmoduleException;
import com.google.gerrit.server.git.strategy.CommitMergeStatus;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.RepoContext;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SubmitStrategyOp
implements BatchUpdateOp {
    private static final Logger log = LoggerFactory.getLogger(SubmitStrategyOp.class);
    protected final SubmitStrategy.Arguments args;
    protected final CodeReviewCommit toMerge;
    private ReceiveCommand command;
    private PatchSetApproval submitter;
    private ObjectId mergeResultRev;
    private PatchSet mergedPatchSet;
    private Change updatedChange;
    private CodeReviewCommit alreadyMerged;

    protected SubmitStrategyOp(SubmitStrategy.Arguments args, CodeReviewCommit toMerge) {
        this.args = args;
        this.toMerge = toMerge;
    }

    final Change.Id getId() {
        return this.toMerge.change().getId();
    }

    final CodeReviewCommit getCommit() {
        return this.toMerge;
    }

    protected final Branch.NameKey getDest() {
        return this.toMerge.change().getDest();
    }

    protected final Project.NameKey getProject() {
        return this.getDest().getParentKey();
    }

    @Override
    public final void updateRepo(RepoContext ctx) throws Exception {
        this.logDebug("{}#updateRepo for change {}", this.getClass().getSimpleName(), this.toMerge.change().getId());
        CodeReviewCommit tipBefore = this.args.mergeTip.getCurrentTip();
        this.alreadyMerged = this.getAlreadyMergedCommit(ctx);
        if (this.alreadyMerged == null) {
            this.updateRepoImpl(ctx);
        } else {
            this.logDebug("Already merged as {}", this.alreadyMerged.name());
        }
        CodeReviewCommit tipAfter = this.args.mergeTip.getCurrentTip();
        if (Objects.equals(tipBefore, tipAfter)) {
            this.logDebug("Did not move tip", this.getClass().getSimpleName());
            return;
        }
        if (tipAfter == null) {
            this.logDebug("No merge tip, no update to perform", new Object[0]);
            return;
        }
        this.logDebug("Moved tip from {} to {}", tipBefore, tipAfter);
        this.checkProjectConfig(ctx, tipAfter);
        this.command = new ReceiveCommand(MoreObjects.firstNonNull(tipBefore, ObjectId.zeroId()), tipAfter, this.getDest().get());
        ctx.addRefUpdate(this.command);
        this.args.submoduleOp.addBranchTip(this.getDest(), tipAfter);
    }

    private void checkProjectConfig(RepoContext ctx, CodeReviewCommit commit) throws IntegrationException {
        String refName = this.getDest().get();
        if ("refs/meta/config".equals(refName)) {
            this.logDebug("Loading new configuration from {}", "refs/meta/config");
            try {
                ProjectConfig cfg = new ProjectConfig(this.getProject());
                cfg.load(ctx.getRevWalk(), (ObjectId)commit);
            }
            catch (Exception e) {
                throw new IntegrationException("Submit would store invalid project configuration " + commit.name() + " for " + this.getProject(), e);
            }
        }
    }

    private CodeReviewCommit getAlreadyMergedCommit(RepoContext ctx) throws IOException {
        CodeReviewCommit tip = this.args.mergeTip.getInitialTip();
        if (tip == null) {
            return null;
        }
        CodeReviewCommit.CodeReviewRevWalk rw = (CodeReviewCommit.CodeReviewRevWalk)ctx.getRevWalk();
        Change.Id id = this.getId();
        Collection<Ref> refs = ctx.getRepository().getRefDatabase().getRefs(id.toRefPrefix()).values();
        ArrayList<CodeReviewCommit> commits = new ArrayList<CodeReviewCommit>(refs.size());
        for (Ref ref : refs) {
            PatchSet.Id psId = PatchSet.Id.fromRef(ref.getName());
            if (psId == null) continue;
            try {
                CodeReviewCommit c2 = rw.parseCommit(ref.getObjectId());
                c2.setPatchsetId(psId);
                commits.add(c2);
            }
            catch (IncorrectObjectTypeException | MissingObjectException e) {}
        }
        Collections.sort(commits, ReviewDbUtil.intKeyOrdering().reverse().onResultOf(c -> c.getPatchsetId()));
        CodeReviewCommit result = MergeUtil.findAnyMergedInto(rw, commits, tip);
        if (result == null) {
            return null;
        }
        rw.parseBody(result);
        result.add(this.args.canMergeFlag);
        PatchSet.Id psId = result.getPatchsetId();
        result.copyFrom(this.toMerge);
        result.setPatchsetId(psId);
        result.setStatusCode(CommitMergeStatus.ALREADY_MERGED);
        this.args.commitStatus.put(result);
        return result;
    }

    @Override
    public final boolean updateChange(ChangeContext ctx) throws Exception {
        this.logDebug("{}#updateChange for change {}", this.getClass().getSimpleName(), this.toMerge.change().getId());
        this.toMerge.setControl(ctx.getControl());
        PatchSet.Id oldPsId = Preconditions.checkNotNull(this.toMerge.getPatchsetId());
        if (this.alreadyMerged != null) {
            this.alreadyMerged.setControl(ctx.getControl());
            this.mergedPatchSet = this.getOrCreateAlreadyMergedPatchSet(ctx);
            PatchSet.Id newPsId = this.mergedPatchSet.getId();
        } else {
            PatchSet newPatchSet = this.updateChangeImpl(ctx);
            PatchSet.Id newPsId = Preconditions.checkNotNull(ctx.getChange().currentPatchSetId());
            if (newPatchSet == null) {
                Preconditions.checkState(oldPsId.equals(newPsId), "patch set advanced from %s to %s but updateChangeImpl did not return new patch set instance", (Object)oldPsId, (Object)newPsId);
                this.mergedPatchSet = Preconditions.checkNotNull(this.args.psUtil.get(ctx.getDb(), ctx.getNotes(), oldPsId), "missing old patch set %s", (Object)oldPsId);
            } else {
                PatchSet.Id n = newPatchSet.getId();
                Preconditions.checkState(!n.equals(oldPsId) && n.equals(newPsId), "current patch was %s and is now %s, but updateChangeImpl returned new patch set instance at %s", (Object)oldPsId, (Object)newPsId, (Object)n);
                this.mergedPatchSet = newPatchSet;
            }
        }
        Change c = ctx.getChange();
        Change.Id id = c.getId();
        CodeReviewCommit commit = this.args.commitStatus.get(id);
        Preconditions.checkNotNull(commit, "missing commit for change " + id);
        CommitMergeStatus s = commit.getStatusCode();
        Preconditions.checkNotNull(s, "status not set for change " + id + " expected to previously fail fast");
        this.logDebug("Status of change {} ({}) on {}: {}", new Object[]{id, commit.name(), c.getDest(), s});
        this.setApproval(ctx, this.args.caller);
        this.mergeResultRev = this.alreadyMerged == null ? this.args.mergeTip.getMergeResults().get(commit) : this.alreadyMerged;
        try {
            this.setMerged(ctx, this.message(ctx, commit, s));
        }
        catch (OrmException err) {
            String msg = "Error updating change status for " + id;
            log.error(msg, err);
            this.args.commitStatus.logProblem(id, msg);
        }
        this.updatedChange = c;
        return true;
    }

    private PatchSet getOrCreateAlreadyMergedPatchSet(ChangeContext ctx) throws IOException, OrmException {
        PatchSet.Id psId = this.alreadyMerged.getPatchsetId();
        this.logDebug("Fixing up already-merged patch set {}", psId);
        PatchSet prevPs = this.args.psUtil.current(ctx.getDb(), ctx.getNotes());
        ctx.getRevWalk().parseBody(this.alreadyMerged);
        ctx.getChange().setCurrentPatchSet(psId, this.alreadyMerged.getShortMessage(), ctx.getChange().getOriginalSubject());
        PatchSet existing = this.args.psUtil.get(ctx.getDb(), ctx.getNotes(), psId);
        if (existing != null) {
            this.logDebug("Patch set row exists, only updating change", new Object[0]);
            return existing;
        }
        List<String> groups = prevPs != null ? prevPs.getGroups() : GroupCollector.getDefaultGroups(this.alreadyMerged);
        return this.args.psUtil.insert(ctx.getDb(), ctx.getRevWalk(), ctx.getUpdate(psId), psId, this.alreadyMerged, false, groups, null, null);
    }

    private void setApproval(ChangeContext ctx, IdentifiedUser user) throws OrmException {
        Change.Id id = ctx.getChange().getId();
        List<SubmitRecord> records = this.args.commitStatus.getSubmitRecords(id);
        PatchSet.Id oldPsId = this.toMerge.getPatchsetId();
        PatchSet.Id newPsId = ctx.getChange().currentPatchSetId();
        this.logDebug("Add approval for " + id, new Object[0]);
        ChangeUpdate origPsUpdate = ctx.getUpdate(oldPsId);
        origPsUpdate.putReviewer(user.getAccountId(), ReviewerStateInternal.REVIEWER);
        LabelNormalizer.Result normalized = this.approve(ctx, origPsUpdate);
        ChangeUpdate newPsUpdate = ctx.getUpdate(newPsId);
        newPsUpdate.merge(this.args.submissionId, records);
        if (!newPsId.equals(oldPsId)) {
            this.saveApprovals(normalized, ctx, newPsUpdate, true);
            this.submitter = SubmitStrategyOp.convertPatchSet(newPsId).apply(this.submitter);
        }
    }

    private LabelNormalizer.Result approve(ChangeContext ctx, ChangeUpdate update) throws OrmException {
        PatchSet.Id psId = update.getPatchSetId();
        HashMap<PatchSetApproval.Key, PatchSetApproval> byKey = new HashMap<PatchSetApproval.Key, PatchSetApproval>();
        for (PatchSetApproval psa : this.args.approvalsUtil.byPatchSet(ctx.getDb(), ctx.getControl(), psId)) {
            byKey.put(psa.getKey(), psa);
        }
        this.submitter = ApprovalsUtil.newApproval(psId, ctx.getUser(), LabelId.legacySubmit(), 1, ctx.getWhen());
        byKey.put(this.submitter.getKey(), this.submitter);
        LabelNormalizer.Result normalized = this.args.labelNormalizer.normalize(ctx.getControl(), byKey.values());
        update.putApproval(this.submitter.getLabel(), this.submitter.getValue());
        this.saveApprovals(normalized, ctx, update, false);
        return normalized;
    }

    private void saveApprovals(LabelNormalizer.Result normalized, ChangeContext ctx, ChangeUpdate update, boolean includeUnchanged) throws OrmException {
        PatchSet.Id psId = update.getPatchSetId();
        ctx.getDb().patchSetApprovals().upsert(SubmitStrategyOp.convertPatchSet(normalized.getNormalized(), psId));
        ctx.getDb().patchSetApprovals().upsert(SubmitStrategyOp.zero(SubmitStrategyOp.convertPatchSet(normalized.deleted(), psId)));
        for (PatchSetApproval psa : normalized.updated()) {
            update.putApprovalFor(psa.getAccountId(), psa.getLabel(), psa.getValue());
        }
        for (PatchSetApproval psa : normalized.deleted()) {
            update.removeApprovalFor(psa.getAccountId(), psa.getLabel());
        }
        for (PatchSetApproval psa : normalized.unchanged()) {
            if (!includeUnchanged && !psa.isLegacySubmit()) continue;
            this.logDebug("Adding submit label " + psa, new Object[0]);
            update.putApprovalFor(psa.getAccountId(), psa.getLabel(), psa.getValue());
        }
    }

    private static Function<PatchSetApproval, PatchSetApproval> convertPatchSet(PatchSet.Id psId) {
        return psa -> {
            if (psa.getPatchSetId().equals(psId)) {
                return psa;
            }
            return new PatchSetApproval(psId, (PatchSetApproval)psa);
        };
    }

    private static Iterable<PatchSetApproval> convertPatchSet(Iterable<PatchSetApproval> approvals, PatchSet.Id psId) {
        return Iterables.transform(approvals, SubmitStrategyOp.convertPatchSet(psId));
    }

    private static Iterable<PatchSetApproval> zero(Iterable<PatchSetApproval> approvals) {
        return Iterables.transform(approvals, a -> {
            PatchSetApproval copy = new PatchSetApproval(a.getPatchSetId(), (PatchSetApproval)a);
            copy.setValue((short)0);
            return copy;
        });
    }

    private String getByAccountName() {
        Preconditions.checkNotNull(this.submitter, "getByAccountName called before submitter populated");
        Account account = this.args.accountCache.get(this.submitter.getAccountId()).getAccount();
        if (account != null && account.getFullName() != null) {
            return " by " + account.getFullName();
        }
        return "";
    }

    private ChangeMessage message(ChangeContext ctx, CodeReviewCommit commit, CommitMergeStatus s) throws OrmException {
        Preconditions.checkNotNull(s, "CommitMergeStatus may not be null");
        String txt = s.getMessage();
        if (s == CommitMergeStatus.CLEAN_MERGE) {
            return this.message(ctx, commit.getPatchsetId(), txt + this.getByAccountName());
        }
        if (s == CommitMergeStatus.CLEAN_REBASE || s == CommitMergeStatus.CLEAN_PICK) {
            return this.message(ctx, commit.getPatchsetId(), txt + " as " + commit.name() + this.getByAccountName());
        }
        if (s == CommitMergeStatus.SKIPPED_IDENTICAL_TREE) {
            return this.message(ctx, commit.getPatchsetId(), txt);
        }
        if (s == CommitMergeStatus.ALREADY_MERGED) {
            switch (this.args.submitType) {
                case FAST_FORWARD_ONLY: 
                case MERGE_ALWAYS: 
                case MERGE_IF_NECESSARY: {
                    return this.message(ctx, commit, CommitMergeStatus.CLEAN_MERGE);
                }
                case CHERRY_PICK: {
                    return this.message(ctx, commit, CommitMergeStatus.CLEAN_PICK);
                }
                case REBASE_IF_NECESSARY: 
                case REBASE_ALWAYS: {
                    return this.message(ctx, commit, CommitMergeStatus.CLEAN_REBASE);
                }
            }
            throw new IllegalStateException("unexpected submit type " + this.args.submitType.toString() + " for change " + commit.change().getId());
        }
        throw new IllegalStateException("unexpected status " + (Object)((Object)s) + " for change " + commit.change().getId() + "; expected to previously fail fast");
    }

    private ChangeMessage message(ChangeContext ctx, PatchSet.Id psId, String body) {
        return ChangeMessagesUtil.newMessage(psId, ctx.getUser(), ctx.getWhen(), body, "autogenerated:gerrit:merged");
    }

    private void setMerged(ChangeContext ctx, ChangeMessage msg) throws OrmException {
        Change c = ctx.getChange();
        ReviewDb db = ctx.getDb();
        this.logDebug("Setting change {} merged", c.getId());
        c.setStatus(Change.Status.MERGED);
        c.setSubmissionId(this.args.submissionId.toStringForStorage());
        if (msg != null) {
            this.args.cmUtil.addChangeMessage(db, ctx.getUpdate(msg.getPatchSetId()), msg);
        }
    }

    @Override
    public final void postUpdate(Context ctx) throws Exception {
        this.postUpdateImpl(ctx);
        if (this.command != null) {
            this.args.tagCache.updateFastForward(this.getProject(), this.command.getRefName(), this.command.getOldId(), this.command.getNewId());
            if ("refs/meta/config".equals(this.getDest().get())) {
                this.args.projectCache.evict(this.getProject());
                ProjectState p = this.args.projectCache.get(this.getProject());
                try (Repository git = this.args.repoManager.openRepository(this.getProject());){
                    git.setGitwebDescription(p.getProject().getDescription());
                }
                catch (IOException e) {
                    log.error("cannot update description of " + p.getProject().getName(), e);
                }
            }
        }
        try {
            this.args.mergedSenderFactory.create(ctx.getProject(), this.getId(), this.submitter.getAccountId(), this.args.notifyHandling, this.args.accountsToNotify).sendAsync();
        }
        catch (Exception e) {
            log.error("Cannot email merged notification for " + this.getId(), e);
        }
        if (this.mergeResultRev != null && !this.args.dryrun) {
            this.args.changeMerged.fire(this.updatedChange, this.mergedPatchSet, this.args.accountCache.get(this.submitter.getAccountId()).getAccount(), this.args.mergeTip.getCurrentTip().name(), ctx.getWhen());
        }
    }

    protected void updateRepoImpl(RepoContext ctx) throws Exception {
    }

    protected PatchSet updateChangeImpl(ChangeContext ctx) throws Exception {
        return null;
    }

    protected void postUpdateImpl(Context ctx) throws Exception {
    }

    protected CodeReviewCommit amendGitlink(CodeReviewCommit commit) throws IntegrationException {
        if (!this.args.submoduleOp.hasSubscription(this.args.destBranch)) {
            return commit;
        }
        try {
            return this.args.submoduleOp.composeGitlinksCommit(this.args.destBranch, commit);
        }
        catch (SubmoduleException | IOException e) {
            throw new IntegrationException("cannot update gitlink for the commit at branch: " + this.args.destBranch);
        }
    }

    protected final void logDebug(String msg, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(this.args.submissionId + msg, args);
        }
    }

    protected final void logWarn(String msg, Throwable t) {
        if (log.isWarnEnabled()) {
            log.warn(this.args.submissionId + msg, t);
        }
    }

    protected void logError(String msg, Throwable t) {
        if (log.isErrorEnabled()) {
            if (t != null) {
                log.error(this.args.submissionId + msg, t);
            } else {
                log.error(this.args.submissionId + msg);
            }
        }
    }

    protected void logError(String msg) {
        this.logError(msg, null);
    }
}

