/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.GroupResource;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class Index
implements RestModifyView<GroupResource, Input> {
    private final GroupCache groupCache;

    @Inject
    Index(GroupCache groupCache) {
        this.groupCache = groupCache;
    }

    public Response<?> apply(GroupResource rsrc, Input input) throws IOException, AuthException, UnprocessableEntityException {
        if (!rsrc.getControl().isOwner()) {
            throw new AuthException("not allowed to index group");
        }
        AccountGroup group = GroupDescriptions.toAccountGroup(rsrc.getGroup());
        if (group == null) {
            throw new UnprocessableEntityException(String.format("External Group Not Allowed: %s", rsrc.getGroupUUID().get()));
        }
        this.groupCache.evict(group);
        return Response.none();
    }

    public static class Input {
    }
}

