/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.extensions.client.ListGroupsOption;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.index.group.GroupIndex;
import com.google.gerrit.server.index.group.GroupIndexCollection;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.QueryResult;
import com.google.gerrit.server.query.group.GroupQueryBuilder;
import com.google.gerrit.server.query.group.GroupQueryProcessor;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.kohsuke.args4j.Option;

public class QueryGroups
implements RestReadView<TopLevelResource> {
    private final GroupIndexCollection indexes;
    private final GroupQueryBuilder queryBuilder;
    private final GroupQueryProcessor queryProcessor;
    private final GroupJson json;
    private String query;
    private int limit;
    private int start;
    private EnumSet<ListGroupsOption> options = EnumSet.noneOf(ListGroupsOption.class);

    @Option(name="--query2", aliases={"-q2"}, usage="group query")
    public void setQuery(String query) {
        this.query = query;
    }

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of groups to list")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Option(name="--start", aliases={"-S"}, metaVar="CNT", usage="number of groups to skip")
    public void setStart(int start) {
        this.start = start;
    }

    @Option(name="-o", usage="Output options per group")
    public void addOption(ListGroupsOption o) {
        this.options.add(o);
    }

    @Option(name="-O", usage="Output option flags, in hex")
    public void setOptionFlagsHex(String hex) {
        this.options.addAll(ListGroupsOption.fromBits(Integer.parseInt(hex, 16)));
    }

    @Inject
    protected QueryGroups(GroupIndexCollection indexes, GroupQueryBuilder queryBuilder, GroupQueryProcessor queryProcessor, GroupJson json) {
        this.indexes = indexes;
        this.queryBuilder = queryBuilder;
        this.queryProcessor = queryProcessor;
        this.json = json;
    }

    public List<GroupInfo> apply(TopLevelResource resource) throws BadRequestException, MethodNotAllowedException, OrmException {
        if (Strings.isNullOrEmpty(this.query)) {
            throw new BadRequestException("missing query field");
        }
        GroupIndex searchIndex = (GroupIndex)this.indexes.getSearchIndex();
        if (searchIndex == null) {
            throw new MethodNotAllowedException("no group index");
        }
        if (this.start != 0) {
            this.queryProcessor.setStart(this.start);
        }
        if (this.limit != 0) {
            this.queryProcessor.setLimit(this.limit);
        }
        try {
            QueryResult result = this.queryProcessor.query(this.queryBuilder.parse(this.query));
            List groups = result.entities();
            ArrayList<GroupInfo> groupInfos = Lists.newArrayListWithCapacity(groups.size());
            this.json.addOptions(this.options);
            for (AccountGroup group : groups) {
                groupInfos.add(this.json.format(GroupDescriptions.forAccountGroup(group)));
            }
            if (!groupInfos.isEmpty() && result.more()) {
                groupInfos.get((int)(groupInfos.size() - 1))._moreGroups = true;
            }
            return groupInfos;
        }
        catch (QueryParseException e) {
            throw new BadRequestException(e.getMessage());
        }
    }
}

