/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.server.index.Index;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public abstract class IndexCollection<K, V, I extends Index<K, V>>
implements LifecycleListener {
    private final CopyOnWriteArrayList<I> writeIndexes = Lists.newCopyOnWriteArrayList();
    private final AtomicReference<I> searchIndex = new AtomicReference();

    protected IndexCollection() {
    }

    public I getSearchIndex() {
        return (I)((Index)this.searchIndex.get());
    }

    public void setSearchIndex(I index) {
        Index old = (Index)this.searchIndex.getAndSet(index);
        if (old != null && old != index && !this.writeIndexes.contains(old)) {
            old.close();
        }
    }

    public Collection<I> getWriteIndexes() {
        return Collections.unmodifiableCollection(this.writeIndexes);
    }

    public synchronized I addWriteIndex(I index) {
        int version = index.getSchema().getVersion();
        for (int i = 0; i < this.writeIndexes.size(); ++i) {
            if (((Index)this.writeIndexes.get(i)).getSchema().getVersion() != version) continue;
            return (I)((Index)this.writeIndexes.set(i, index));
        }
        this.writeIndexes.add(index);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeWriteIndex(int version) {
        int removeIndex = -1;
        for (int i = 0; i < this.writeIndexes.size(); ++i) {
            if (((Index)this.writeIndexes.get(i)).getSchema().getVersion() != version) continue;
            removeIndex = i;
            break;
        }
        if (removeIndex >= 0) {
            try {
                ((Index)this.writeIndexes.get(removeIndex)).close();
            }
            finally {
                this.writeIndexes.remove(removeIndex);
            }
        }
    }

    public I getWriteIndex(int version) {
        for (Index i : this.writeIndexes) {
            if (i.getSchema().getVersion() != version) continue;
            return (I)i;
        }
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        Index read = (Index)this.searchIndex.get();
        if (read != null) {
            read.close();
        }
        for (Index write : this.writeIndexes) {
            if (write == read) continue;
            write.close();
        }
    }
}

