/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.account;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.events.AccountIndexedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.index.Index;
import com.google.gerrit.server.index.account.AccountIndex;
import com.google.gerrit.server.index.account.AccountIndexCollection;
import com.google.gerrit.server.index.account.AccountIndexer;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

public class AccountIndexerImpl
implements AccountIndexer {
    private final AccountCache byIdCache;
    private final DynamicSet<AccountIndexedListener> indexedListener;
    private final AccountIndexCollection indexes;
    private final AccountIndex index;

    @AssistedInject
    AccountIndexerImpl(AccountCache byIdCache, DynamicSet<AccountIndexedListener> indexedListener, @Assisted AccountIndexCollection indexes) {
        this.byIdCache = byIdCache;
        this.indexedListener = indexedListener;
        this.indexes = indexes;
        this.index = null;
    }

    @AssistedInject
    AccountIndexerImpl(AccountCache byIdCache, DynamicSet<AccountIndexedListener> indexedListener, @Assisted AccountIndex index) {
        this.byIdCache = byIdCache;
        this.indexedListener = indexedListener;
        this.indexes = null;
        this.index = index;
    }

    @Override
    public void index(Account.Id id) throws IOException {
        for (Index index : this.getWriteIndexes()) {
            AccountState accountState = this.byIdCache.getOrNull(id);
            if (accountState != null) {
                index.replace(accountState);
                continue;
            }
            index.delete(id);
        }
        this.fireAccountIndexedEvent(id.get());
    }

    private void fireAccountIndexedEvent(int id) {
        for (AccountIndexedListener listener : this.indexedListener) {
            listener.onAccountIndexed(id);
        }
    }

    private Collection<AccountIndex> getWriteIndexes() {
        if (this.indexes != null) {
            return this.indexes.getWriteIndexes();
        }
        return this.index != null ? Collections.singleton(this.index) : ImmutableSet.of();
    }

    public static interface Factory {
        public AccountIndexerImpl create(AccountIndexCollection var1);

        public AccountIndexerImpl create(@Nullable AccountIndex var1);
    }
}

