/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.common.collect.Iterables;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.OutgoingEmail;
import com.google.gerrit.server.mail.send.ProjectWatch;
import com.google.gwtorm.server.OrmException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationEmail
extends OutgoingEmail {
    private static final Logger log = LoggerFactory.getLogger(NotificationEmail.class);
    protected Branch.NameKey branch;

    protected NotificationEmail(EmailArguments ea, String mc, Branch.NameKey branch) {
        super(ea, mc);
        this.branch = branch;
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.setListIdHeader();
    }

    private void setListIdHeader() throws EmailException {
        this.setVHeader("List-Id", "<$email.listId.replace('@', '.')>");
        if (this.getSettingsUrl() != null) {
            this.setVHeader("List-Unsubscribe", "<$email.settingsUrl>");
        }
    }

    public String getListId() throws EmailException {
        return this.velocify("gerrit-$projectName.replace('/', '-')@$email.gerritHost");
    }

    protected void includeWatchers(WatchConfig.NotifyType type) {
        this.includeWatchers(type, true);
    }

    protected void includeWatchers(WatchConfig.NotifyType type, boolean includeWatchersFromNotifyConfig) {
        try {
            ProjectWatch.Watchers matching = this.getWatchers(type, includeWatchersFromNotifyConfig);
            this.add(RecipientType.TO, matching.to);
            this.add(RecipientType.CC, matching.cc);
            this.add(RecipientType.BCC, matching.bcc);
        }
        catch (OrmException err) {
            log.warn("Cannot BCC watchers for " + (Object)((Object)type), err);
        }
    }

    protected abstract ProjectWatch.Watchers getWatchers(WatchConfig.NotifyType var1, boolean var2) throws OrmException;

    protected void add(RecipientType type, ProjectWatch.Watchers.List list) {
        for (Account.Id user : list.accounts) {
            this.add(type, user);
        }
        for (Address addr : list.emails) {
            this.add(type, addr);
        }
    }

    public String getSshHost() {
        String host = Iterables.getFirst(this.args.sshAddresses, null);
        if (host == null) {
            return null;
        }
        if (host.startsWith("*:")) {
            return this.getGerritHost() + host.substring(1);
        }
        return host;
    }

    @Override
    protected void setupVelocityContext() {
        super.setupVelocityContext();
        this.velocityContext.put("projectName", this.branch.getParentKey().get());
        this.velocityContext.put("branch", this.branch);
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        String projectName = this.branch.getParentKey().get();
        this.soyContext.put("projectName", projectName);
        this.soyContext.put("shortProjectName", projectName.replaceAll("/.*/", "..."));
        this.soyContextEmailData.put("sshHost", this.getSshHost());
        HashMap<String, String> branchData = new HashMap<String, String>();
        branchData.put("shortName", this.branch.getShortName());
        this.soyContext.put("branch", branchData);
        this.footers.add("Gerrit-Project: " + this.branch.getParentKey().get());
        this.footers.add("Gerrit-Branch: " + this.branch.getShortName());
    }
}

