/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.CommentDetail;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.edit.ChangeEditUtil;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LargeObjectException;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListKey;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchScriptBuilder;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchScriptFactory
implements Callable<PatchScript> {
    private static final Logger log = LoggerFactory.getLogger(PatchScriptFactory.class);
    private final GitRepositoryManager repoManager;
    private final PatchSetUtil psUtil;
    private final Provider<PatchScriptBuilder> builderFactory;
    private final PatchListCache patchListCache;
    private final ReviewDb db;
    private final CommentsUtil commentsUtil;
    private final String fileName;
    @Nullable
    private final PatchSet.Id psa;
    private final int parentNum;
    private final PatchSet.Id psb;
    private final DiffPreferencesInfo diffPrefs;
    private final ChangeEditUtil editReader;
    private Optional<ChangeEdit> edit;
    private final Change.Id changeId;
    private boolean loadHistory = true;
    private boolean loadComments = true;
    private Change change;
    private Project.NameKey project;
    private ChangeControl control;
    private ObjectId aId;
    private ObjectId bId;
    private List<Patch> history;
    private CommentDetail comments;

    @AssistedInject
    PatchScriptFactory(GitRepositoryManager grm, PatchSetUtil psUtil, Provider<PatchScriptBuilder> builderFactory, PatchListCache patchListCache, ReviewDb db, CommentsUtil commentsUtil, ChangeEditUtil editReader, @Assisted ChangeControl control, @Assisted String fileName, @Assisted(value="patchSetA") @Nullable PatchSet.Id patchSetA, @Assisted(value="patchSetB") PatchSet.Id patchSetB, @Assisted DiffPreferencesInfo diffPrefs) {
        this.repoManager = grm;
        this.psUtil = psUtil;
        this.builderFactory = builderFactory;
        this.patchListCache = patchListCache;
        this.db = db;
        this.control = control;
        this.commentsUtil = commentsUtil;
        this.editReader = editReader;
        this.fileName = fileName;
        this.psa = patchSetA;
        this.parentNum = -1;
        this.psb = patchSetB;
        this.diffPrefs = diffPrefs;
        this.changeId = patchSetB.getParentKey();
    }

    @AssistedInject
    PatchScriptFactory(GitRepositoryManager grm, PatchSetUtil psUtil, Provider<PatchScriptBuilder> builderFactory, PatchListCache patchListCache, ReviewDb db, CommentsUtil commentsUtil, ChangeEditUtil editReader, @Assisted ChangeControl control, @Assisted String fileName, @Assisted int parentNum, @Assisted PatchSet.Id patchSetB, @Assisted DiffPreferencesInfo diffPrefs) {
        this.repoManager = grm;
        this.psUtil = psUtil;
        this.builderFactory = builderFactory;
        this.patchListCache = patchListCache;
        this.db = db;
        this.control = control;
        this.commentsUtil = commentsUtil;
        this.editReader = editReader;
        this.fileName = fileName;
        this.psa = null;
        this.parentNum = parentNum;
        this.psb = patchSetB;
        this.diffPrefs = diffPrefs;
        this.changeId = patchSetB.getParentKey();
        Preconditions.checkArgument(parentNum >= 0, "parentNum must be >= 0");
    }

    public void setLoadHistory(boolean load) {
        this.loadHistory = load;
    }

    public void setLoadComments(boolean load) {
        this.loadComments = load;
    }

    /*
     * Exception decompiling
     */
    @Override
    public PatchScript call() throws OrmException, LargeObjectException, AuthException, InvalidChangeOperationException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PatchListKey keyFor(DiffPreferencesInfo.Whitespace whitespace) {
        if (this.parentNum < 0) {
            return new PatchListKey(this.aId, (AnyObjectId)this.bId, whitespace);
        }
        return PatchListKey.againstParentNum(this.parentNum + 1, this.bId, whitespace);
    }

    private PatchList listFor(PatchListKey key) throws PatchListNotAvailableException {
        return this.patchListCache.get(key, this.project);
    }

    private PatchScriptBuilder newBuilder(PatchList list, Repository git) {
        PatchScriptBuilder b = this.builderFactory.get();
        b.setRepository(git, this.project);
        b.setChange(this.change);
        b.setDiffPrefs(this.diffPrefs);
        b.setTrees(list.getComparisonType(), list.getOldId(), list.getNewId());
        return b;
    }

    private ObjectId toObjectId(PatchSet ps) throws NoSuchChangeException, AuthException, NoSuchChangeException, IOException, OrmException {
        if (ps.getId().get() == 0) {
            return this.getEditRev();
        }
        if (ps.getRevision() == null || ps.getRevision().get() == null) {
            throw new NoSuchChangeException(this.changeId);
        }
        try {
            return ObjectId.fromString(ps.getRevision().get());
        }
        catch (IllegalArgumentException e) {
            log.error("Patch set " + ps.getId() + " has invalid revision");
            throw new NoSuchChangeException(this.changeId, (Throwable)e);
        }
    }

    private ObjectId getEditRev() throws AuthException, NoSuchChangeException, IOException, OrmException {
        this.edit = this.editReader.byChange(this.change);
        if (this.edit.isPresent()) {
            return this.edit.get().getRef().getObjectId();
        }
        throw new NoSuchChangeException(this.change.getId());
    }

    private void validatePatchSetId(PatchSet.Id psId) throws NoSuchChangeException {
        if (psId != null && !this.changeId.equals(psId.getParentKey())) {
            throw new NoSuchChangeException(this.changeId);
        }
    }

    private void loadCommentsAndHistory(ChangeNotes notes, Patch.ChangeType changeType, String oldName, String newName) throws OrmException {
        HashMap<Patch.Key, Patch> byKey = new HashMap<Patch.Key, Patch>();
        if (this.loadHistory) {
            this.history = new ArrayList<Patch>();
            for (PatchSet ps : this.psUtil.byChange(this.db, notes)) {
                if (!this.control.isPatchVisible(ps, this.db)) continue;
                String name = this.fileName;
                if (this.psa != null) {
                    switch (changeType) {
                        case COPIED: 
                        case RENAMED: {
                            if (!ps.getId().equals(this.psa)) break;
                            name = oldName;
                            break;
                        }
                    }
                }
                Patch p = new Patch(new Patch.Key(ps.getId(), name));
                this.history.add(p);
                byKey.put(p.getKey(), p);
            }
            if (this.edit != null && this.edit.isPresent()) {
                Patch p = new Patch(new Patch.Key(new PatchSet.Id(this.psb.getParentKey(), 0), this.fileName));
                this.history.add(p);
                byKey.put(p.getKey(), p);
            }
        }
        if (this.loadComments && this.edit == null) {
            this.comments = new CommentDetail(this.psa, this.psb);
            switch (changeType) {
                case MODIFIED: 
                case ADDED: {
                    this.loadPublished(byKey, newName);
                    break;
                }
                case DELETED: {
                    this.loadPublished(byKey, newName);
                    break;
                }
                case COPIED: 
                case RENAMED: {
                    if (this.psa != null) {
                        this.loadPublished(byKey, oldName);
                    }
                    this.loadPublished(byKey, newName);
                    break;
                }
            }
            CurrentUser user = this.control.getUser();
            if (user.isIdentifiedUser()) {
                Account.Id me = user.getAccountId();
                switch (changeType) {
                    case MODIFIED: 
                    case ADDED: {
                        this.loadDrafts(byKey, me, newName);
                        break;
                    }
                    case DELETED: {
                        this.loadDrafts(byKey, me, newName);
                        break;
                    }
                    case COPIED: 
                    case RENAMED: {
                        if (this.psa != null) {
                            this.loadDrafts(byKey, me, oldName);
                        }
                        this.loadDrafts(byKey, me, newName);
                        break;
                    }
                }
            }
        }
    }

    private void loadPublished(Map<Patch.Key, Patch> byKey, String file) throws OrmException {
        ChangeNotes notes = this.control.getNotes();
        for (Comment c : this.commentsUtil.publishedByChangeFile(this.db, notes, this.changeId, file)) {
            this.comments.include(this.change.getId(), c);
            PatchSet.Id psId = new PatchSet.Id(this.change.getId(), c.key.patchSetId);
            Patch.Key pKey = new Patch.Key(psId, c.key.filename);
            Patch p = byKey.get(pKey);
            if (p == null) continue;
            p.setCommentCount(p.getCommentCount() + 1);
        }
    }

    private void loadDrafts(Map<Patch.Key, Patch> byKey, Account.Id me, String file) throws OrmException {
        for (Comment c : this.commentsUtil.draftByChangeFileAuthor(this.db, this.control.getNotes(), file, me)) {
            this.comments.include(this.change.getId(), c);
            PatchSet.Id psId = new PatchSet.Id(this.change.getId(), c.key.patchSetId);
            Patch.Key pKey = new Patch.Key(psId, c.key.filename);
            Patch p = byKey.get(pKey);
            if (p == null) continue;
            p.setDraftCount(p.getDraftCount() + 1);
        }
    }

    public static interface Factory {
        public PatchScriptFactory create(ChangeControl var1, String var2, @Assisted(value="patchSetA") PatchSet.Id var3, @Assisted(value="patchSetB") PatchSet.Id var4, DiffPreferencesInfo var5);

        public PatchScriptFactory create(ChangeControl var1, String var2, int var3, PatchSet.Id var4, DiffPreferencesInfo var5);
    }
}

