/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestCollection;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.project.CreateProject;
import com.google.gerrit.server.project.ListProjects;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class ProjectsCollection
implements RestCollection<TopLevelResource, ProjectResource>,
AcceptsCreate<TopLevelResource> {
    private final DynamicMap<RestView<ProjectResource>> views;
    private final Provider<ListProjects> list;
    private final ProjectControl.GenericFactory controlFactory;
    private final Provider<CurrentUser> user;
    private final CreateProject.Factory createProjectFactory;

    @Inject
    ProjectsCollection(DynamicMap<RestView<ProjectResource>> views, Provider<ListProjects> list, ProjectControl.GenericFactory controlFactory, CreateProject.Factory factory, Provider<CurrentUser> user) {
        this.views = views;
        this.list = list;
        this.controlFactory = controlFactory;
        this.user = user;
        this.createProjectFactory = factory;
    }

    @Override
    public RestView<TopLevelResource> list() {
        return this.list.get().setFormat(OutputFormat.JSON);
    }

    @Override
    public ProjectResource parse(TopLevelResource parent, IdString id) throws ResourceNotFoundException, IOException {
        ProjectResource rsrc = this._parse(id.get(), true);
        if (rsrc == null) {
            throw new ResourceNotFoundException(id);
        }
        return rsrc;
    }

    public ProjectResource parse(String id) throws UnprocessableEntityException, IOException {
        return this.parse(id, true);
    }

    public ProjectResource parse(String id, boolean checkVisibility) throws UnprocessableEntityException, IOException {
        ProjectResource rsrc = this._parse(id, checkVisibility);
        if (rsrc == null) {
            throw new UnprocessableEntityException(String.format("Project Not Found: %s", id));
        }
        return rsrc;
    }

    private ProjectResource _parse(String id, boolean checkVisibility) throws IOException {
        ProjectControl ctl;
        if (id.endsWith(".git")) {
            id = id.substring(0, id.length() - ".git".length());
        }
        try {
            ctl = this.controlFactory.controlFor(new Project.NameKey(id), this.user.get());
        }
        catch (NoSuchProjectException e) {
            return null;
        }
        if (checkVisibility && !ctl.isVisible() && !ctl.isOwner()) {
            return null;
        }
        return new ProjectResource(ctl);
    }

    @Override
    public DynamicMap<RestView<ProjectResource>> views() {
        return this.views;
    }

    public CreateProject create(TopLevelResource parent, IdString name) {
        return this.createProjectFactory.create(name.get());
    }
}

