/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.api.projects.ConfigInfo;
import com.google.gerrit.extensions.api.projects.ConfigInput;
import com.google.gerrit.extensions.api.projects.ConfigValue;
import com.google.gerrit.extensions.api.projects.ProjectConfigEntryType;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.EnableSignedPush;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.ConfigInfoImpl;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PutConfig
implements RestModifyView<ProjectResource, ConfigInput> {
    private static final Logger log = LoggerFactory.getLogger(PutConfig.class);
    private final boolean serverEnableSignedPush;
    private final Provider<MetaDataUpdate.User> metaDataUpdateFactory;
    private final ProjectCache projectCache;
    private final ProjectState.Factory projectStateFactory;
    private final DynamicMap<ProjectConfigEntry> pluginConfigEntries;
    private final PluginConfigFactory cfgFactory;
    private final AllProjectsName allProjects;
    private final DynamicMap<RestView<ProjectResource>> views;
    private final Provider<CurrentUser> user;

    @Inject
    PutConfig(@EnableSignedPush boolean serverEnableSignedPush, Provider<MetaDataUpdate.User> metaDataUpdateFactory, ProjectCache projectCache, ProjectState.Factory projectStateFactory, DynamicMap<ProjectConfigEntry> pluginConfigEntries, PluginConfigFactory cfgFactory, AllProjectsName allProjects, DynamicMap<RestView<ProjectResource>> views, Provider<CurrentUser> user) {
        this.serverEnableSignedPush = serverEnableSignedPush;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.projectCache = projectCache;
        this.projectStateFactory = projectStateFactory;
        this.pluginConfigEntries = pluginConfigEntries;
        this.cfgFactory = cfgFactory;
        this.allProjects = allProjects;
        this.views = views;
        this.user = user;
    }

    public ConfigInfo apply(ProjectResource rsrc, ConfigInput input) throws ResourceNotFoundException, BadRequestException, ResourceConflictException {
        if (!rsrc.getControl().isOwner()) {
            throw new ResourceNotFoundException(rsrc.getName());
        }
        return this.apply(rsrc.getControl(), input);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigInfo apply(ProjectControl ctrl, ConfigInput input) throws ResourceNotFoundException, BadRequestException, ResourceConflictException {
        Project.NameKey projectName = ctrl.getProject().getNameKey();
        if (input == null) {
            throw new BadRequestException("config is required");
        }
        try (MetaDataUpdate md = this.metaDataUpdateFactory.get().create(projectName);){
            ProjectConfig projectConfig = ProjectConfig.read(md);
            Project p = projectConfig.getProject();
            p.setDescription(Strings.emptyToNull(input.description));
            if (input.useContributorAgreements != null) {
                p.setUseContributorAgreements(input.useContributorAgreements);
            }
            if (input.useContentMerge != null) {
                p.setUseContentMerge(input.useContentMerge);
            }
            if (input.useSignedOffBy != null) {
                p.setUseSignedOffBy(input.useSignedOffBy);
            }
            if (input.createNewChangeForAllNotInTarget != null) {
                p.setCreateNewChangeForAllNotInTarget(input.createNewChangeForAllNotInTarget);
            }
            if (input.requireChangeId != null) {
                p.setRequireChangeID(input.requireChangeId);
            }
            if (this.serverEnableSignedPush) {
                if (input.enableSignedPush != null) {
                    p.setEnableSignedPush(input.enableSignedPush);
                }
                if (input.requireSignedPush != null) {
                    p.setRequireSignedPush(input.requireSignedPush);
                }
            }
            if (input.rejectImplicitMerges != null) {
                p.setRejectImplicitMerges(input.rejectImplicitMerges);
            }
            if (input.maxObjectSizeLimit != null) {
                p.setMaxObjectSizeLimit(input.maxObjectSizeLimit);
            }
            if (input.submitType != null) {
                p.setSubmitType(input.submitType);
            }
            if (input.state != null) {
                p.setState(input.state);
            }
            if (input.pluginConfigValues != null) {
                this.setPluginConfigValues(ctrl.getProjectState(), projectConfig, input.pluginConfigValues);
            }
            md.setMessage("Modified project settings\n");
            try {
                projectConfig.commit(md);
                this.projectCache.evict(projectConfig.getProject());
                md.getRepository().setGitwebDescription(p.getDescription());
            }
            catch (IOException e) {
                if (e.getCause() instanceof ConfigInvalidException) {
                    throw new ResourceConflictException("Cannot update " + projectName + ": " + e.getCause().getMessage());
                }
                log.warn("Failed to update config of project {}.", (Object)projectName, (Object)e);
                throw new ResourceConflictException("Cannot update " + projectName, e);
            }
            ProjectState state = this.projectStateFactory.create(ProjectConfig.read(md));
            ConfigInfoImpl configInfoImpl = new ConfigInfoImpl(this.serverEnableSignedPush, state.controlFor(this.user.get()), this.pluginConfigEntries, this.cfgFactory, this.allProjects, this.views);
            return configInfoImpl;
        }
        catch (RepositoryNotFoundException notFound) {
            throw new ResourceNotFoundException(projectName.get());
        }
        catch (ConfigInvalidException err) {
            throw new ResourceConflictException("Cannot read project " + projectName, err);
        }
        catch (IOException err) {
            throw new ResourceConflictException("Cannot update project " + projectName, err);
        }
    }

    private void setPluginConfigValues(ProjectState projectState, ProjectConfig projectConfig, Map<String, Map<String, ConfigValue>> pluginConfigValues) throws BadRequestException {
        for (Map.Entry<String, Map<String, ConfigValue>> e : pluginConfigValues.entrySet()) {
            String pluginName = e.getKey();
            PluginConfig cfg = projectConfig.getPluginConfig(pluginName);
            for (Map.Entry<String, ConfigValue> v : e.getValue().entrySet()) {
                ProjectConfigEntry projectConfigEntry = this.pluginConfigEntries.get(pluginName, v.getKey());
                if (projectConfigEntry != null) {
                    if (!PutConfig.isValidParameterName(v.getKey())) {
                        log.warn("Parameter name '{}' must match '^[a-zA-Z0-9]+[a-zA-Z0-9-]*$'", (Object)v.getKey());
                        continue;
                    }
                    String oldValue = cfg.getString(v.getKey());
                    String value = v.getValue().value;
                    if (projectConfigEntry.getType() == ProjectConfigEntryType.ARRAY) {
                        List<String> l = Arrays.asList(cfg.getStringList(v.getKey()));
                        oldValue = Joiner.on("\n").join(l);
                        value = Joiner.on("\n").join(v.getValue().values);
                    }
                    if (Strings.emptyToNull(value) != null) {
                        if (value.equals(oldValue)) continue;
                        PutConfig.validateProjectConfigEntryIsEditable(projectConfigEntry, projectState, v.getKey(), pluginName);
                        v.setValue(projectConfigEntry.preUpdate(v.getValue()));
                        value = v.getValue().value;
                        try {
                            switch (projectConfigEntry.getType()) {
                                case BOOLEAN: {
                                    boolean newBooleanValue = Boolean.parseBoolean(value);
                                    cfg.setBoolean(v.getKey(), newBooleanValue);
                                    break;
                                }
                                case INT: {
                                    int newIntValue = Integer.parseInt(value);
                                    cfg.setInt(v.getKey(), newIntValue);
                                    break;
                                }
                                case LONG: {
                                    long newLongValue = Long.parseLong(value);
                                    cfg.setLong(v.getKey(), newLongValue);
                                    break;
                                }
                                case LIST: {
                                    if (!projectConfigEntry.getPermittedValues().contains(value)) {
                                        throw new BadRequestException(String.format("The value '%s' is not permitted for parameter '%s' of plugin '" + pluginName + "'", value, v.getKey()));
                                    }
                                }
                                case STRING: {
                                    cfg.setString(v.getKey(), value);
                                    break;
                                }
                                case ARRAY: {
                                    cfg.setStringList(v.getKey(), v.getValue().values);
                                    break;
                                }
                                default: {
                                    log.warn("The type '{}' of parameter '{}' is not supported.", (Object)projectConfigEntry.getType().name(), (Object)v.getKey());
                                    break;
                                }
                            }
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new BadRequestException(String.format("The value '%s' of config parameter '%s' of plugin '%s' is invalid: %s", v.getValue(), v.getKey(), pluginName, ex.getMessage()));
                        }
                    }
                    if (oldValue == null) continue;
                    PutConfig.validateProjectConfigEntryIsEditable(projectConfigEntry, projectState, v.getKey(), pluginName);
                    cfg.unset(v.getKey());
                    continue;
                }
                throw new BadRequestException(String.format("The config parameter '%s' of plugin '%s' does not exist.", v.getKey(), pluginName));
            }
        }
    }

    private static void validateProjectConfigEntryIsEditable(ProjectConfigEntry projectConfigEntry, ProjectState projectState, String parameterName, String pluginName) throws BadRequestException {
        if (!projectConfigEntry.isEditable(projectState)) {
            throw new BadRequestException(String.format("Not allowed to set parameter '%s' of plugin '%s' on project '%s'.", parameterName, pluginName, projectState.getProject().getName()));
        }
    }

    private static boolean isValidParameterName(String name) {
        return CharMatcher.javaLetterOrDigit().or(CharMatcher.is('-')).matchesAllOf(name) && !name.startsWith("-");
    }
}

