/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.TimestampRangeChangePredicate;
import com.google.gwtorm.server.OrmException;
import java.util.Date;

public class AfterPredicate
extends TimestampRangeChangePredicate {
    private final Date cut;

    AfterPredicate(String value) throws QueryParseException {
        super(ChangeField.UPDATED, "before", value);
        this.cut = AfterPredicate.parse(value);
    }

    @Override
    public Date getMinTimestamp() {
        return this.cut;
    }

    @Override
    public Date getMaxTimestamp() {
        return new Date(Long.MAX_VALUE);
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        return cd.change().getLastUpdatedOn().getTime() >= this.cut.getTime();
    }
}

