/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.group;

import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.query.IsVisibleToPredicate;
import com.google.gwtorm.server.OrmException;

public class GroupIsVisibleToPredicate
extends IsVisibleToPredicate<AccountGroup> {
    private final GroupControl.GenericFactory groupControlFactory;
    private final CurrentUser user;

    GroupIsVisibleToPredicate(GroupControl.GenericFactory groupControlFactory, CurrentUser user) {
        super("visibleto", GroupIsVisibleToPredicate.describe(user));
        this.groupControlFactory = groupControlFactory;
        this.user = user;
    }

    @Override
    public boolean match(AccountGroup group) throws OrmException {
        try {
            return this.groupControlFactory.controlFor(this.user, group.getGroupUUID()).isVisible();
        }
        catch (NoSuchGroupException e) {
            return false;
        }
    }

    @Override
    public int getCost() {
        return 1;
    }
}

