/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_118;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

public class Schema_119
extends SchemaVersion {
    private static final ImmutableMap<String, String> LEGACY_DISPLAYNAME_MAP = ImmutableMap.of("ANON_GIT", "git", "ANON_HTTP", "anonymous http", "HTTP", "http", "SSH", "ssh", "REPO_DOWNLOAD", "repo");
    private final GitRepositoryManager mgr;
    private final AllUsersName allUsersName;
    private final PersonIdent serverUser;

    @Inject
    Schema_119(Provider<Schema_118> prior, GitRepositoryManager mgr, AllUsersName allUsersName, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.mgr = mgr;
        this.allUsersName = allUsersName;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        Throwable throwable;
        JdbcSchema schema = (JdbcSchema)((Object)db);
        Connection connection = schema.getConnection();
        String tableName = "accounts";
        String emailStrategy = "email_strategy";
        Set<String> columns = schema.getDialect().listColumns(connection, tableName);
        HashMap<Account.Id, GeneralPreferencesInfo> imports = new HashMap<Account.Id, GeneralPreferencesInfo>();
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            throwable = null;
            try (ResultSet rs = stmt.executeQuery("select account_id, maximum_page_size, show_site_header, use_flash_clipboard, download_url, download_command, " + (columns.contains(emailStrategy) ? emailStrategy + ", " : "copy_self_on_email, ") + "date_format, time_format, relative_date_in_change_table, diff_view, size_bar_in_change_table, legacycid_in_change_table, review_category_strategy, mute_common_path_prefixes from " + tableName);){
                while (rs.next()) {
                    GeneralPreferencesInfo p = new GeneralPreferencesInfo();
                    Account.Id accountId = new Account.Id(rs.getInt(1));
                    p.changesPerPage = rs.getShort(2);
                    p.showSiteHeader = Schema_119.toBoolean(rs.getString(3));
                    p.useFlashClipboard = Schema_119.toBoolean(rs.getString(4));
                    p.downloadScheme = this.convertToModernNames(rs.getString(5));
                    p.downloadCommand = Schema_119.toDownloadCommand(rs.getString(6));
                    p.emailStrategy = Schema_119.toEmailStrategy(rs.getString(7), columns.contains(emailStrategy));
                    p.dateFormat = Schema_119.toDateFormat(rs.getString(8));
                    p.timeFormat = Schema_119.toTimeFormat(rs.getString(9));
                    p.relativeDateInChangeTable = Schema_119.toBoolean(rs.getString(10));
                    p.diffView = Schema_119.toDiffView(rs.getString(11));
                    p.sizeBarInChangeTable = Schema_119.toBoolean(rs.getString(12));
                    p.legacycidInChangeTable = Schema_119.toBoolean(rs.getString(13));
                    p.reviewCategoryStrategy = Schema_119.toReviewCategoryStrategy(rs.getString(14));
                    p.muteCommonPathPrefixes = Schema_119.toBoolean(rs.getString(15));
                    p.defaultBaseForMerges = GeneralPreferencesInfo.defaults().defaultBaseForMerges;
                    imports.put(accountId, p);
                }
            }
            catch (Throwable p) {
                throwable = p;
                throw p;
            }
        }
        if (imports.isEmpty()) {
            return;
        }
        try {
            var10_11 = null;
            try (Repository git = this.mgr.openRepository(this.allUsersName);){
                throwable = null;
                try (RevWalk rw = new RevWalk(git);){
                    BatchRefUpdate bru = git.getRefDatabase().newBatchUpdate();
                    for (Map.Entry e : imports.entrySet()) {
                        try (MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allUsersName, git, bru);){
                            md.getCommitBuilder().setAuthor(this.serverUser);
                            md.getCommitBuilder().setCommitter(this.serverUser);
                            VersionedAccountPreferences p = VersionedAccountPreferences.forUser((Account.Id)e.getKey());
                            p.load(md);
                            ConfigUtil.storeSection(p.getConfig(), "general", null, (GeneralPreferencesInfo)e.getValue(), GeneralPreferencesInfo.defaults());
                            p.commit(md);
                        }
                    }
                    bru.execute(rw, NullProgressMonitor.INSTANCE);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                var10_11 = throwable3;
                throw throwable3;
            }
        }
        catch (IOException | ConfigInvalidException ex) {
            throw new OrmException(ex);
        }
    }

    private String convertToModernNames(String s) {
        return !Strings.isNullOrEmpty(s) && LEGACY_DISPLAYNAME_MAP.containsKey(s) ? LEGACY_DISPLAYNAME_MAP.get(s) : s;
    }

    private static GeneralPreferencesInfo.DownloadCommand toDownloadCommand(String v) {
        if (v == null) {
            return GeneralPreferencesInfo.DownloadCommand.CHECKOUT;
        }
        return GeneralPreferencesInfo.DownloadCommand.valueOf(v);
    }

    private static GeneralPreferencesInfo.DateFormat toDateFormat(String v) {
        if (v == null) {
            return GeneralPreferencesInfo.DateFormat.STD;
        }
        return GeneralPreferencesInfo.DateFormat.valueOf(v);
    }

    private static GeneralPreferencesInfo.TimeFormat toTimeFormat(String v) {
        if (v == null) {
            return GeneralPreferencesInfo.TimeFormat.HHMM_12;
        }
        return GeneralPreferencesInfo.TimeFormat.valueOf(v);
    }

    private static GeneralPreferencesInfo.DiffView toDiffView(String v) {
        if (v == null) {
            return GeneralPreferencesInfo.DiffView.SIDE_BY_SIDE;
        }
        return GeneralPreferencesInfo.DiffView.valueOf(v);
    }

    private static GeneralPreferencesInfo.EmailStrategy toEmailStrategy(String v, boolean emailStrategyColumnExists) throws OrmException {
        if (v == null) {
            return GeneralPreferencesInfo.EmailStrategy.ENABLED;
        }
        if (emailStrategyColumnExists) {
            return GeneralPreferencesInfo.EmailStrategy.valueOf(v);
        }
        if (v.equals("N")) {
            return GeneralPreferencesInfo.EmailStrategy.ENABLED;
        }
        if (v.equals("Y")) {
            return GeneralPreferencesInfo.EmailStrategy.CC_ON_OWN_COMMENTS;
        }
        throw new OrmException("invalid value in accounts.copy_self_on_email: " + v);
    }

    private static GeneralPreferencesInfo.ReviewCategoryStrategy toReviewCategoryStrategy(String v) {
        if (v == null) {
            return GeneralPreferencesInfo.ReviewCategoryStrategy.NONE;
        }
        return GeneralPreferencesInfo.ReviewCategoryStrategy.valueOf(v);
    }

    private static boolean toBoolean(String v) {
        Preconditions.checkState(!Strings.isNullOrEmpty(v));
        return v.equals("Y");
    }
}

