/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.server.util.AutoValue_LabelVote;

@AutoValue
public abstract class LabelVote {
    public static LabelVote parse(String text) {
        int i;
        Preconditions.checkArgument(!Strings.isNullOrEmpty(text), "Empty label vote");
        if (text.charAt(0) == '-') {
            return LabelVote.create(text.substring(1), (short)0);
        }
        int sign = 0;
        for (i = text.length() - 1; i >= 0; --i) {
            char c = text.charAt(i);
            if (c == '-') {
                sign = -1;
                break;
            }
            if (c == '+') {
                sign = 1;
                break;
            }
            if ('0' > c || c > '9') break;
        }
        if (sign == 0) {
            return LabelVote.create(text, (short)1);
        }
        return LabelVote.create(text.substring(0, i), (short)(sign * Short.parseShort(text.substring(i + 1))));
    }

    public static LabelVote parseWithEquals(String text) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(text), "Empty label vote");
        int e = text.lastIndexOf(61);
        Preconditions.checkArgument(e >= 0, "Label vote missing '=': %s", (Object)text);
        return LabelVote.create(text.substring(0, e), Short.parseShort(text.substring(e + 1), text.length()));
    }

    public static StringBuilder appendTo(StringBuilder sb, String label, short value) {
        if (value == 0) {
            return sb.append('-').append(label);
        }
        if (value < 0) {
            return sb.append(label).append(value);
        }
        return sb.append(label).append('+').append(value);
    }

    public static LabelVote create(String label, short value) {
        return new AutoValue_LabelVote(LabelType.checkNameInternal(label), value);
    }

    public static LabelVote create(PatchSetApproval psa) {
        return LabelVote.create(psa.getLabel(), psa.getValue());
    }

    public abstract String label();

    public abstract short value();

    public String format() {
        return LabelVote.appendTo(new StringBuilder(this.label().length() + 6), this.label(), this.value()).toString();
    }

    public String formatWithEquals() {
        if (this.value() <= 0) {
            return this.label() + '=' + this.value();
        }
        return this.label() + "=+" + this.value();
    }

    public String toString() {
        return this.format();
    }
}

