/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GetGroups;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.ListGroups;
import com.google.gerrit.server.ioutil.ColumnFormatter;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.PrintWriter;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="ls-groups", description="List groups visible to the caller", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
public class ListGroupsCommand
extends SshCommand {
    @Inject
    private MyListGroups impl;

    @Override
    public void run() throws Exception {
        if (this.impl.getUser() != null && !this.impl.getProjects().isEmpty()) {
            throw this.die("--user and --project options are not compatible.");
        }
        this.impl.display(this.stdout);
    }

    @Override
    protected void parseCommandLine() throws BaseCommand.UnloggedFailure {
        this.parseCommandLine(this.impl);
    }

    private static class MyListGroups
    extends ListGroups {
        @Option(name="--verbose", aliases={"-v"}, usage="verbose output format with tab-separated columns for the group name, UUID, description, owner group name, owner group UUID, and whether the group is visible to all")
        private boolean verboseOutput;

        @Inject
        MyListGroups(GroupCache groupCache, GroupControl.Factory groupControlFactory, GroupControl.GenericFactory genericGroupControlFactory, Provider<IdentifiedUser> identifiedUser, IdentifiedUser.GenericFactory userFactory, GetGroups accountGetGroups, GroupJson json, GroupBackend groupBackend) {
            super(groupCache, groupControlFactory, genericGroupControlFactory, identifiedUser, userFactory, accountGetGroups, json, groupBackend);
        }

        void display(PrintWriter out) throws OrmException, BadRequestException {
            ColumnFormatter formatter = new ColumnFormatter(out, '\t');
            for (GroupInfo info : this.get()) {
                formatter.addColumn(MoreObjects.firstNonNull(info.name, "n/a"));
                if (this.verboseOutput) {
                    AccountGroup o = info.ownerId != null ? this.groupCache.get(new AccountGroup.UUID(Url.decode(info.ownerId))) : null;
                    formatter.addColumn(Url.decode(info.id));
                    formatter.addColumn(Strings.nullToEmpty(info.description));
                    formatter.addColumn(o != null ? o.getName() : "n/a");
                    formatter.addColumn(o != null ? o.getGroupUUID().get() : "");
                    formatter.addColumn(Boolean.toString(MoreObjects.firstNonNull(info.options.visibleToAll, Boolean.FALSE)));
                }
                formatter.nextLine();
            }
            formatter.finish();
        }
    }
}

