/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.nosql.heap;

import com.google.gwtorm.nosql.generic.GenericDatabase;
import com.google.gwtorm.nosql.heap.HeapKeyComparator;
import com.google.gwtorm.nosql.heap.TreeMapAccess;
import com.google.gwtorm.nosql.heap.TreeMapSchema;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.Schema;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.UnknownFieldSet;
import java.io.PrintWriter;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class TreeMapDatabase<T extends Schema, S extends TreeMapSchema, A extends TreeMapAccess>
extends GenericDatabase<T, S, A> {
    final Lock lock = new ReentrantLock(true);
    final SortedMap<byte[], byte[]> table = new TreeMap<byte[], byte[]>(HeapKeyComparator.INSTANCE);

    protected TreeMapDatabase(Class<S> schemaBaseType, Class<A> accessBaseType, Class<T> appSchema) throws OrmException {
        super(schemaBaseType, accessBaseType, appSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        this.lock.lock();
        try {
            for (Map.Entry<byte[], byte[]> ent : this.table.entrySet()) {
                String val;
                String key = TreeMapDatabase.format(ent.getKey());
                try {
                    UnknownFieldSet proto = UnknownFieldSet.parseFrom(ent.getValue());
                    val = proto.toString();
                }
                catch (InvalidProtocolBufferException notProto) {
                    val = TreeMapDatabase.format(ent.getValue());
                }
                if (val.contains("\n")) {
                    pw.println(key + ":\n  " + val.replaceAll("\n", "\n  "));
                    continue;
                }
                pw.println(key + ": " + val);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static String format(byte[] bin) {
        StringBuilder s = new StringBuilder(bin.length);
        block6: for (int i = 0; i < bin.length; ++i) {
            byte b = bin[i];
            switch (b) {
                case 0: {
                    s.append("\\0");
                    continue block6;
                }
                case 1: {
                    s.append("\\1");
                    continue block6;
                }
                case -1: {
                    s.append("\\xff");
                    continue block6;
                }
                case 13: {
                    s.append("\\r");
                    continue block6;
                }
                default: {
                    s.append((char)b);
                }
            }
        }
        return s.toString();
    }
}

