/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.sql.SqlBooleanTypeInfo;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.schema.sql.SqlStringTypeInfo;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.StatementExecutor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class DialectHANA
extends SqlDialect {
    public DialectHANA() {
        this.types.put(String.class, new SqlStringTypeInfo(){

            @Override
            public String getSqlType(ColumnModel col, SqlDialect dialect) {
                Column column = col.getColumnAnnotation();
                StringBuilder r = new StringBuilder();
                if (column.length() <= 0) {
                    r.append("NVARCHAR(255)");
                    if (col.isNotNull()) {
                        r.append(" DEFAULT ''");
                    }
                } else if (column.length() <= 5000) {
                    r.append("NVARCHAR(" + column.length() + ")");
                    if (col.isNotNull()) {
                        r.append(" DEFAULT ''");
                    }
                } else {
                    r.append("NCLOB");
                }
                if (col.isNotNull()) {
                    r.append(" NOT NULL");
                }
                return r.toString();
            }
        });
        this.types.put(Boolean.TYPE, new SqlBooleanTypeInfo(){

            @Override
            public String getCheckConstraint(ColumnModel column, SqlDialect dialect) {
                return null;
            }
        });
        this.typeNames.put(4, "INTEGER");
    }

    @Override
    public void addColumn(StatementExecutor e, String tableName, ColumnModel col) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("ALTER TABLE ");
        r.append(tableName);
        r.append(" ADD (");
        r.append(col.getColumnName());
        r.append(" ");
        r.append(this.getSqlTypeInfo(col).getSqlType(col, this));
        r.append(")");
        e.execute(r.toString());
    }

    @Override
    public void dropColumn(StatementExecutor e, String tableName, String column) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("ALTER TABLE ");
        r.append(tableName);
        r.append(" DROP (");
        r.append(column);
        r.append(")");
        e.execute(r.toString());
    }

    @Override
    public boolean handles(String url, Connection c) throws SQLException {
        return url.startsWith("jdbc:sap://");
    }

    @Override
    public Set<String> listSequences(Connection db) throws SQLException {
        return DialectHANA.listNamesFromSystemTable(db, "SEQUENCE_NAME", "SEQUENCES");
    }

    @Override
    public Set<String> listTables(Connection db) throws SQLException {
        return DialectHANA.listNamesFromSystemTable(db, "TABLE_NAME", "TABLES");
    }

    @Override
    public Set<String> listIndexes(Connection db, String tableName) throws SQLException {
        return DialectHANA.listNamesFromSystemTable(db, "INDEX_NAME", "INDEXES");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Set<String> listColumns(Connection db, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isStatementDelimiterSupported() {
        return false;
    }

    private static Set<String> names(ResultSet rs) throws SQLException {
        HashSet<String> names = new HashSet<String>();
        while (rs.next()) {
            names.add(rs.getString(1).toLowerCase(Locale.US));
        }
        return names;
    }

    /*
     * Exception decompiling
     */
    private static Set<String> listNamesFromSystemTable(Connection db, String columnName, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void renameTable(StatementExecutor e, String from, String to) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("RENAME TABLE ");
        r.append(from);
        r.append(" TO ");
        r.append(to);
        r.append(" ");
        e.execute(r.toString());
    }

    @Override
    public String getTableTypeSql() {
        return "COLUMN TABLE";
    }

    @Override
    public OrmException convertError(String op, String entity, SQLException err) {
        int errorCode;
        int sqlstate = DialectHANA.getSQLStateInt(err);
        if (sqlstate == 23000 && ((errorCode = err.getErrorCode()) == 144 || errorCode == 301)) {
            return new OrmDuplicateKeyException(entity, err);
        }
        return super.convertError(op, entity, err);
    }

    @Override
    public void renameColumn(StatementExecutor e, String tableName, String fromColumn, ColumnModel col) throws OrmException {
        StringBuilder s = new StringBuilder();
        s.append("RENAME COLUMN ");
        s.append(tableName).append(".").append(fromColumn);
        s.append(" TO ");
        s.append(col.getColumnName());
        e.execute(s.toString());
    }

    @Override
    protected String getNextSequenceValueSql(String seqname) {
        return "SELECT " + seqname + ".nextval FROM dummy";
    }
}

