/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.template.soy.data.SoyAbstractCachingValueProvider;
import com.google.template.soy.data.SoyCustomValueConverter;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyEasyDict;
import com.google.template.soy.data.SoyEasyList;
import com.google.template.soy.data.SoyFutureValueProvider;
import com.google.template.soy.data.SoyGlobalsValue;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.EasyDictImpl;
import com.google.template.soy.data.internal.EasyListImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SoyValueConverter {
    public static final SoyValueConverter UNCUSTOMIZED_INSTANCE = new SoyValueConverter();
    public static final SoyDict EMPTY_DICT = DictImpl.forProviderMap(ImmutableMap.of());
    public static final SoyList EMPTY_LIST = ListImpl.forProviderList(ImmutableList.of());
    @Inject(optional=true)
    private List<SoyCustomValueConverter> customValueConverters;

    @Inject
    SoyValueConverter() {
    }

    @Deprecated
    public SoyEasyDict newEasyDict() {
        return new EasyDictImpl(this);
    }

    @Deprecated
    public SoyEasyDict newEasyDict(Object ... alternatingKeysAndValues) {
        Preconditions.checkArgument(alternatingKeysAndValues.length % 2 == 0);
        EasyDictImpl result = new EasyDictImpl(this);
        int n = alternatingKeysAndValues.length / 2;
        for (int i = 0; i < n; ++i) {
            result.set((String)alternatingKeysAndValues[2 * i], alternatingKeysAndValues[2 * i + 1]);
        }
        return result;
    }

    @Deprecated
    public SoyEasyDict newEasyDictFromDict(SoyDict dict) {
        Map<String, ? extends SoyValueProvider> map = dict.asJavaStringMap();
        SoyEasyDict result = this.newEasyDict();
        for (Map.Entry<String, ? extends SoyValueProvider> e : map.entrySet()) {
            result.setField(e.getKey(), e.getValue());
        }
        return result;
    }

    @Deprecated
    public SoyEasyDict newEasyDictFromJavaStringMap(Map<String, ?> javaStringMap) {
        EasyDictImpl result = new EasyDictImpl(this);
        result.setFieldsFromJavaStringMap(javaStringMap);
        return result;
    }

    private SoyDict newDictFromJavaStringMap(Map<String, ?> javaStringMap) {
        ImmutableMap.Builder<String, SoyValueProvider> builder = ImmutableMap.builder();
        for (Map.Entry<String, ?> entry : javaStringMap.entrySet()) {
            builder.put(entry.getKey(), this.convertLazy(entry.getValue()));
        }
        return DictImpl.forProviderMap(builder.build());
    }

    @Deprecated
    public SoyEasyList newEasyList(Object ... values) {
        return this.newEasyListFromJavaIterable(Arrays.asList(values));
    }

    @Deprecated
    public SoyEasyList newEasyListFromList(SoyList list) {
        EasyListImpl result = new EasyListImpl();
        for (SoyValueProvider soyValueProvider : list.asJavaList()) {
            result.add(soyValueProvider);
        }
        return result;
    }

    @Deprecated
    public SoyEasyList newEasyListFromJavaIterable(Iterable<?> javaIterable) {
        EasyListImpl result = new EasyListImpl();
        for (Object o : javaIterable) {
            result.add(this.convert(o));
        }
        return result;
    }

    private SoyList newListFromIterable(Iterable<?> items) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object item : items) {
            builder.add(this.convertLazy(item));
        }
        return ListImpl.forProviderList((List<? extends SoyValueProvider>)((Object)builder.build()));
    }

    @Nonnull
    public SoyValueProvider convert(@Nullable Object obj) {
        SoyValueProvider convertedPrimitive = this.convertPrimitive(obj);
        if (convertedPrimitive != null) {
            return convertedPrimitive;
        }
        if (obj instanceof Map) {
            Map objCast = (Map)obj;
            return this.newDictFromJavaStringMap(objCast);
        }
        if (obj instanceof Collection) {
            return this.newListFromIterable((Collection)obj);
        }
        if (obj instanceof FluentIterable) {
            return this.newListFromIterable((FluentIterable)obj);
        }
        if (obj instanceof SoyGlobalsValue) {
            return this.convert(((SoyGlobalsValue)obj).getSoyGlobalValue());
        }
        if (this.customValueConverters != null) {
            for (SoyCustomValueConverter customConverter : this.customValueConverters) {
                SoyValueProvider result = customConverter.convert(this, obj);
                if (result == null) continue;
                return result;
            }
        }
        throw new SoyDataException("Attempting to convert unrecognized object to Soy value (object type " + obj.getClass().getName() + ").");
    }

    private SoyValueProvider convertLazy(final @Nullable Object obj) {
        SoyValueProvider convertedPrimitive = this.convertPrimitive(obj);
        if (convertedPrimitive != null) {
            return convertedPrimitive;
        }
        return new SoyAbstractCachingValueProvider(){

            @Override
            protected SoyValue compute() {
                return SoyValueConverter.this.convert(obj).resolve();
            }

            @Override
            public RenderResult status() {
                return RenderResult.done();
            }
        };
    }

    @Nullable
    private SoyValueProvider convertPrimitive(@Nullable Object obj) {
        if (obj == null) {
            return NullData.INSTANCE;
        }
        if (obj instanceof SoyValueProvider) {
            return (SoyValueProvider)obj;
        }
        if (obj instanceof String) {
            return StringData.forValue((String)obj);
        }
        if (obj instanceof Boolean) {
            return BooleanData.forValue((Boolean)obj);
        }
        if (obj instanceof Number) {
            if (obj instanceof Integer) {
                return IntegerData.forValue(((Integer)obj).intValue());
            }
            if (obj instanceof Long) {
                return IntegerData.forValue((Long)obj);
            }
            if (obj instanceof Double) {
                return FloatData.forValue((Double)obj);
            }
            if (obj instanceof Float) {
                return FloatData.forValue(((Float)obj).floatValue());
            }
        } else if (obj instanceof Future) {
            return new SoyFutureValueProvider(this, (Future)obj);
        }
        return null;
    }
}

