/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.ordainers;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import java.lang.reflect.Type;

public final class GsonOrdainer {
    private GsonOrdainer() {
    }

    public static SanitizedContent serializeObject(Object obj) {
        return GsonOrdainer.serializeObject(new Gson(), obj);
    }

    public static SanitizedContent serializeObject(Gson gson, Object obj) {
        return GsonOrdainer.ordainJson(gson.toJson(obj));
    }

    public static SanitizedContent serializeObject(Gson gson, Object obj, Type type) {
        return GsonOrdainer.ordainJson(gson.toJson(obj, type));
    }

    public static SanitizedContent serializeElement(JsonElement element) {
        Preconditions.checkArgument(element instanceof JsonArray || element instanceof JsonObject || element instanceof JsonNull || element instanceof JsonPrimitive);
        return GsonOrdainer.ordainJson(new Gson().toJson(element));
    }

    private static SanitizedContent ordainJson(String knownSafeJson) {
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(knownSafeJson, SanitizedContent.ContentKind.JS);
    }
}

