/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_Ternary;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.OutputContext;

abstract class Ternary
extends Operation {
    Ternary() {
    }

    abstract CodeChunk.WithValue predicate();

    abstract CodeChunk.WithValue consequent();

    abstract CodeChunk.WithValue alternate();

    static Ternary create(CodeChunk.WithValue predicate, CodeChunk.WithValue consequent, CodeChunk.WithValue alternate) {
        Preconditions.checkState(predicate.isRepresentableAsSingleExpression());
        Preconditions.checkState(consequent.isRepresentableAsSingleExpression());
        Preconditions.checkState(alternate.isRepresentableAsSingleExpression());
        return new AutoValue_Ternary(predicate, consequent, alternate);
    }

    @Override
    int precedence() {
        return Operator.CONDITIONAL.getPrecedence();
    }

    @Override
    Operator.Associativity associativity() {
        return Operator.CONDITIONAL.getAssociativity();
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx, boolean moreToCome) {
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx, OutputContext outputContext) {
        this.formatOperand(this.predicate(), OperandPosition.LEFT, ctx);
        ctx.append(" ? ");
        this.formatOperand(this.consequent(), OperandPosition.LEFT, ctx);
        ctx.append(" : ");
        this.formatOperand(this.alternate(), OperandPosition.RIGHT, ctx);
    }

    @Override
    public boolean isRepresentableAsSingleExpression() {
        return true;
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        this.predicate().collectRequires(collector);
        this.consequent().collectRequires(collector);
        this.alternate().collectRequires(collector);
    }
}

