/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.internal.V1JsExprTranslator;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.ExprUnion;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class JsExprTranslator {
    private final TranslateExprNodeVisitor.TranslateExprNodeVisitorFactory translateExprNodeVisitorFactory;

    @Inject
    JsExprTranslator(TranslateExprNodeVisitor.TranslateExprNodeVisitorFactory translateExprNodeVisitorFactory) {
        this.translateExprNodeVisitorFactory = translateExprNodeVisitorFactory;
    }

    CodeChunk.WithValue translateToCodeChunk(@Nullable ExprNode expr, @Nullable String exprText, TranslationContext translationContext, ErrorReporter errorReporter) {
        if (expr != null && (exprText == null || new CheckAllFunctionsSupportedVisitor().exec(expr).booleanValue())) {
            return (CodeChunk.WithValue)this.translateExprNodeVisitorFactory.create(translationContext, errorReporter).exec(expr);
        }
        SourceLocation sourceLocation = expr != null ? expr.getSourceLocation() : SourceLocation.UNKNOWN;
        Preconditions.checkNotNull(exprText);
        return CodeChunk.fromExpr(V1JsExprTranslator.translateToJsExpr(exprText, sourceLocation, translationContext.soyToJsVariableMappings(), errorReporter));
    }

    CodeChunk.WithValue translateToCodeChunk(ExprNode expr, TranslationContext translationContext, ErrorReporter errorReporter) {
        Preconditions.checkNotNull(expr);
        return this.translateToCodeChunk(expr, null, translationContext, errorReporter);
    }

    CodeChunk.WithValue translateToCodeChunk(ExprUnion union, TranslationContext translationContext, ErrorReporter errorReporter) {
        return this.translateToCodeChunk(union.getExpr(), union.getExprText(), translationContext, errorReporter);
    }

    private static final class CheckAllFunctionsSupportedVisitor
    extends AbstractExprNodeVisitor<Boolean> {
        private boolean areAllFunctionsSupported;

        private CheckAllFunctionsSupportedVisitor() {
        }

        @Override
        public Boolean exec(ExprNode node) {
            this.areAllFunctionsSupported = true;
            this.visit(node);
            return this.areAllFunctionsSupported;
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            SoyFunction function = node.getSoyFunction();
            if (!(function instanceof SoyJsSrcFunction) && !(function instanceof BuiltinFunction)) {
                this.areAllFunctionsSupported = false;
                return;
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                if (!this.areAllFunctionsSupported) {
                    return;
                }
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }
    }
}

