/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.scp;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.file.util.MockPath;
import org.apache.sshd.common.scp.ScpException;
import org.apache.sshd.common.scp.ScpFileOpener;
import org.apache.sshd.common.scp.ScpReceiveLineHandler;
import org.apache.sshd.common.scp.ScpSourceStreamResolver;
import org.apache.sshd.common.scp.ScpTargetStreamResolver;
import org.apache.sshd.common.scp.ScpTimestamp;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.scp.helpers.DefaultScpFileOpener;
import org.apache.sshd.common.scp.helpers.LocalFileScpSourceStreamResolver;
import org.apache.sshd.common.scp.helpers.LocalFileScpTargetStreamResolver;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.common.util.io.DirectoryScanner;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.LimitInputStream;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ScpHelper
extends AbstractLoggingBean
implements SessionHolder<Session> {
    public static final String SCP_COMMAND_PREFIX = "scp";
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int DEFAULT_COPY_BUFFER_SIZE = 8192;
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE = 8192;
    public static final int DEFAULT_SEND_BUFFER_SIZE = 8192;
    public static final int MIN_COPY_BUFFER_SIZE = 127;
    public static final int MIN_RECEIVE_BUFFER_SIZE = 127;
    public static final int MIN_SEND_BUFFER_SIZE = 127;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    protected final InputStream in;
    protected final OutputStream out;
    protected final FileSystem fileSystem;
    protected final ScpFileOpener opener;
    protected final ScpTransferEventListener listener;
    private final Session sessionInstance;

    public ScpHelper(Session session, InputStream in, OutputStream out, FileSystem fileSystem, ScpFileOpener opener, ScpTransferEventListener eventListener) {
        this.sessionInstance = Objects.requireNonNull(session, "No session");
        this.in = Objects.requireNonNull(in, "No input stream");
        this.out = Objects.requireNonNull(out, "No output stream");
        this.fileSystem = fileSystem;
        this.opener = opener == null ? DefaultScpFileOpener.INSTANCE : opener;
        this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
    }

    @Override
    public Session getSession() {
        return this.sessionInstance;
    }

    public void receiveFileStream(final OutputStream local, int bufferSize) throws IOException {
        this.receive((line, isDir, timestamp) -> {
            if (isDir) {
                throw new StreamCorruptedException("Cannot download a directory into a file stream: " + line);
            }
            final MockPath path = new MockPath(line);
            this.receiveStream(line, new ScpTargetStreamResolver(){

                @Override
                public OutputStream resolveTargetStream(Session session, String name, long length, Set<PosixFilePermission> perms, OpenOption ... options) throws IOException {
                    if (ScpHelper.this.log.isDebugEnabled()) {
                        ScpHelper.this.log.debug("resolveTargetStream({}) name={}, perms={}, len={} - started local stream download", ScpHelper.this, name, perms, length);
                    }
                    return local;
                }

                @Override
                public Path getEventListenerFilePath() {
                    return path;
                }

                @Override
                public void postProcessReceivedData(String name, boolean preserve, Set<PosixFilePermission> perms, ScpTimestamp time) throws IOException {
                    if (ScpHelper.this.log.isDebugEnabled()) {
                        ScpHelper.this.log.debug("postProcessReceivedData({}) name={}, perms={}, preserve={} time={}", ScpHelper.this, name, perms, preserve, time);
                    }
                }

                public String toString() {
                    return line;
                }
            }, timestamp, false, bufferSize);
        });
    }

    public void receive(Path local, boolean recursive, boolean shouldBeDir, boolean preserve, int bufferSize) throws IOException {
        Path path = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        if (shouldBeDir) {
            LinkOption[] options = IoUtils.getLinkOptions(false);
            Boolean status = IoUtils.checkFileExists(path, options);
            if (status == null) {
                throw new SshException("Target directory " + path + " is most like inaccessible");
            }
            if (!status.booleanValue()) {
                throw new SshException("Target directory " + path + " does not exist");
            }
            if (!Files.isDirectory(path, options)) {
                throw new SshException("Target directory " + path + " is not a directory");
            }
        }
        this.receive((line, isDir, time) -> {
            if (recursive && isDir) {
                this.receiveDir(line, path, time, preserve, bufferSize);
            } else {
                this.receiveFile(line, path, time, preserve, bufferSize);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive(ScpReceiveLineHandler handler) throws IOException {
        this.ack();
        ScpTimestamp time = null;
        block10: while (true) {
            String line;
            boolean isDir = false;
            int c = this.readAck(true);
            switch (c) {
                case -1: {
                    return;
                }
                case 68: {
                    isDir = true;
                    line = String.valueOf((char)c) + this.readLine();
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("receive({}) - Received 'D' header: {}", (Object)this, (Object)line);
                    break;
                }
                case 67: {
                    line = String.valueOf((char)c) + this.readLine();
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("receive({}) - Received 'C' header: {}", (Object)this, (Object)line);
                    break;
                }
                case 84: {
                    line = String.valueOf((char)c) + this.readLine();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("receive({}) - Received 'T' header: {}", (Object)this, (Object)line);
                    }
                    time = ScpTimestamp.parseTime(line);
                    this.ack();
                    continue block10;
                }
                case 69: {
                    line = String.valueOf((char)c) + this.readLine();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("receive({}) - Received 'E' header: {}", (Object)this, (Object)line);
                    }
                    this.ack();
                    return;
                }
                default: {
                    continue block10;
                }
            }
            try {
                handler.process(line, isDir, time);
                continue;
            }
            finally {
                time = null;
                continue;
            }
            break;
        }
    }

    public void receiveDir(String header, Path local, ScpTimestamp time, boolean preserve, int bufferSize) throws IOException {
        Path path = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        if (this.log.isDebugEnabled()) {
            this.log.debug("receiveDir({})[{}] Receiving directory {} - preserve={}, time={}, buffer-size={}", this, header, path, preserve, time, bufferSize);
        }
        if (!header.startsWith("D")) {
            throw new IOException("Expected a 'D; message but got '" + header + "'");
        }
        Set<PosixFilePermission> perms = ScpHelper.parseOctalPermissions(header.substring(1, 5));
        int length = Integer.parseInt(header.substring(6, header.indexOf(32, 6)));
        String name = header.substring(header.indexOf(32, 6) + 1);
        if (length != 0) {
            throw new IOException("Expected 0 length for directory but got " + length);
        }
        LinkOption[] options = IoUtils.getLinkOptions(false);
        Boolean status = IoUtils.checkFileExists(path, options);
        if (status == null) {
            throw new AccessDeniedException("Receive directory existence status cannot be determined: " + path);
        }
        Path file = null;
        if (status.booleanValue() && Files.isDirectory(path, options)) {
            String localName = name.replace('/', File.separatorChar);
            file = path.resolve(localName);
        } else if (!status.booleanValue()) {
            Path parent = path.getParent();
            status = IoUtils.checkFileExists(parent, options);
            if (status == null) {
                throw new AccessDeniedException("Receive directory parent (" + parent + ") existence status cannot be determined for " + path);
            }
            if (status.booleanValue() && Files.isDirectory(parent, options)) {
                file = path;
            }
        }
        if (file == null) {
            throw new IOException("Cannot write to " + path);
        }
        status = IoUtils.checkFileExists(file, options);
        if (status == null) {
            throw new AccessDeniedException("Receive directory file existence status cannot be determined: " + file);
        }
        if (!status.booleanValue() || !Files.isDirectory(file, options)) {
            Files.createDirectory(file, new FileAttribute[0]);
        }
        if (preserve) {
            this.updateFileProperties(file, perms, time);
        }
        this.ack();
        time = null;
        this.listener.startFolderEvent(ScpTransferEventListener.FileOperation.RECEIVE, path, perms);
        try {
            block19: {
                while (true) {
                    header = this.readLine();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("receiveDir({})[{}] Received header: {}", this, file, header);
                    }
                    if (header.startsWith("C")) {
                        this.receiveFile(header, file, time, preserve, bufferSize);
                        time = null;
                        continue;
                    }
                    if (header.startsWith("D")) {
                        this.receiveDir(header, file, time, preserve, bufferSize);
                        time = null;
                        continue;
                    }
                    if (header.equals("E")) break block19;
                    if (!header.startsWith("T")) break;
                    time = ScpTimestamp.parseTime(header);
                    this.ack();
                }
                throw new IOException("Unexpected message: '" + header + "'");
            }
            this.ack();
        }
        catch (IOException | RuntimeException e) {
            this.listener.endFolderEvent(ScpTransferEventListener.FileOperation.RECEIVE, path, perms, e);
            throw e;
        }
        this.listener.endFolderEvent(ScpTransferEventListener.FileOperation.RECEIVE, path, perms, null);
    }

    public void receiveFile(String header, Path local, ScpTimestamp time, boolean preserve, int bufferSize) throws IOException {
        Path path = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        if (this.log.isDebugEnabled()) {
            this.log.debug("receiveFile({})[{}] Receiving file {} - preserve={}, time={}, buffer-size={}", this, header, path, preserve, time, bufferSize);
        }
        this.receiveStream(header, new LocalFileScpTargetStreamResolver(path, this.opener), time, preserve, bufferSize);
    }

    public void receiveStream(String header, ScpTargetStreamResolver resolver, ScpTimestamp time, boolean preserve, int bufferSize) throws IOException {
        int bufSize;
        if (!header.startsWith("C")) {
            throw new IOException("receiveStream(" + resolver + ") Expected a C message but got '" + header + "'");
        }
        if (bufferSize < 127) {
            throw new IOException("receiveStream(" + resolver + ") buffer size (" + bufferSize + ") below minimum (" + 127 + ")");
        }
        Set<PosixFilePermission> perms = ScpHelper.parseOctalPermissions(header.substring(1, 5));
        long length = Long.parseLong(header.substring(6, header.indexOf(32, 6)));
        String name = header.substring(header.indexOf(32, 6) + 1);
        if (length < 0L) {
            this.log.warn("receiveStream({})[{}] bad length in header: {}", this, resolver, header);
        }
        if (length == 0L) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("receiveStream({})[{}] zero file size (perhaps special file) using copy buffer size={}", this, resolver, 127);
            }
            bufSize = 127;
        } else {
            bufSize = (int)Math.min(length, (long)bufferSize);
        }
        if (bufSize < 0) {
            this.log.warn("receiveStream({})[{}] bad buffer size ({}) using default ({})", this, resolver, bufSize, 127);
            bufSize = 127;
        }
        try (LimitInputStream is = new LimitInputStream(this.in, length);
             OutputStream os = resolver.resolveTargetStream(this.getSession(), name, length, perms, new OpenOption[0]);){
            this.ack();
            Path file = resolver.getEventListenerFilePath();
            this.listener.startFileEvent(ScpTransferEventListener.FileOperation.RECEIVE, file, length, perms);
            try {
                IoUtils.copy(is, os, bufSize);
            }
            catch (IOException | RuntimeException e) {
                this.listener.endFileEvent(ScpTransferEventListener.FileOperation.RECEIVE, file, length, perms, e);
                throw e;
            }
            this.listener.endFileEvent(ScpTransferEventListener.FileOperation.RECEIVE, file, length, perms, null);
        }
        resolver.postProcessReceivedData(name, preserve, perms, time);
        this.ack();
        int replyCode = this.readAck(false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("receiveStream({})[{}] ack reply code={}", this, resolver, replyCode);
        }
        this.validateAckReplyCode("receiveStream", resolver, replyCode, false);
    }

    protected void updateFileProperties(Path file, Set<PosixFilePermission> perms, ScpTimestamp time) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("updateFileProperties({}) {} permissions={}, time={}", this, file, perms, time);
        }
        IoUtils.setPermissions(file, perms);
        if (time != null) {
            BasicFileAttributeView view = Files.getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]);
            FileTime lastModified = FileTime.from(time.getLastModifiedTime(), TimeUnit.MILLISECONDS);
            FileTime lastAccess = FileTime.from(time.getLastAccessTime(), TimeUnit.MILLISECONDS);
            if (this.log.isTraceEnabled()) {
                this.log.trace("updateFileProperties({}) {} last-modified={}, last-access={}", this, file, lastModified, lastAccess);
            }
            view.setTimes(lastModified, lastAccess, null);
        }
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLine(boolean canEof) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(127);){
            while (true) {
                int c;
                if ((c = this.in.read()) == 10) {
                    String string = baos.toString(StandardCharsets.UTF_8.name());
                    return string;
                }
                if (c == -1) {
                    if (!canEof) {
                        throw new EOFException("EOF while await end of line");
                    }
                    String string = null;
                    return string;
                }
                baos.write(c);
                continue;
                break;
            }
        }
    }

    public void send(Collection<String> paths, boolean recursive, boolean preserve, int bufferSize) throws IOException {
        int readyCode = this.readAck(false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("send({}) ready code={}", (Object)paths, (Object)readyCode);
        }
        this.validateOperationReadyCode("send", "Paths", readyCode, false);
        LinkOption[] options = IoUtils.getLinkOptions(false);
        for (String pattern : paths) {
            int idx = (pattern = pattern.replace('/', File.separatorChar)).indexOf(42);
            if (idx >= 0) {
                String[] included;
                String basedir = "";
                String fixedPart = pattern.substring(0, idx);
                int lastSep = fixedPart.lastIndexOf(File.separatorChar);
                if (lastSep >= 0) {
                    basedir = pattern.substring(0, lastSep);
                    pattern = pattern.substring(lastSep + 1);
                }
                for (String path : included = new DirectoryScanner(basedir, pattern).scan()) {
                    Path file = this.resolveLocalPath(basedir, path);
                    if (Files.isRegularFile(file, options)) {
                        this.sendFile(file, preserve, bufferSize);
                        continue;
                    }
                    if (Files.isDirectory(file, options)) {
                        if (!recursive) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("send({}) {}: not a regular file", (Object)this, (Object)path);
                            }
                            this.sendWarning(path.replace(File.separatorChar, '/') + " not a regular file");
                            continue;
                        }
                        this.sendDir(file, preserve, bufferSize);
                        continue;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("send({}) {}: unknown file type", (Object)this, (Object)path);
                    }
                    this.sendWarning(path.replace(File.separatorChar, '/') + " unknown file type");
                }
                continue;
            }
            this.send(this.resolveLocalPath(pattern), recursive, preserve, bufferSize, options);
        }
    }

    public void sendPaths(Collection<? extends Path> paths, boolean recursive, boolean preserve, int bufferSize) throws IOException {
        int readyCode = this.readAck(false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendPaths({}) ready code={}", (Object)paths, (Object)readyCode);
        }
        this.validateOperationReadyCode("sendPaths", "Paths", readyCode, false);
        LinkOption[] options = IoUtils.getLinkOptions(false);
        for (Path path : paths) {
            this.send(path, recursive, preserve, bufferSize, options);
        }
    }

    protected void send(Path local, boolean recursive, boolean preserve, int bufferSize, LinkOption ... options) throws IOException {
        Path file = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        Boolean status = IoUtils.checkFileExists(file, options);
        if (status == null) {
            throw new AccessDeniedException("Send file existence status cannot be determined: " + file);
        }
        if (!status.booleanValue()) {
            throw new IOException(file + ": no such file or directory");
        }
        if (Files.isRegularFile(file, options)) {
            this.sendFile(file, preserve, bufferSize);
        } else if (Files.isDirectory(file, options)) {
            if (!recursive) {
                throw new IOException(file + " not a regular file");
            }
            this.sendDir(file, preserve, bufferSize);
        } else {
            throw new IOException(file + ": unknown file type");
        }
    }

    public Path resolveLocalPath(String basedir, String subpath) throws IOException {
        if (GenericUtils.isEmpty(basedir)) {
            return this.resolveLocalPath(subpath);
        }
        return this.resolveLocalPath(basedir + File.separator + subpath);
    }

    public Path resolveLocalPath(String commandPath) throws IOException, InvalidPathException {
        String path = SelectorUtils.translateToLocalFileSystemPath(commandPath, File.separatorChar, this.fileSystem);
        Path lcl = this.fileSystem.getPath(path, new String[0]);
        Path abs = lcl.isAbsolute() ? lcl : lcl.toAbsolutePath();
        Path p = abs.normalize();
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolveLocalPath({}) {}: {}", this, commandPath, p);
        }
        return p;
    }

    public void sendFile(Path local, boolean preserve, int bufferSize) throws IOException {
        Path path = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendFile({})[preserve={},buffer-size={}] Sending file {}", this, preserve, bufferSize, path);
        }
        this.sendStream(new LocalFileScpSourceStreamResolver(path, this.opener), preserve, bufferSize);
    }

    public void sendStream(ScpSourceStreamResolver resolver, boolean preserve, int bufferSize) throws IOException {
        int bufSize;
        if (bufferSize < 127) {
            throw new IOException("sendStream(" + resolver + ") buffer size (" + bufferSize + ") below minimum (" + 127 + ")");
        }
        long fileSize = resolver.getSize();
        if (fileSize <= 0L) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendStream({})[{}] unknown file size ({}) perhaps special file - using copy buffer size={}", this, resolver, fileSize, 127);
            }
            bufSize = 127;
        } else {
            bufSize = (int)Math.min(fileSize, (long)bufferSize);
        }
        if (bufSize < 0) {
            this.log.warn("sendStream({})[{}] bad buffer size ({}) using default ({})", this, resolver, bufSize, 127);
            bufSize = 127;
        }
        ScpTimestamp time = resolver.getTimestamp();
        if (preserve && time != null) {
            String cmd = "T" + TimeUnit.MILLISECONDS.toSeconds(time.getLastModifiedTime()) + " " + "0" + " " + TimeUnit.MILLISECONDS.toSeconds(time.getLastAccessTime()) + " " + "0";
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendStream({})[{}] send timestamp={} command: {}", this, resolver, time, cmd);
            }
            this.out.write(cmd.getBytes(StandardCharsets.UTF_8));
            this.out.write(10);
            this.out.flush();
            int readyCode = this.readAck(false);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendStream({})[{}] command='{}' ready code={}", this, resolver, cmd, readyCode);
            }
            this.validateAckReplyCode(cmd, resolver, readyCode, false);
        }
        EnumSet<PosixFilePermission> perms = EnumSet.copyOf(resolver.getPermissions());
        String octalPerms = preserve ? ScpHelper.getOctalPermissions(perms) : "0644";
        String fileName = resolver.getFileName();
        String cmd = "C" + octalPerms + " " + fileSize + " " + fileName;
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendStream({})[{}] send 'C' command: {}", this, resolver, cmd);
        }
        this.out.write(cmd.getBytes(StandardCharsets.UTF_8));
        this.out.write(10);
        this.out.flush();
        int readyCode = this.readAck(false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendStream({})[{}] command='{}' ready code={}", this, resolver, cmd.substring(0, cmd.length() - 1), readyCode);
        }
        this.validateAckReplyCode(cmd, resolver, readyCode, false);
        try (InputStream in = resolver.resolveSourceStream(this.getSession(), new OpenOption[0]);){
            Path path = resolver.getEventListenerFilePath();
            this.listener.startFileEvent(ScpTransferEventListener.FileOperation.SEND, path, fileSize, perms);
            try {
                IoUtils.copy(in, this.out, bufSize);
            }
            catch (IOException | RuntimeException e) {
                this.listener.endFileEvent(ScpTransferEventListener.FileOperation.SEND, path, fileSize, perms, e);
                throw e;
            }
            this.listener.endFileEvent(ScpTransferEventListener.FileOperation.SEND, path, fileSize, perms, null);
        }
        this.ack();
        readyCode = this.readAck(false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendStream({})[{}] command='{}' reply code={}", this, resolver, cmd, readyCode);
        }
        this.validateAckReplyCode("sendStream", resolver, readyCode, false);
    }

    protected void validateOperationReadyCode(String command, Object location, int readyCode, boolean eofAllowed) throws IOException {
        this.validateCommandStatusCode(command, location, readyCode, eofAllowed);
    }

    protected void validateAckReplyCode(String command, Object location, int replyCode, boolean eofAllowed) throws IOException {
        this.validateCommandStatusCode(command, location, replyCode, eofAllowed);
    }

    protected void validateCommandStatusCode(String command, Object location, int statusCode, boolean eofAllowed) throws IOException {
        switch (statusCode) {
            case -1: {
                if (eofAllowed) break;
                throw new EOFException("Unexpected EOF for command='" + command + "' on " + location);
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new ScpException("Bad reply code (" + statusCode + ") for command='" + command + "' on " + location, (Integer)statusCode);
            }
        }
    }

    public void sendDir(Path local, boolean preserve, int bufferSize) throws IOException {
        int readyCode;
        String cmd;
        Path path = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendDir({}) Sending directory {} - preserve={}, buffer-size={}", this, path, preserve, bufferSize);
        }
        BasicFileAttributes basic = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        if (preserve) {
            FileTime lastModified = basic.lastModifiedTime();
            FileTime lastAccess = basic.lastAccessTime();
            cmd = "T" + lastModified.to(TimeUnit.SECONDS) + " " + "0" + " " + lastAccess.to(TimeUnit.SECONDS) + " " + "0";
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendDir({})[{}] send last-modified={}, last-access={} command: {}", this, path, lastModified, lastAccess, cmd);
            }
            this.out.write(cmd.getBytes(StandardCharsets.UTF_8));
            this.out.write(10);
            this.out.flush();
            readyCode = this.readAck(false);
            if (this.log.isDebugEnabled() && this.log.isDebugEnabled()) {
                this.log.debug("sendDir({})[{}] command='{}' ready code={}", this, path, cmd, readyCode);
            }
            this.validateAckReplyCode(cmd, path, readyCode, false);
        }
        LinkOption[] options = IoUtils.getLinkOptions(false);
        Set<PosixFilePermission> perms = IoUtils.getPermissions(path, options);
        cmd = "D" + (preserve ? ScpHelper.getOctalPermissions(perms) : "0755") + " " + "0" + " " + path.getFileName().toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendDir({})[{}] send 'D' command: {}", this, path, cmd);
        }
        this.out.write(cmd.getBytes(StandardCharsets.UTF_8));
        this.out.write(10);
        this.out.flush();
        readyCode = this.readAck(false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendDir({})[{}] command='{}' ready code={}", this, path, cmd.substring(0, cmd.length() - 1), readyCode);
        }
        this.validateAckReplyCode(cmd, path, readyCode, false);
        try (DirectoryStream<Path> children = Files.newDirectoryStream(path);){
            this.listener.startFolderEvent(ScpTransferEventListener.FileOperation.SEND, path, perms);
            try {
                for (Path child : children) {
                    if (Files.isRegularFile(child, options)) {
                        this.sendFile(child, preserve, bufferSize);
                        continue;
                    }
                    if (!Files.isDirectory(child, options)) continue;
                    this.sendDir(child, preserve, bufferSize);
                }
            }
            catch (IOException | RuntimeException e) {
                this.listener.endFolderEvent(ScpTransferEventListener.FileOperation.SEND, path, perms, e);
                throw e;
            }
            this.listener.endFolderEvent(ScpTransferEventListener.FileOperation.SEND, path, perms, null);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendDir({})[{}] send 'E' command", (Object)this, (Object)path);
        }
        this.out.write("E\n".getBytes(StandardCharsets.UTF_8));
        this.out.flush();
        readyCode = this.readAck(false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendDir({})[{}] 'E' command reply code=", this, path, readyCode);
        }
        this.validateAckReplyCode("E", path, readyCode, false);
    }

    public static String getOctalPermissions(Path path, LinkOption ... options) throws IOException {
        return ScpHelper.getOctalPermissions(IoUtils.getPermissions(path, options));
    }

    public static String getOctalPermissions(Collection<PosixFilePermission> perms) {
        int pf = 0;
        for (PosixFilePermission p : perms) {
            switch (p) {
                case OWNER_READ: {
                    pf |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    pf |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    pf |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    pf |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    pf |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    pf |= 8;
                    break;
                }
                case OTHERS_READ: {
                    pf |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    pf |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    pf |= 1;
                    break;
                }
            }
        }
        return String.format("%04o", pf);
    }

    public static Set<PosixFilePermission> setOctalPermissions(Path path, String str) throws IOException {
        Set<PosixFilePermission> perms = ScpHelper.parseOctalPermissions(str);
        IoUtils.setPermissions(path, perms);
        return perms;
    }

    public static Set<PosixFilePermission> parseOctalPermissions(String str) {
        int perms = Integer.parseInt(str, 8);
        EnumSet<PosixFilePermission> p = EnumSet.noneOf(PosixFilePermission.class);
        if ((perms & 0x100) != 0) {
            p.add(PosixFilePermission.OWNER_READ);
        }
        if ((perms & 0x80) != 0) {
            p.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((perms & 0x40) != 0) {
            p.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((perms & 0x20) != 0) {
            p.add(PosixFilePermission.GROUP_READ);
        }
        if ((perms & 0x10) != 0) {
            p.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((perms & 8) != 0) {
            p.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((perms & 4) != 0) {
            p.add(PosixFilePermission.OTHERS_READ);
        }
        if ((perms & 2) != 0) {
            p.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((perms & 1) != 0) {
            p.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return p;
    }

    protected void sendWarning(String message) throws IOException {
        this.sendResponseMessage(1, message);
    }

    protected void sendError(String message) throws IOException {
        this.sendResponseMessage(2, message);
    }

    protected void sendResponseMessage(int level, String message) throws IOException {
        ScpHelper.sendResponseMessage(this.out, level, message);
    }

    public static <O extends OutputStream> O sendWarning(O out, String message) throws IOException {
        return ScpHelper.sendResponseMessage(out, 1, message);
    }

    public static <O extends OutputStream> O sendError(O out, String message) throws IOException {
        return ScpHelper.sendResponseMessage(out, 2, message);
    }

    public static <O extends OutputStream> O sendResponseMessage(O out, int level, String message) throws IOException {
        out.write(level);
        out.write(message.getBytes(StandardCharsets.UTF_8));
        out.write(10);
        out.flush();
        return out;
    }

    public static String getExitStatusName(Integer exitStatus) {
        if (exitStatus == null) {
            return "null";
        }
        switch (exitStatus) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "WARNING";
            }
            case 2: {
                return "ERROR";
            }
        }
        return exitStatus.toString();
    }

    public void ack() throws IOException {
        this.out.write(0);
        this.out.flush();
    }

    public int readAck(boolean canEof) throws IOException {
        int c = this.in.read();
        switch (c) {
            case -1: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("readAck({})[EOF={}] received EOF", (Object)this, (Object)canEof);
                }
                if (canEof) break;
                throw new EOFException("readAck - EOF before ACK");
            }
            case 0: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("readAck({})[EOF={}] read OK", (Object)this, (Object)canEof);
                break;
            }
            case 1: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("readAck({})[EOF={}] read warning message", (Object)this, (Object)canEof);
                }
                String line = this.readLine();
                this.log.warn("readAck({})[EOF={}] - Received warning: {}", this, canEof, line);
                break;
            }
            case 2: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("readAck({})[EOF={}] read error message", (Object)this, (Object)canEof);
                }
                String line = this.readLine();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("readAck({})[EOF={}] received error: {}", this, canEof, line);
                }
                throw new ScpException("Received nack: " + line, (Integer)c);
            }
        }
        return c;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSession() + "]";
    }
}

