/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.parboiled.support.Checks;
import org.parboiled.support.ValueStack;

@Deprecated
public class DefaultValueStack<V>
implements ValueStack<V> {
    protected Element head;
    protected V tempValue;

    public DefaultValueStack() {
    }

    public DefaultValueStack(Iterable<V> values) {
        this.pushAll(values);
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public int size() {
        Element cursor = this.head;
        int size = 0;
        while (cursor != null) {
            ++size;
            cursor = cursor.tail;
        }
        return size;
    }

    @Override
    public void clear() {
        this.head = null;
    }

    @Override
    public Object takeSnapshot() {
        return this.head;
    }

    @Override
    public void restoreSnapshot(Object snapshot) {
        try {
            this.head = (Element)snapshot;
        }
        catch (ClassCastException ignored) {
            throw new IllegalArgumentException("Given argument '" + snapshot + "' is not a valid snapshot element");
        }
    }

    @Override
    public void push(@Nullable V value) {
        this.head = new Element(value, this.head);
    }

    @Override
    public void push(int down, @Nullable V value) {
        this.head = DefaultValueStack.push(down, value, this.head);
    }

    private static Element push(int down, Object value, Element head) {
        if (down == 0) {
            return new Element(value, head);
        }
        Preconditions.checkNotNull(head, "Cannot push beyond the bottom of the stack");
        if (down > 0) {
            return new Element(head.value, DefaultValueStack.push(down - 1, value, head.tail));
        }
        throw new IllegalArgumentException("Argument 'down' must not be negative");
    }

    @Override
    public void pushAll(@Nullable V firstValue, V ... moreValues) {
        this.push(firstValue);
        for (V value : moreValues) {
            this.push(value);
        }
    }

    @Override
    public void pushAll(@Nonnull Iterable<V> values) {
        this.head = null;
        for (V value : values) {
            this.push(value);
        }
    }

    @Override
    public V pop() {
        return this.pop(0);
    }

    @Override
    public V pop(int down) {
        this.head = this.pop(down, this.head);
        V result = this.tempValue;
        this.tempValue = null;
        return result;
    }

    private Element pop(int down, Element head) {
        Preconditions.checkNotNull(head, "Cannot pop from beyond the bottom of the stack");
        if (down == 0) {
            this.tempValue = head.value;
            return head.tail;
        }
        if (down > 0) {
            return new Element(head.value, this.pop(down - 1, head.tail));
        }
        throw new IllegalArgumentException("Argument 'down' must not be negative");
    }

    @Override
    public V peek() {
        return this.peek(0);
    }

    @Override
    public V peek(int down) {
        return (V)DefaultValueStack.peek(down, this.head);
    }

    private static Object peek(int down, Element head) {
        Preconditions.checkNotNull(head, "Cannot peek beyond the bottom of the stack");
        if (down == 0) {
            return head.value;
        }
        if (down > 0) {
            return DefaultValueStack.peek(down - 1, head.tail);
        }
        throw new IllegalArgumentException("Argument 'down' must not be negative");
    }

    @Override
    public void poke(@Nullable V value) {
        this.poke(0, value);
    }

    @Override
    public void poke(int down, @Nullable V value) {
        this.head = DefaultValueStack.poke(down, value, this.head);
    }

    private static Element poke(int down, @Nullable Object value, @Nonnull Element head) {
        Preconditions.checkNotNull(head, "Cannot poke beyond the bottom of the stack");
        if (down == 0) {
            return new Element(value, head.tail);
        }
        if (down > 0) {
            return new Element(head.value, DefaultValueStack.poke(down - 1, value, head.tail));
        }
        throw new IllegalArgumentException("Argument 'down' must not be negative");
    }

    @Override
    public void dup() {
        this.push(this.peek());
    }

    @Override
    public void swap() {
        Checks.ensure(DefaultValueStack.isSizeGTE(2, this.head), "Swap not allowed on stack with less than two elements");
        Element down1 = this.head.tail;
        this.head = new Element(down1.value, new Element(this.head.value, down1.tail));
    }

    @Override
    public void swap3() {
        Checks.ensure(DefaultValueStack.isSizeGTE(3, this.head), "Swap3 not allowed on stack with less than 3 elements");
        Element down1 = this.head.tail;
        Element down2 = down1.tail;
        this.head = new Element(down2.value, new Element(down1.value, new Element(this.head.value, down2.tail)));
    }

    @Override
    public void swap4() {
        Checks.ensure(DefaultValueStack.isSizeGTE(4, this.head), "Swap4 not allowed on stack with less than 4 elements");
        Element down1 = this.head.tail;
        Element down2 = down1.tail;
        Element down3 = down2.tail;
        this.head = new Element(down3.value, new Element(down2.value, new Element(down1.value, new Element(this.head.value, down3.tail))));
    }

    @Override
    public void swap5() {
        Checks.ensure(DefaultValueStack.isSizeGTE(5, this.head), "Swap5 not allowed on stack with less than 5 elements");
        Element down1 = this.head.tail;
        Element down2 = down1.tail;
        Element down3 = down2.tail;
        Element down4 = down3.tail;
        this.head = new Element(down4.value, new Element(down3.value, new Element(down2.value, new Element(down1.value, new Element(this.head.value, down4.tail)))));
    }

    @Override
    public void swap6() {
        Checks.ensure(DefaultValueStack.isSizeGTE(6, this.head), "Swap6 not allowed on stack with less than 6 elements");
        Element down1 = this.head.tail;
        Element down2 = down1.tail;
        Element down3 = down2.tail;
        Element down4 = down3.tail;
        Element down5 = down4.tail;
        this.head = new Element(down5.value, new Element(down4.value, new Element(down3.value, new Element(down2.value, new Element(down1.value, new Element(this.head.value, down5.tail))))));
    }

    @Override
    public void swap(int n) {
        Preconditions.checkArgument(n >= 2, "illegal argument to swap() (" + n + "), must be 2 or greater");
        if (n > 6) {
            throw new UnsupportedOperationException("this implementation does not support swapping more than 6 elements");
        }
        Preconditions.checkState(DefaultValueStack.isSizeGTE(n, this.head), "not enough elements in stack");
        switch (n) {
            case 2: {
                this.swap();
                break;
            }
            case 3: {
                this.swap3();
                break;
            }
            case 4: {
                this.swap4();
                break;
            }
            case 5: {
                this.swap5();
                break;
            }
            case 6: {
                this.swap6();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static boolean isSizeGTE(int minSize, Element head) {
        return minSize == 1 ? head != null : DefaultValueStack.isSizeGTE(minSize - 1, head.tail);
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private Element next;
            {
                this.next = DefaultValueStack.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public V next() {
                Object value = this.next.value;
                this.next = this.next.tail;
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static class Element {
        protected final Object value;
        protected final Element tail;

        protected Element(@Nullable Object value, Element tail) {
            this.value = value;
            this.tail = tail;
        }
    }
}

