/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.reviewdb.client.Account;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SubmitRecord {
    public Status status;
    public List<Label> labels;
    public String errorMessage;

    public static Optional<SubmitRecord> findOkRecord(Collection<SubmitRecord> in) {
        if (in == null) {
            return Optional.empty();
        }
        return in.stream().filter(r -> r.status == Status.OK).findFirst();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.status);
        if (this.status == Status.RULE_ERROR && this.errorMessage != null) {
            sb.append('(').append(this.errorMessage).append(')');
        }
        sb.append('[');
        if (this.labels != null) {
            String delimiter = "";
            for (Label label : this.labels) {
                sb.append(delimiter).append(label);
                delimiter = ", ";
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof SubmitRecord) {
            SubmitRecord r = (SubmitRecord)o;
            return Objects.equals((Object)this.status, (Object)r.status) && Objects.equals(this.labels, r.labels) && Objects.equals(this.errorMessage, r.errorMessage);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.labels, this.errorMessage});
    }

    public static class Label {
        public String label;
        public Status status;
        public Account.Id appliedBy;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.label).append(": ").append((Object)this.status);
            if (this.appliedBy != null) {
                sb.append(" by ").append(this.appliedBy);
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof Label) {
                Label l = (Label)o;
                return Objects.equals(this.label, l.label) && Objects.equals((Object)this.status, (Object)l.status) && Objects.equals(this.appliedBy, l.appliedBy);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.label, this.status, this.appliedBy});
        }

        public static enum Status {
            OK,
            REJECT,
            NEED,
            MAY,
            IMPOSSIBLE;

        }
    }

    public static enum Status {
        OK,
        NOT_READY,
        CLOSED,
        FORCED,
        RULE_ERROR;

    }
}

