/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.common.Nullable;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;

public class CanonicalWebUrl {
    private final Provider<String> configured;

    @Inject
    CanonicalWebUrl(@com.google.gerrit.server.config.CanonicalWebUrl @Nullable Provider<String> provider) {
        this.configured = provider;
    }

    public String get(HttpServletRequest req) {
        String url = this.configured.get();
        return url != null ? url : CanonicalWebUrl.computeFromRequest(req);
    }

    static String computeFromRequest(HttpServletRequest req) {
        StringBuffer url = req.getRequestURL();
        try {
            url = new StringBuffer(URLDecoder.decode(url.toString(), StandardCharsets.UTF_8.name()));
            url.setLength(url.length() - req.getServletPath().length());
            if (url.charAt(url.length() - 1) != '/') {
                url.append('/');
            }
            return url.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported encoding for request URL " + url, e);
        }
    }
}

