/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.client.UiType;
import com.google.gerrit.httpd.XsrfCookieFilter;
import com.google.gerrit.httpd.raw.BazelBuild;
import com.google.gerrit.httpd.raw.BowerComponentsDevServlet;
import com.google.gerrit.httpd.raw.DirectoryDocServlet;
import com.google.gerrit.httpd.raw.DirectoryGwtUiServlet;
import com.google.gerrit.httpd.raw.FontsDevServlet;
import com.google.gerrit.httpd.raw.IndexServlet;
import com.google.gerrit.httpd.raw.PolyGerritUiServlet;
import com.google.gerrit.httpd.raw.RecompileGwtUiFilter;
import com.google.gerrit.httpd.raw.ResourceServlet;
import com.google.gerrit.httpd.raw.SingleFileServlet;
import com.google.gerrit.httpd.raw.SiteStaticDirectoryServlet;
import com.google.gerrit.httpd.raw.WarDocServlet;
import com.google.gerrit.httpd.raw.WarGwtUiServlet;
import com.google.gerrit.launcher.GerritLauncher;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.config.GerritOptions;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletModule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticModule
extends ServletModule {
    private static final Logger log = LoggerFactory.getLogger(StaticModule.class);
    public static final String CACHE = "static_content";
    public static final String GERRIT_UI_COOKIE = "GERRIT_UI";
    public static final ImmutableList<String> POLYGERRIT_INDEX_PATHS = ImmutableList.of("/", "/c/*", "/q/*", "/x/*", "/admin/*", "/dashboard/*", "/settings/*");
    private static final ImmutableList<String> POLYGERRIT_ASSET_PATHS = ImmutableList.of("/behaviors/*", "/bower_components/*", "/elements/*", "/fonts/*", "/scripts/*", "/styles/*");
    private static final String DOC_SERVLET = "DocServlet";
    private static final String FAVICON_SERVLET = "FaviconServlet";
    private static final String GWT_UI_SERVLET = "GwtUiServlet";
    private static final String POLYGERRIT_INDEX_SERVLET = "PolyGerritUiIndexServlet";
    private static final String ROBOTS_TXT_SERVLET = "RobotsTxtServlet";
    private static final int GERRIT_UI_COOKIE_MAX_AGE = 31536000;
    private final GerritOptions options;
    private Paths paths;

    @Inject
    public StaticModule(GerritOptions options) {
        this.options = options;
    }

    @Provides
    @Singleton
    private Paths getPaths() {
        if (this.paths == null) {
            this.paths = new Paths(this.options);
        }
        return this.paths;
    }

    @Override
    protected void configureServlets() {
        this.serveRegex("^/Documentation/(.+)$", new String[0]).with(StaticModule.named(DOC_SERVLET));
        this.serve("/static/*", new String[0]).with(SiteStaticDirectoryServlet.class);
        this.install(new CacheModule(){

            @Override
            protected void configure() {
                this.cache(StaticModule.CACHE, Path.class, ResourceServlet.Resource.class).maximumWeight(0x100000L).weigher(ResourceServlet.Weigher.class);
            }
        });
        if (!this.options.headless()) {
            this.install(new CoreStaticModule());
        }
        if (this.options.enablePolyGerrit()) {
            this.install(new PolyGerritModule());
        }
        if (this.options.enableGwtUi()) {
            this.install(new GwtUiModule());
        }
    }

    @Provides
    @Singleton
    @Named(value="DocServlet")
    HttpServlet getDocServlet(@Named(value="static_content") Cache<Path, ResourceServlet.Resource> cache) {
        Paths p = this.getPaths();
        if (p.warFs != null) {
            return new WarDocServlet(cache, p.warFs);
        }
        if (p.unpackedWar != null && !p.isDev()) {
            return new DirectoryDocServlet(cache, p.unpackedWar);
        }
        return new HttpServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                resp.sendError(404);
            }
        };
    }

    private static Key<HttpServlet> named(String name) {
        return Key.get(HttpServlet.class, (Annotation)Names.named(name));
    }

    private static class GuiceFilterRequestWrapper
    extends HttpServletRequestWrapper {
        GuiceFilterRequestWrapper(HttpServletRequest req) {
            super(req);
        }

        @Override
        public String getPathInfo() {
            String ctx;
            String res;
            String uri = this.getRequestURI();
            String string = res = uri.startsWith(ctx = this.getContextPath()) ? uri.substring(ctx.length()) : uri;
            if ("/".equals(res)) {
                return null;
            }
            return res;
        }
    }

    @Singleton
    private static class PolyGerritFilter
    implements Filter {
        private final GerritOptions options;
        private final Paths paths;
        private final HttpServlet polyGerritIndex;
        private final PolyGerritUiServlet polygerritUI;
        private final BowerComponentsDevServlet bowerComponentServlet;
        private final FontsDevServlet fontServlet;

        @Inject
        PolyGerritFilter(GerritOptions options, Paths paths, @Named(value="PolyGerritUiIndexServlet") HttpServlet polyGerritIndex, PolyGerritUiServlet polygerritUI, @Nullable BowerComponentsDevServlet bowerComponentServlet, @Nullable FontsDevServlet fontServlet) {
            this.paths = paths;
            this.options = options;
            this.polyGerritIndex = polyGerritIndex;
            this.polygerritUI = polygerritUI;
            this.bowerComponentServlet = bowerComponentServlet;
            this.fontServlet = fontServlet;
            Preconditions.checkState(options.enablePolyGerrit(), "can't install PolyGerritFilter when PolyGerrit is disabled");
        }

        @Override
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        @Override
        public void destroy() {
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            if (this.handlePolyGerritParam(req, res)) {
                return;
            }
            if (!this.isPolyGerritEnabled(req)) {
                chain.doFilter(req, res);
                return;
            }
            GuiceFilterRequestWrapper reqWrapper = new GuiceFilterRequestWrapper(req);
            String path = PolyGerritFilter.pathInfo(req);
            if (this.paths.isDev()) {
                if (path.startsWith("/bower_components/")) {
                    this.bowerComponentServlet.service((ServletRequest)reqWrapper, (ServletResponse)res);
                    return;
                }
                if (path.startsWith("/fonts/")) {
                    this.fontServlet.service((ServletRequest)reqWrapper, (ServletResponse)res);
                    return;
                }
            }
            if (PolyGerritFilter.isPolyGerritIndex(path)) {
                this.polyGerritIndex.service((ServletRequest)reqWrapper, (ServletResponse)res);
                return;
            }
            if (PolyGerritFilter.isPolyGerritAsset(path)) {
                this.polygerritUI.service((ServletRequest)reqWrapper, (ServletResponse)res);
                return;
            }
            chain.doFilter(req, res);
        }

        private static String pathInfo(HttpServletRequest req) {
            String ctx;
            String uri = req.getRequestURI();
            return uri.startsWith(ctx = req.getContextPath()) ? uri.substring(ctx.length()) : uri;
        }

        private boolean handlePolyGerritParam(HttpServletRequest req, HttpServletResponse res) throws IOException {
            if (!this.options.enableGwtUi() || !"GET".equals(req.getMethod())) {
                return false;
            }
            boolean redirect = false;
            String param = req.getParameter("polygerrit");
            if ("1".equals(param)) {
                this.setPolyGerritCookie(req, res, UiType.POLYGERRIT);
                redirect = true;
            } else if ("0".equals(param)) {
                this.setPolyGerritCookie(req, res, UiType.GWT);
                redirect = true;
            }
            if (redirect) {
                res.sendRedirect(req.getRequestURL().toString());
            }
            return redirect;
        }

        private boolean isPolyGerritEnabled(HttpServletRequest req) {
            return !this.options.enableGwtUi() || this.isPolyGerritCookie(req);
        }

        private boolean isPolyGerritCookie(HttpServletRequest req) {
            UiType type = this.options.defaultUi();
            Cookie[] all = req.getCookies();
            if (all != null) {
                for (Cookie c : all) {
                    UiType t;
                    if (!StaticModule.GERRIT_UI_COOKIE.equals(c.getName()) || (t = UiType.parse(c.getValue())) == null) continue;
                    type = t;
                    break;
                }
            }
            return type == UiType.POLYGERRIT;
        }

        private void setPolyGerritCookie(HttpServletRequest req, HttpServletResponse res, UiType pref) {
            Cookie cookie = new Cookie(StaticModule.GERRIT_UI_COOKIE, pref.name());
            if (this.options.enablePolyGerrit() && this.options.enableGwtUi()) {
                cookie.setPath("/");
                cookie.setSecure(PolyGerritFilter.isSecure(req));
                cookie.setMaxAge(31536000);
            } else {
                cookie.setValue("");
                cookie.setMaxAge(0);
            }
            res.addCookie(cookie);
        }

        private static boolean isSecure(HttpServletRequest req) {
            return req.isSecure() || "https".equals(req.getScheme());
        }

        private static boolean isPolyGerritAsset(String path) {
            return PolyGerritFilter.matchPath(POLYGERRIT_ASSET_PATHS, path);
        }

        private static boolean isPolyGerritIndex(String path) {
            return PolyGerritFilter.matchPath(POLYGERRIT_INDEX_PATHS, path);
        }

        private static boolean matchPath(Iterable<String> paths, String path) {
            for (String p : paths) {
                if (!(p.endsWith("/*") ? path.regionMatches(0, p, 0, p.length() - 1) : p.equals(path))) continue;
                return true;
            }
            return false;
        }
    }

    private static class Paths {
        private final FileSystem warFs;
        private final BazelBuild builder;
        private final Path sourceRoot;
        private final Path unpackedWar;
        private final boolean development;

        private Paths(GerritOptions options) {
            block5: {
                try {
                    File launcherLoadedFrom = this.getLauncherLoadedFrom();
                    if (launcherLoadedFrom != null && launcherLoadedFrom.getName().endsWith(".jar")) {
                        this.warFs = null;
                        this.unpackedWar = java.nio.file.Paths.get(launcherLoadedFrom.getParentFile().getParentFile().getParentFile().toURI());
                        this.sourceRoot = null;
                        this.development = false;
                        this.builder = null;
                        return;
                    }
                    this.warFs = this.getDistributionArchive(launcherLoadedFrom);
                    if (this.warFs == null) {
                        this.unpackedWar = this.makeWarTempDir();
                        this.development = true;
                        break block5;
                    }
                    if (options.forcePolyGerritDev()) {
                        this.unpackedWar = null;
                        this.development = true;
                        break block5;
                    }
                    this.unpackedWar = null;
                    this.development = false;
                    this.sourceRoot = null;
                    this.builder = null;
                    return;
                }
                catch (IOException e) {
                    throw new ProvisionException("Error initializing static content paths", e);
                }
            }
            this.sourceRoot = Paths.getSourceRootOrNull();
            this.builder = new BazelBuild(this.sourceRoot);
        }

        private static Path getSourceRootOrNull() {
            try {
                return GerritLauncher.resolveInSourceRoot(".");
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        private FileSystem getDistributionArchive(File war) throws IOException {
            if (war == null) {
                return null;
            }
            return GerritLauncher.getZipFileSystem(war.toPath());
        }

        private File getLauncherLoadedFrom() {
            File war;
            try {
                war = GerritLauncher.getDistributionArchive();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException && "NOT_ARCHIVED".equals(e.getMessage())) {
                    return null;
                }
                ProvisionException pe = new ProvisionException("Error reading gerrit.war");
                pe.initCause(e);
                throw pe;
            }
            return war;
        }

        private boolean isDev() {
            return this.development;
        }

        private Path makeWarTempDir() {
            try {
                File dstwar = GerritLauncher.createTempFile("gerrit_", "war");
                if (!dstwar.delete() || !dstwar.mkdir()) {
                    throw new IOException("Cannot mkdir " + dstwar.getAbsolutePath());
                }
                try {
                    return dstwar.getCanonicalFile().toPath();
                }
                catch (IOException e) {
                    return dstwar.getAbsoluteFile().toPath();
                }
            }
            catch (IOException e) {
                ProvisionException pe = new ProvisionException("Cannot create war tempdir");
                pe.initCause(e);
                throw pe;
            }
        }
    }

    private class PolyGerritModule
    extends ServletModule {
        private PolyGerritModule() {
        }

        @Override
        public void configureServlets() {
            for (String p : POLYGERRIT_INDEX_PATHS) {
                if (p.equals("/")) continue;
                this.filter(p, new String[0]).through(XsrfCookieFilter.class);
            }
            this.filter("/*", new String[0]).through(PolyGerritFilter.class);
        }

        @Provides
        @Singleton
        @Named(value="PolyGerritUiIndexServlet")
        HttpServlet getPolyGerritUiIndexServlet(@CanonicalWebUrl @Nullable String canonicalUrl, @GerritServerConfig Config cfg) throws URISyntaxException {
            String cdnPath = cfg.getString("gerrit", null, "cdnPath");
            return new IndexServlet(canonicalUrl, cdnPath);
        }

        @Provides
        @Singleton
        PolyGerritUiServlet getPolyGerritUiServlet(@Named(value="static_content") Cache<Path, ResourceServlet.Resource> cache) {
            return new PolyGerritUiServlet(cache, this.polyGerritBasePath());
        }

        @Provides
        @Singleton
        BowerComponentsDevServlet getBowerComponentsServlet(@Named(value="static_content") Cache<Path, ResourceServlet.Resource> cache) throws IOException {
            return StaticModule.this.getPaths().isDev() ? new BowerComponentsDevServlet(cache, StaticModule.this.getPaths().builder) : null;
        }

        @Provides
        @Singleton
        FontsDevServlet getFontsServlet(@Named(value="static_content") Cache<Path, ResourceServlet.Resource> cache) throws IOException {
            return StaticModule.this.getPaths().isDev() ? new FontsDevServlet(cache, StaticModule.this.getPaths().builder) : null;
        }

        private Path polyGerritBasePath() {
            Paths p = StaticModule.this.getPaths();
            if (StaticModule.this.options.forcePolyGerritDev()) {
                Preconditions.checkArgument(p.sourceRoot != null, "no source root directory found for PolyGerrit developer mode");
            }
            if (p.isDev()) {
                return p.sourceRoot.resolve("polygerrit-ui").resolve("app");
            }
            return p.warFs != null ? p.warFs.getPath("/polygerrit_ui", new String[0]) : p.unpackedWar.resolve("polygerrit_ui");
        }
    }

    private class GwtUiModule
    extends ServletModule {
        private GwtUiModule() {
        }

        @Override
        public void configureServlets() {
            this.serveRegex("^/gerrit_ui/(?!rpc/)(.*)$", new String[0]).with(Key.get(HttpServlet.class, (Annotation)Names.named(StaticModule.GWT_UI_SERVLET)));
            Paths p = StaticModule.this.getPaths();
            if (p.isDev()) {
                this.filter("/", new String[0]).through(new RecompileGwtUiFilter(p.builder, p.unpackedWar));
            }
        }

        @Provides
        @Singleton
        @Named(value="GwtUiServlet")
        HttpServlet getGwtUiServlet(@Named(value="static_content") Cache<Path, ResourceServlet.Resource> cache) throws IOException {
            Paths p = StaticModule.this.getPaths();
            if (p.warFs != null) {
                return new WarGwtUiServlet(cache, p.warFs);
            }
            return new DirectoryGwtUiServlet(cache, p.unpackedWar, p.isDev());
        }
    }

    private class CoreStaticModule
    extends ServletModule {
        private CoreStaticModule() {
        }

        @Override
        public void configureServlets() {
            this.serve("/robots.txt", new String[0]).with(StaticModule.named(StaticModule.ROBOTS_TXT_SERVLET));
            this.serve("/favicon.ico", new String[0]).with(StaticModule.named(StaticModule.FAVICON_SERVLET));
        }

        @Provides
        @Singleton
        @Named(value="RobotsTxtServlet")
        HttpServlet getRobotsTxtServlet(@GerritServerConfig Config cfg, SitePaths sitePaths, @Named(value="static_content") Cache<Path, ResourceServlet.Resource> cache) {
            Paths p;
            Path configPath = sitePaths.resolve(cfg.getString("httpd", null, "robotsFile"));
            if (configPath != null) {
                if (Files.exists(configPath, new LinkOption[0]) && Files.isReadable(configPath)) {
                    return new SingleFileServlet(cache, configPath, true);
                }
                log.warn("Cannot read httpd.robotsFile, using default");
            }
            if ((p = StaticModule.this.getPaths()).warFs != null) {
                return new SingleFileServlet(cache, p.warFs.getPath("/robots.txt", new String[0]), false);
            }
            return new SingleFileServlet(cache, this.webappSourcePath("robots.txt"), true);
        }

        @Provides
        @Singleton
        @Named(value="FaviconServlet")
        HttpServlet getFaviconServlet(@Named(value="static_content") Cache<Path, ResourceServlet.Resource> cache) {
            Paths p = StaticModule.this.getPaths();
            if (p.warFs != null) {
                return new SingleFileServlet(cache, p.warFs.getPath("/favicon.ico", new String[0]), false);
            }
            return new SingleFileServlet(cache, this.webappSourcePath("favicon.ico"), true);
        }

        private Path webappSourcePath(String name) {
            Paths p = StaticModule.this.getPaths();
            if (p.unpackedWar != null) {
                return p.unpackedWar.resolve(name);
            }
            return p.sourceRoot.resolve("gerrit-war/src/main/webapp/" + name);
        }
    }
}

