/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.lucene;

import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;

public class CustomMappingAnalyzer
extends AnalyzerWrapper {
    private Analyzer delegate;
    private Map<String, String> customMappings;

    public CustomMappingAnalyzer(Analyzer delegate, Map<String, String> customMappings) {
        super(delegate.getReuseStrategy());
        this.delegate = delegate;
        this.customMappings = customMappings;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.delegate;
    }

    @Override
    protected Reader wrapReader(String fieldName, Reader reader) {
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        for (Map.Entry<String, String> e : this.customMappings.entrySet()) {
            builder.add(e.getKey(), e.getValue());
        }
        return new MappingCharFilter(builder.build(), reader);
    }
}

