/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.account.ExternalIdsUpdate;
import com.google.gerrit.server.account.InvalidUserNameException;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gwtjsonrpc.common.VoidResult;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeUserName
implements Callable<VoidResult> {
    private static final Logger log = LoggerFactory.getLogger(ChangeUserName.class);
    public static final String USERNAME_CANNOT_BE_CHANGED = "Username cannot be changed.";
    private final AccountCache accountCache;
    private final SshKeyCache sshKeyCache;
    private final ExternalIdsUpdate.Server externalIdsUpdateFactory;
    private final ReviewDb db;
    private final IdentifiedUser user;
    private final String newUsername;

    @Inject
    ChangeUserName(AccountCache accountCache, SshKeyCache sshKeyCache, ExternalIdsUpdate.Server externalIdsUpdateFactory, @Assisted ReviewDb db, @Assisted IdentifiedUser user, @Nullable @Assisted String newUsername) {
        this.accountCache = accountCache;
        this.sshKeyCache = sshKeyCache;
        this.externalIdsUpdateFactory = externalIdsUpdateFactory;
        this.db = db;
        this.user = user;
        this.newUsername = newUsername;
    }

    @Override
    public VoidResult call() throws OrmException, NameAlreadyUsedException, InvalidUserNameException, IOException, ConfigInvalidException {
        Collection old = ExternalId.from(this.db.accountExternalIds().byAccount(this.user.getAccountId()).toList()).stream().filter(e -> e.isScheme("username")).collect(Collectors.toSet());
        if (!old.isEmpty()) {
            log.error("External id with scheme \"username:\" already exists for the user {}", (Object)this.user.getAccountId());
            throw new IllegalStateException(USERNAME_CANNOT_BE_CHANGED);
        }
        ExternalIdsUpdate externalIdsUpdate = this.externalIdsUpdateFactory.create();
        if (this.newUsername != null && !this.newUsername.isEmpty()) {
            if (!ExternalId.isValidUsername(this.newUsername)) {
                throw new InvalidUserNameException();
            }
            ExternalId.Key key = ExternalId.Key.create("username", this.newUsername);
            try {
                String password = null;
                for (ExternalId i : old) {
                    if (i.password() == null) continue;
                    password = i.password();
                }
                externalIdsUpdate.insert(this.db, ExternalId.create(key, this.user.getAccountId(), null, password));
                log.info("Created the new external Id with key: {}", (Object)key);
            }
            catch (OrmDuplicateKeyException dupeErr) {
                ExternalId other = ExternalId.from(this.db.accountExternalIds().get(key.asAccountExternalIdKey()));
                if (other != null && other.accountId().equals(this.user.getAccountId())) {
                    return VoidResult.INSTANCE;
                }
                throw new NameAlreadyUsedException(this.newUsername);
            }
        }
        externalIdsUpdate.delete(this.db, old);
        for (ExternalId extId : old) {
            this.sshKeyCache.evict(extId.key().id());
            this.accountCache.evictByUsername(extId.key().id());
        }
        this.accountCache.evictByUsername(this.newUsername);
        this.sshKeyCache.evict(this.newUsername);
        return VoidResult.INSTANCE;
    }

    public static interface Factory {
        public ChangeUserName create(ReviewDb var1, IdentifiedUser var2, String var3);
    }
}

