/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupName;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.index.group.GroupIndexer;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GroupCacheImpl
implements GroupCache {
    private static final Logger log = LoggerFactory.getLogger(GroupCacheImpl.class);
    private static final String BYID_NAME = "groups";
    private static final String BYNAME_NAME = "groups_byname";
    private static final String BYUUID_NAME = "groups_byuuid";
    private final LoadingCache<AccountGroup.Id, Optional<AccountGroup>> byId;
    private final LoadingCache<String, Optional<AccountGroup>> byName;
    private final LoadingCache<String, Optional<AccountGroup>> byUUID;
    private final SchemaFactory<ReviewDb> schema;
    private final Provider<GroupIndexer> indexer;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(GroupCacheImpl.BYID_NAME, AccountGroup.Id.class, new TypeLiteral<Optional<AccountGroup>>(){}).loader(ByIdLoader.class);
                this.cache(GroupCacheImpl.BYNAME_NAME, String.class, new TypeLiteral<Optional<AccountGroup>>(){}).loader(ByNameLoader.class);
                this.cache(GroupCacheImpl.BYUUID_NAME, String.class, new TypeLiteral<Optional<AccountGroup>>(){}).loader(ByUUIDLoader.class);
                this.bind(GroupCacheImpl.class);
                this.bind(GroupCache.class).to(GroupCacheImpl.class);
            }
        };
    }

    @Inject
    GroupCacheImpl(@Named(value="groups") LoadingCache<AccountGroup.Id, Optional<AccountGroup>> byId, @Named(value="groups_byname") LoadingCache<String, Optional<AccountGroup>> byName, @Named(value="groups_byuuid") LoadingCache<String, Optional<AccountGroup>> byUUID, SchemaFactory<ReviewDb> schema, Provider<GroupIndexer> indexer) {
        this.byId = byId;
        this.byName = byName;
        this.byUUID = byUUID;
        this.schema = schema;
        this.indexer = indexer;
    }

    @Override
    public AccountGroup get(AccountGroup.Id groupId) {
        try {
            Optional<AccountGroup> g = this.byId.get(groupId);
            return g.isPresent() ? g.get() : GroupCacheImpl.missing(groupId);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load group {}", (Object)groupId, (Object)e);
            return GroupCacheImpl.missing(groupId);
        }
    }

    @Override
    public void evict(AccountGroup group) throws IOException {
        if (group.getId() != null) {
            this.byId.invalidate(group.getId());
        }
        if (group.getNameKey() != null) {
            this.byName.invalidate(group.getNameKey().get());
        }
        if (group.getGroupUUID() != null) {
            this.byUUID.invalidate(group.getGroupUUID().get());
        }
        this.indexer.get().index(group.getGroupUUID());
    }

    @Override
    public void evictAfterRename(AccountGroup.NameKey oldName, AccountGroup.NameKey newName) throws IOException {
        if (oldName != null) {
            this.byName.invalidate(oldName.get());
        }
        if (newName != null) {
            this.byName.invalidate(newName.get());
        }
        this.indexer.get().index(this.get(newName).getGroupUUID());
    }

    @Override
    public AccountGroup get(AccountGroup.NameKey name) {
        if (name == null) {
            return null;
        }
        try {
            return this.byName.get(name.get()).orElse(null);
        }
        catch (ExecutionException e) {
            log.warn("Cannot lookup group {} by name", (Object)name.get(), (Object)e);
            return null;
        }
    }

    @Override
    public AccountGroup get(AccountGroup.UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try {
            return this.byUUID.get(uuid.get()).orElse(null);
        }
        catch (ExecutionException e) {
            log.warn("Cannot lookup group {} by uuid", (Object)uuid.get(), (Object)e);
            return null;
        }
    }

    @Override
    public ImmutableList<AccountGroup> all() {
        ImmutableList<AccountGroup> immutableList;
        block8: {
            ReviewDb db = this.schema.open();
            Throwable throwable = null;
            try {
                immutableList = ImmutableList.copyOf(db.accountGroups().all());
                if (db == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (db != null) {
                            GroupCacheImpl.$closeResource(throwable, db);
                        }
                        throw throwable3;
                    }
                }
                catch (OrmException e) {
                    log.warn("Cannot list internal groups", e);
                    return ImmutableList.of();
                }
            }
            GroupCacheImpl.$closeResource(throwable, db);
        }
        return immutableList;
    }

    @Override
    public void onCreateGroup(AccountGroup.NameKey newGroupName) throws IOException {
        this.byName.invalidate(newGroupName.get());
        this.indexer.get().index(this.get(newGroupName).getGroupUUID());
    }

    private static AccountGroup missing(AccountGroup.Id key) {
        AccountGroup.NameKey name = new AccountGroup.NameKey("Deleted Group" + key);
        return new AccountGroup(name, key, null);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    static class ByUUIDLoader
    extends CacheLoader<String, Optional<AccountGroup>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        ByUUIDLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        @Override
        public Optional<AccountGroup> load(String uuid) throws Exception {
            Throwable throwable = null;
            try (ReviewDb db = this.schema.open();){
                List<AccountGroup> r = db.accountGroups().byUUID(new AccountGroup.UUID(uuid)).toList();
                if (r.size() == 1) {
                    Optional<AccountGroup> optional = Optional.of(r.get(0));
                    return optional;
                }
                if (r.size() == 0) {
                    Optional<AccountGroup> optional = Optional.empty();
                    return optional;
                }
                try {
                    throw new OrmDuplicateKeyException("Duplicate group UUID " + uuid);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    static class ByNameLoader
    extends CacheLoader<String, Optional<AccountGroup>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        ByNameLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        @Override
        public Optional<AccountGroup> load(String name) throws Exception {
            try (ReviewDb db = this.schema.open();){
                AccountGroup.NameKey key = new AccountGroup.NameKey(name);
                AccountGroupName r = db.accountGroupNames().get(key);
                if (r != null) {
                    Optional<AccountGroup> optional = Optional.ofNullable(db.accountGroups().get(r.getId()));
                    return optional;
                }
                Optional<AccountGroup> optional = Optional.empty();
                return optional;
            }
        }
    }

    static class ByIdLoader
    extends CacheLoader<AccountGroup.Id, Optional<AccountGroup>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        ByIdLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        @Override
        public Optional<AccountGroup> load(AccountGroup.Id key) throws Exception {
            try (ReviewDb db = this.schema.open();){
                Optional<AccountGroup> optional = Optional.ofNullable(db.accountGroups().get(key));
                return optional;
            }
        }
    }
}

