/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.GroupDetail;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupDetailFactory;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class GroupMembers {
    private final GroupCache groupCache;
    private final GroupDetailFactory.Factory groupDetailFactory;
    private final AccountCache accountCache;
    private final ProjectControl.GenericFactory projectControl;
    private final CurrentUser currentUser;

    @Inject
    GroupMembers(GroupCache groupCache, GroupDetailFactory.Factory groupDetailFactory, AccountCache accountCache, ProjectControl.GenericFactory projectControl, @Assisted CurrentUser currentUser) {
        this.groupCache = groupCache;
        this.groupDetailFactory = groupDetailFactory;
        this.accountCache = accountCache;
        this.projectControl = projectControl;
        this.currentUser = currentUser;
    }

    public Set<Account> listAccounts(AccountGroup.UUID groupUUID, Project.NameKey project) throws NoSuchGroupException, NoSuchProjectException, OrmException, IOException {
        return this.listAccounts(groupUUID, project, new HashSet<AccountGroup.UUID>());
    }

    private Set<Account> listAccounts(AccountGroup.UUID groupUUID, Project.NameKey project, Set<AccountGroup.UUID> seen) throws NoSuchGroupException, OrmException, NoSuchProjectException, IOException {
        if (SystemGroupBackend.PROJECT_OWNERS.equals(groupUUID)) {
            return this.getProjectOwners(project, seen);
        }
        AccountGroup group = this.groupCache.get(groupUUID);
        if (group != null) {
            return this.getGroupMembers(group, project, seen);
        }
        return Collections.emptySet();
    }

    private Set<Account> getProjectOwners(Project.NameKey project, Set<AccountGroup.UUID> seen) throws NoSuchProjectException, NoSuchGroupException, OrmException, IOException {
        seen.add(SystemGroupBackend.PROJECT_OWNERS);
        if (project == null) {
            return Collections.emptySet();
        }
        Set<AccountGroup.UUID> ownerGroups = this.projectControl.controlFor(project, this.currentUser).getProjectState().getAllOwners();
        HashSet<Account> projectOwners = new HashSet<Account>();
        for (AccountGroup.UUID ownerGroup : ownerGroups) {
            if (seen.contains(ownerGroup)) continue;
            projectOwners.addAll(this.listAccounts(ownerGroup, project, seen));
        }
        return projectOwners;
    }

    private Set<Account> getGroupMembers(AccountGroup group, Project.NameKey project, Set<AccountGroup.UUID> seen) throws NoSuchGroupException, OrmException, NoSuchProjectException, IOException {
        seen.add(group.getGroupUUID());
        GroupDetail groupDetail = this.groupDetailFactory.create(group.getId()).call();
        HashSet<Account> members = new HashSet<Account>();
        if (groupDetail.members != null) {
            for (AccountGroupMember member : groupDetail.members) {
                members.add(this.accountCache.get(member.getAccountId()).getAccount());
            }
        }
        if (groupDetail.includes != null) {
            for (AccountGroupById groupInclude : groupDetail.includes) {
                AccountGroup includedGroup = this.groupCache.get(groupInclude.getIncludeUUID());
                if (includedGroup == null || seen.contains(includedGroup.getGroupUUID())) continue;
                members.addAll(this.listAccounts(includedGroup.getGroupUUID(), project, seen));
            }
        }
        return members;
    }

    public static interface Factory {
        public GroupMembers create(CurrentUser var1);
    }
}

