/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresCapability(value="modifyAccount")
@Singleton
public class PutActive
implements RestModifyView<AccountResource, Input> {
    private final Provider<ReviewDb> dbProvider;
    private final AccountCache byIdCache;

    @Inject
    PutActive(Provider<ReviewDb> dbProvider, AccountCache byIdCache) {
        this.dbProvider = dbProvider;
        this.byIdCache = byIdCache;
    }

    public Response<String> apply(AccountResource rsrc, Input input) throws ResourceNotFoundException, OrmException, IOException {
        final AtomicBoolean alreadyActive = new AtomicBoolean(false);
        Account a = this.dbProvider.get().accounts().atomicUpdate(rsrc.getUser().getAccountId(), new AtomicUpdate<Account>(){

            @Override
            public Account update(Account a) {
                if (a.isActive()) {
                    alreadyActive.set(true);
                } else {
                    a.setActive(true);
                }
                return a;
            }
        });
        if (a == null) {
            throw new ResourceNotFoundException("account not found");
        }
        this.dbProvider.get().accounts().update(Collections.singleton(a));
        this.byIdCache.evict(a.getId());
        return alreadyActive.get() ? Response.ok("") : Response.created("");
    }

    public static class Input {
    }
}

