/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.AbandonInput;
import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.api.changes.AssigneeInput;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.ChangeEditApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.api.changes.FixInput;
import com.google.gerrit.extensions.api.changes.HashtagsInput;
import com.google.gerrit.extensions.api.changes.IncludedInInfo;
import com.google.gerrit.extensions.api.changes.MoveInput;
import com.google.gerrit.extensions.api.changes.RebaseInput;
import com.google.gerrit.extensions.api.changes.RestoreInput;
import com.google.gerrit.extensions.api.changes.RevertInput;
import com.google.gerrit.extensions.api.changes.ReviewerApi;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.api.changes.SubmittedTogetherInfo;
import com.google.gerrit.extensions.api.changes.SubmittedTogetherOption;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.common.EditInfo;
import com.google.gerrit.extensions.common.MergePatchSetInput;
import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.common.SuggestedReviewerInfo;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.changes.ChangeEditApiImpl;
import com.google.gerrit.server.api.changes.ReviewerApiImpl;
import com.google.gerrit.server.api.changes.RevisionApiImpl;
import com.google.gerrit.server.change.Abandon;
import com.google.gerrit.server.change.ChangeIncludedIn;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.Check;
import com.google.gerrit.server.change.CreateMergePatchSet;
import com.google.gerrit.server.change.DeleteAssignee;
import com.google.gerrit.server.change.DeleteChange;
import com.google.gerrit.server.change.GetAssignee;
import com.google.gerrit.server.change.GetHashtags;
import com.google.gerrit.server.change.GetPastAssignees;
import com.google.gerrit.server.change.GetTopic;
import com.google.gerrit.server.change.Index;
import com.google.gerrit.server.change.ListChangeComments;
import com.google.gerrit.server.change.ListChangeDrafts;
import com.google.gerrit.server.change.ListChangeRobotComments;
import com.google.gerrit.server.change.Move;
import com.google.gerrit.server.change.PostHashtags;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.change.PublishDraftPatchSet;
import com.google.gerrit.server.change.PutAssignee;
import com.google.gerrit.server.change.PutTopic;
import com.google.gerrit.server.change.Rebase;
import com.google.gerrit.server.change.Restore;
import com.google.gerrit.server.change.Revert;
import com.google.gerrit.server.change.Reviewers;
import com.google.gerrit.server.change.Revisions;
import com.google.gerrit.server.change.SubmittedTogether;
import com.google.gerrit.server.change.SuggestChangeReviewers;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ChangeApiImpl
implements ChangeApi {
    private final Changes changeApi;
    private final Reviewers reviewers;
    private final Revisions revisions;
    private final ReviewerApiImpl.Factory reviewerApi;
    private final RevisionApiImpl.Factory revisionApi;
    private final SuggestChangeReviewers suggestReviewers;
    private final ChangeResource change;
    private final Abandon abandon;
    private final Revert revert;
    private final Restore restore;
    private final CreateMergePatchSet updateByMerge;
    private final Provider<SubmittedTogether> submittedTogether;
    private final PublishDraftPatchSet.CurrentRevision publishDraftChange;
    private final Rebase.CurrentRevision rebase;
    private final DeleteChange deleteChange;
    private final GetTopic getTopic;
    private final PutTopic putTopic;
    private final ChangeIncludedIn includedIn;
    private final PostReviewers postReviewers;
    private final ChangeJson.Factory changeJson;
    private final PostHashtags postHashtags;
    private final GetHashtags getHashtags;
    private final PutAssignee putAssignee;
    private final GetAssignee getAssignee;
    private final GetPastAssignees getPastAssignees;
    private final DeleteAssignee deleteAssignee;
    private final ListChangeComments listComments;
    private final ListChangeRobotComments listChangeRobotComments;
    private final ListChangeDrafts listDrafts;
    private final ChangeEditApiImpl.Factory changeEditApi;
    private final Check check;
    private final Index index;
    private final Move move;

    @Inject
    ChangeApiImpl(Changes changeApi, Reviewers reviewers, Revisions revisions, ReviewerApiImpl.Factory reviewerApi, RevisionApiImpl.Factory revisionApi, SuggestChangeReviewers suggestReviewers, Abandon abandon, Revert revert, Restore restore, CreateMergePatchSet updateByMerge, Provider<SubmittedTogether> submittedTogether, PublishDraftPatchSet.CurrentRevision publishDraftChange, Rebase.CurrentRevision rebase, DeleteChange deleteChange, GetTopic getTopic, PutTopic putTopic, ChangeIncludedIn includedIn, PostReviewers postReviewers, ChangeJson.Factory changeJson, PostHashtags postHashtags, GetHashtags getHashtags, PutAssignee putAssignee, GetAssignee getAssignee, GetPastAssignees getPastAssignees, DeleteAssignee deleteAssignee, ListChangeComments listComments, ListChangeRobotComments listChangeRobotComments, ListChangeDrafts listDrafts, ChangeEditApiImpl.Factory changeEditApi, Check check, Index index, Move move, @Assisted ChangeResource change) {
        this.changeApi = changeApi;
        this.revert = revert;
        this.reviewers = reviewers;
        this.revisions = revisions;
        this.reviewerApi = reviewerApi;
        this.revisionApi = revisionApi;
        this.suggestReviewers = suggestReviewers;
        this.abandon = abandon;
        this.restore = restore;
        this.updateByMerge = updateByMerge;
        this.submittedTogether = submittedTogether;
        this.publishDraftChange = publishDraftChange;
        this.rebase = rebase;
        this.deleteChange = deleteChange;
        this.getTopic = getTopic;
        this.putTopic = putTopic;
        this.includedIn = includedIn;
        this.postReviewers = postReviewers;
        this.changeJson = changeJson;
        this.postHashtags = postHashtags;
        this.getHashtags = getHashtags;
        this.putAssignee = putAssignee;
        this.getAssignee = getAssignee;
        this.getPastAssignees = getPastAssignees;
        this.deleteAssignee = deleteAssignee;
        this.listComments = listComments;
        this.listChangeRobotComments = listChangeRobotComments;
        this.listDrafts = listDrafts;
        this.changeEditApi = changeEditApi;
        this.check = check;
        this.index = index;
        this.move = move;
        this.change = change;
    }

    @Override
    public String id() {
        return Integer.toString(this.change.getId().get());
    }

    @Override
    public RevisionApi current() throws RestApiException {
        return this.revision("current");
    }

    @Override
    public RevisionApi revision(int id) throws RestApiException {
        return this.revision(String.valueOf(id));
    }

    @Override
    public RevisionApi revision(String id) throws RestApiException {
        try {
            return this.revisionApi.create(this.revisions.parse(this.change, IdString.fromDecoded(id)));
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot parse revision", e);
        }
    }

    @Override
    public ReviewerApi reviewer(String id) throws RestApiException {
        try {
            return this.reviewerApi.create(this.reviewers.parse(this.change, IdString.fromDecoded(id)));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot parse reviewer", e);
        }
    }

    @Override
    public void abandon() throws RestApiException {
        this.abandon(new AbandonInput());
    }

    @Override
    public void abandon(AbandonInput in) throws RestApiException {
        try {
            this.abandon.apply(this.change, in);
        }
        catch (UpdateException | OrmException e) {
            throw new RestApiException("Cannot abandon change", e);
        }
    }

    @Override
    public void restore() throws RestApiException {
        this.restore(new RestoreInput());
    }

    @Override
    public void restore(RestoreInput in) throws RestApiException {
        try {
            this.restore.apply(this.change, in);
        }
        catch (UpdateException | OrmException e) {
            throw new RestApiException("Cannot restore change", e);
        }
    }

    @Override
    public void move(String destination) throws RestApiException {
        MoveInput in = new MoveInput();
        in.destinationBranch = destination;
        this.move(in);
    }

    @Override
    public void move(MoveInput in) throws RestApiException {
        try {
            this.move.apply(this.change, in);
        }
        catch (UpdateException | OrmException e) {
            throw new RestApiException("Cannot move change", e);
        }
    }

    @Override
    public ChangeApi revert() throws RestApiException {
        return this.revert(new RevertInput());
    }

    @Override
    public ChangeApi revert(RevertInput in) throws RestApiException {
        try {
            return this.changeApi.id(this.revert.apply((ChangeResource)this.change, (RevertInput)in)._number);
        }
        catch (UpdateException | OrmException | IOException e) {
            throw new RestApiException("Cannot revert change", e);
        }
    }

    @Override
    public ChangeInfo createMergePatchSet(MergePatchSetInput in) throws RestApiException {
        try {
            return this.updateByMerge.apply(this.change, in).value();
        }
        catch (InvalidChangeOperationException | UpdateException | OrmException | IOException e) {
            throw new RestApiException("Cannot update change by merge", e);
        }
    }

    @Override
    public List<ChangeInfo> submittedTogether() throws RestApiException {
        SubmittedTogetherInfo info = this.submittedTogether(EnumSet.noneOf(ListChangesOption.class), EnumSet.noneOf(SubmittedTogetherOption.class));
        return info.changes;
    }

    @Override
    public SubmittedTogetherInfo submittedTogether(EnumSet<SubmittedTogetherOption> options) throws RestApiException {
        return this.submittedTogether(EnumSet.noneOf(ListChangesOption.class), options);
    }

    @Override
    public SubmittedTogetherInfo submittedTogether(EnumSet<ListChangesOption> listOptions, EnumSet<SubmittedTogetherOption> submitOptions) throws RestApiException {
        try {
            return this.submittedTogether.get().addListChangesOption(listOptions).addSubmittedTogetherOption(submitOptions).applyInfo(this.change);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot query submittedTogether", e);
        }
    }

    @Override
    public void publish() throws RestApiException {
        try {
            this.publishDraftChange.apply(this.change, null);
        }
        catch (UpdateException e) {
            throw new RestApiException("Cannot publish change", e);
        }
    }

    @Override
    public void rebase() throws RestApiException {
        this.rebase(new RebaseInput());
    }

    @Override
    public void rebase(RebaseInput in) throws RestApiException {
        try {
            this.rebase.apply(this.change, in);
        }
        catch (EmailException | UpdateException | OrmException | IOException e) {
            throw new RestApiException("Cannot rebase change", e);
        }
    }

    @Override
    public void delete() throws RestApiException {
        try {
            this.deleteChange.apply(this.change, null);
        }
        catch (UpdateException e) {
            throw new RestApiException("Cannot delete change", e);
        }
    }

    @Override
    public String topic() throws RestApiException {
        return this.getTopic.apply(this.change);
    }

    @Override
    public void topic(String topic) throws RestApiException {
        PutTopic.Input in = new PutTopic.Input();
        in.topic = topic;
        try {
            this.putTopic.apply(this.change, in);
        }
        catch (UpdateException e) {
            throw new RestApiException("Cannot set topic", e);
        }
    }

    @Override
    public IncludedInInfo includedIn() throws RestApiException {
        try {
            return this.includedIn.apply(this.change);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Could not extract IncludedIn data", e);
        }
    }

    @Override
    public void addReviewer(String reviewer) throws RestApiException {
        AddReviewerInput in = new AddReviewerInput();
        in.reviewer = reviewer;
        this.addReviewer(in);
    }

    @Override
    public void addReviewer(AddReviewerInput in) throws RestApiException {
        try {
            this.postReviewers.apply(this.change, in);
        }
        catch (UpdateException | OrmException | IOException e) {
            throw new RestApiException("Cannot add change reviewer", e);
        }
    }

    @Override
    public ChangeApi.SuggestedReviewersRequest suggestReviewers() throws RestApiException {
        return new ChangeApi.SuggestedReviewersRequest(){

            @Override
            public List<SuggestedReviewerInfo> get() throws RestApiException {
                return ChangeApiImpl.this.suggestReviewers(this);
            }
        };
    }

    @Override
    public ChangeApi.SuggestedReviewersRequest suggestReviewers(String query) throws RestApiException {
        return this.suggestReviewers().withQuery(query);
    }

    private List<SuggestedReviewerInfo> suggestReviewers(ChangeApi.SuggestedReviewersRequest r) throws RestApiException {
        try {
            this.suggestReviewers.setQuery(r.getQuery());
            this.suggestReviewers.setLimit(r.getLimit());
            return this.suggestReviewers.apply(this.change);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot retrieve suggested reviewers", e);
        }
    }

    @Override
    public ChangeInfo get(EnumSet<ListChangesOption> s) throws RestApiException {
        try {
            return this.changeJson.create(s).format(this.change);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve change", e);
        }
    }

    @Override
    public ChangeInfo get() throws RestApiException {
        return this.get(EnumSet.complementOf(EnumSet.of(ListChangesOption.CHECK)));
    }

    @Override
    public EditInfo getEdit() throws RestApiException {
        return this.edit().get().orElse(null);
    }

    @Override
    public ChangeEditApi edit() throws RestApiException {
        return this.changeEditApi.create(this.change);
    }

    @Override
    public ChangeInfo info() throws RestApiException {
        return this.get(EnumSet.noneOf(ListChangesOption.class));
    }

    @Override
    public void setHashtags(HashtagsInput input) throws RestApiException {
        try {
            this.postHashtags.apply(this.change, input);
        }
        catch (UpdateException e) {
            throw new RestApiException("Cannot post hashtags", e);
        }
    }

    @Override
    public Set<String> getHashtags() throws RestApiException {
        try {
            return this.getHashtags.apply(this.change).value();
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot get hashtags", e);
        }
    }

    @Override
    public AccountInfo setAssignee(AssigneeInput input) throws RestApiException {
        try {
            return this.putAssignee.apply(this.change, input).value();
        }
        catch (UpdateException | OrmException | IOException e) {
            throw new RestApiException("Cannot set assignee", e);
        }
    }

    @Override
    public AccountInfo getAssignee() throws RestApiException {
        try {
            Response<AccountInfo> r = this.getAssignee.apply(this.change);
            return r.isNone() ? null : r.value();
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get assignee", e);
        }
    }

    @Override
    public List<AccountInfo> getPastAssignees() throws RestApiException {
        try {
            return this.getPastAssignees.apply(this.change).value();
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get past assignees", e);
        }
    }

    @Override
    public AccountInfo deleteAssignee() throws RestApiException {
        try {
            Response<AccountInfo> r = this.deleteAssignee.apply(this.change, null);
            return r.isNone() ? null : r.value();
        }
        catch (UpdateException | OrmException e) {
            throw new RestApiException("Cannot delete assignee", e);
        }
    }

    @Override
    public Map<String, List<CommentInfo>> comments() throws RestApiException {
        try {
            return this.listComments.apply(this.change);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get comments", e);
        }
    }

    @Override
    public Map<String, List<RobotCommentInfo>> robotComments() throws RestApiException {
        try {
            return this.listChangeRobotComments.apply(this.change);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get robot comments", e);
        }
    }

    @Override
    public Map<String, List<CommentInfo>> drafts() throws RestApiException {
        try {
            return this.listDrafts.apply(this.change);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get drafts", e);
        }
    }

    @Override
    public ChangeInfo check() throws RestApiException {
        try {
            return this.check.apply(this.change).value();
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot check change", e);
        }
    }

    @Override
    public ChangeInfo check(FixInput fix) throws RestApiException {
        try {
            return this.check.apply(this.change, fix).value();
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot check change", e);
        }
    }

    @Override
    public void index() throws RestApiException {
        try {
            this.index.apply(this.change, new Index.Input());
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot index change", e);
        }
    }

    static interface Factory {
        public ChangeApiImpl create(ChangeResource var1);
    }
}

