/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.projects;

import com.google.gerrit.extensions.api.projects.TagApi;
import com.google.gerrit.extensions.api.projects.TagInfo;
import com.google.gerrit.extensions.api.projects.TagInput;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.project.CreateTag;
import com.google.gerrit.server.project.DeleteTag;
import com.google.gerrit.server.project.ListTags;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.TagResource;
import com.google.gerrit.server.project.TagsCollection;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;

public class TagApiImpl
implements TagApi {
    private final ListTags listTags;
    private final CreateTag.Factory createTagFactory;
    private final DeleteTag deleteTag;
    private final TagsCollection tags;
    private final String ref;
    private final ProjectResource project;

    @Inject
    TagApiImpl(ListTags listTags, CreateTag.Factory createTagFactory, DeleteTag deleteTag, TagsCollection tags, @Assisted ProjectResource project, @Assisted String ref) {
        this.listTags = listTags;
        this.createTagFactory = createTagFactory;
        this.deleteTag = deleteTag;
        this.tags = tags;
        this.project = project;
        this.ref = ref;
    }

    @Override
    public TagApi create(TagInput input) throws RestApiException {
        try {
            this.createTagFactory.create(this.ref).apply(this.project, input);
            return this;
        }
        catch (IOException e) {
            throw new RestApiException("Cannot create tag", e);
        }
    }

    @Override
    public TagInfo get() throws RestApiException {
        try {
            return this.listTags.get(this.project, IdString.fromDecoded(this.ref));
        }
        catch (IOException e) {
            throw new RestApiException(e.getMessage());
        }
    }

    @Override
    public void delete() throws RestApiException {
        try {
            this.deleteTag.apply(this.resource(), new DeleteTag.Input());
        }
        catch (OrmException | IOException e) {
            throw new RestApiException(e.getMessage());
        }
    }

    private TagResource resource() throws RestApiException, IOException {
        return this.tags.parse(this.project, IdString.fromDecoded(this.ref));
    }

    static interface Factory {
        public TagApiImpl create(ProjectResource var1, String var2);
    }
}

