/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.extensions.api.changes.DeleteVoteInput;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.LabelId;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.NotifyUtil;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.change.VoteResource;
import com.google.gerrit.server.extensions.events.VoteDeleted;
import com.google.gerrit.server.mail.send.DeleteVoteSender;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.UpdateException;
import com.google.gerrit.server.util.LabelVote;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DeleteVote
implements RestModifyView<VoteResource, DeleteVoteInput> {
    private static final Logger log = LoggerFactory.getLogger(DeleteVote.class);
    private final Provider<ReviewDb> db;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final ApprovalsUtil approvalsUtil;
    private final PatchSetUtil psUtil;
    private final ChangeMessagesUtil cmUtil;
    private final IdentifiedUser.GenericFactory userFactory;
    private final VoteDeleted voteDeleted;
    private final DeleteVoteSender.Factory deleteVoteSenderFactory;
    private final NotifyUtil notifyUtil;

    @Inject
    DeleteVote(Provider<ReviewDb> db, BatchUpdate.Factory batchUpdateFactory, ApprovalsUtil approvalsUtil, PatchSetUtil psUtil, ChangeMessagesUtil cmUtil, IdentifiedUser.GenericFactory userFactory, VoteDeleted voteDeleted, DeleteVoteSender.Factory deleteVoteSenderFactory, NotifyUtil notifyUtil) {
        this.db = db;
        this.batchUpdateFactory = batchUpdateFactory;
        this.approvalsUtil = approvalsUtil;
        this.psUtil = psUtil;
        this.cmUtil = cmUtil;
        this.userFactory = userFactory;
        this.voteDeleted = voteDeleted;
        this.deleteVoteSenderFactory = deleteVoteSenderFactory;
        this.notifyUtil = notifyUtil;
    }

    public Response<?> apply(VoteResource rsrc, DeleteVoteInput input) throws RestApiException, UpdateException {
        if (input == null) {
            input = new DeleteVoteInput();
        }
        if (input.label != null && !rsrc.getLabel().equals(input.label)) {
            throw new BadRequestException("label must match URL");
        }
        if (input.notify == null) {
            input.notify = NotifyHandling.ALL;
        }
        ReviewerResource r = rsrc.getReviewer();
        Change change = r.getChange();
        if (r.getRevisionResource() != null && !r.getRevisionResource().isCurrent()) {
            throw new MethodNotAllowedException("Cannot delete vote on non-current patch set");
        }
        try (BatchUpdate bu = this.batchUpdateFactory.create(this.db.get(), change.getProject(), r.getControl().getUser(), TimeUtil.nowTs());){
            bu.addOp(change.getId(), new Op(r.getReviewerUser().getAccount(), rsrc.getLabel(), input));
            bu.execute();
        }
        return Response.none();
    }

    private class Op
    implements BatchUpdateOp {
        private final Account account;
        private final String label;
        private final DeleteVoteInput input;
        private ChangeMessage changeMessage;
        private Change change;
        private PatchSet ps;
        private Map<String, Short> newApprovals = new HashMap<String, Short>();
        private Map<String, Short> oldApprovals = new HashMap<String, Short>();

        private Op(Account account, String label, DeleteVoteInput input) {
            this.account = account;
            this.label = label;
            this.input = input;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws OrmException, AuthException, ResourceNotFoundException {
            ChangeControl ctl = ctx.getControl();
            this.change = ctl.getChange();
            PatchSet.Id psId = this.change.currentPatchSetId();
            this.ps = DeleteVote.this.psUtil.current((ReviewDb)DeleteVote.this.db.get(), ctl.getNotes());
            boolean found = false;
            LabelTypes labelTypes = ctx.getControl().getLabelTypes();
            for (PatchSetApproval a : DeleteVote.this.approvalsUtil.byPatchSetUser(ctx.getDb(), ctl, psId, this.account.getId())) {
                if (labelTypes.byLabel(a.getLabelId()) == null) continue;
                if (!a.getLabel().equals(this.label)) {
                    this.newApprovals.put(a.getLabel(), a.getValue());
                    continue;
                }
                if (!ctl.canRemoveReviewer(a)) {
                    throw new AuthException("delete vote not permitted");
                }
                this.newApprovals.put(a.getLabel(), (short)0);
                found = true;
                this.oldApprovals.put(a.getLabel(), a.getValue());
                break;
            }
            if (!found) {
                throw new ResourceNotFoundException();
            }
            ctx.getUpdate(psId).removeApprovalFor(this.account.getId(), this.label);
            ctx.getDb().patchSetApprovals().upsert(Collections.singleton(this.deletedApproval(ctx)));
            StringBuilder msg = new StringBuilder();
            msg.append("Removed ");
            LabelVote.appendTo(msg, this.label, Preconditions.checkNotNull(this.oldApprovals.get(this.label)));
            msg.append(" by ").append(DeleteVote.this.userFactory.create(this.account.getId()).getNameEmail()).append("\n");
            this.changeMessage = ChangeMessagesUtil.newMessage(ctx, msg.toString(), "autogenerated:gerrit:deleteVote");
            DeleteVote.this.cmUtil.addChangeMessage(ctx.getDb(), ctx.getUpdate(psId), this.changeMessage);
            return true;
        }

        private PatchSetApproval deletedApproval(ChangeContext ctx) {
            return new PatchSetApproval(new PatchSetApproval.Key(this.ps.getId(), this.account.getId(), new LabelId(this.label)), 0, ctx.getWhen());
        }

        @Override
        public void postUpdate(Context ctx) {
            if (this.changeMessage == null) {
                return;
            }
            IdentifiedUser user = ctx.getIdentifiedUser();
            if (NotifyUtil.shouldNotify(this.input.notify, this.input.notifyDetails)) {
                try {
                    DeleteVoteSender cm = DeleteVote.this.deleteVoteSenderFactory.create(ctx.getProject(), this.change.getId());
                    cm.setFrom(user.getAccountId());
                    cm.setChangeMessage(this.changeMessage.getMessage(), ctx.getWhen());
                    cm.setNotify(this.input.notify);
                    cm.setAccountsToNotify(DeleteVote.this.notifyUtil.resolveAccounts(this.input.notifyDetails));
                    cm.send();
                }
                catch (Exception e) {
                    log.error("Cannot email update for change " + this.change.getId(), e);
                }
            }
            DeleteVote.this.voteDeleted.fire(this.change, this.ps, this.account, this.newApprovals, this.oldApprovals, this.input.notify, this.changeMessage.getMessage(), user.getAccount(), ctx.getWhen());
        }
    }
}

