/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.DraftCommentResource;
import com.google.gerrit.server.change.ListRevisionDrafts;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class DraftComments
implements ChildCollection<RevisionResource, DraftCommentResource> {
    private final DynamicMap<RestView<DraftCommentResource>> views;
    private final Provider<CurrentUser> user;
    private final ListRevisionDrafts list;
    private final Provider<ReviewDb> dbProvider;
    private final CommentsUtil commentsUtil;

    @Inject
    DraftComments(DynamicMap<RestView<DraftCommentResource>> views, Provider<CurrentUser> user, ListRevisionDrafts list, Provider<ReviewDb> dbProvider, CommentsUtil commentsUtil) {
        this.views = views;
        this.user = user;
        this.list = list;
        this.dbProvider = dbProvider;
        this.commentsUtil = commentsUtil;
    }

    @Override
    public DynamicMap<RestView<DraftCommentResource>> views() {
        return this.views;
    }

    public ListRevisionDrafts list() throws AuthException {
        this.checkIdentifiedUser();
        return this.list;
    }

    @Override
    public DraftCommentResource parse(RevisionResource rev, IdString id) throws ResourceNotFoundException, OrmException, AuthException {
        this.checkIdentifiedUser();
        String uuid = id.get();
        for (Comment c : this.commentsUtil.draftByPatchSetAuthor(this.dbProvider.get(), rev.getPatchSet().getId(), rev.getAccountId(), rev.getNotes())) {
            if (!uuid.equals(c.key.uuid)) continue;
            return new DraftCommentResource(rev, c);
        }
        throw new ResourceNotFoundException(id);
    }

    private void checkIdentifiedUser() throws AuthException {
        if (!this.user.get().isIdentifiedUser()) {
            throw new AuthException("drafts only available to authenticated users");
        }
    }
}

