/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Optional;

@Singleton
public class GetAssignee
implements RestReadView<ChangeResource> {
    private final AccountLoader.Factory accountLoaderFactory;

    @Inject
    GetAssignee(AccountLoader.Factory accountLoaderFactory) {
        this.accountLoaderFactory = accountLoaderFactory;
    }

    public Response<AccountInfo> apply(ChangeResource rsrc) throws OrmException {
        Optional<Account.Id> assignee = Optional.ofNullable(rsrc.getChange().getAssignee());
        if (assignee.isPresent()) {
            return Response.ok(this.accountLoaderFactory.create(true).fillOne(assignee.get()));
        }
        return Response.none();
    }
}

