/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.data.Capable;
import com.google.gerrit.extensions.api.changes.PublishChangeEditInput;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsPost;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.change.ChangeEditResource;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.NotifyUtil;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.edit.ChangeEditUtil;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Optional;

@Singleton
public class PublishChangeEdit
implements ChildCollection<ChangeResource, ChangeEditResource>,
AcceptsPost<ChangeResource> {
    private final Publish publish;

    @Inject
    PublishChangeEdit(Publish publish) {
        this.publish = publish;
    }

    @Override
    public DynamicMap<RestView<ChangeEditResource>> views() {
        throw new NotImplementedException();
    }

    @Override
    public RestView<ChangeResource> list() {
        throw new NotImplementedException();
    }

    @Override
    public ChangeEditResource parse(ChangeResource parent, IdString id) {
        throw new NotImplementedException();
    }

    public Publish post(ChangeResource parent) throws RestApiException {
        return this.publish;
    }

    @Singleton
    public static class Publish
    implements RestModifyView<ChangeResource, PublishChangeEditInput> {
        private final ChangeEditUtil editUtil;
        private final NotifyUtil notifyUtil;

        @Inject
        Publish(ChangeEditUtil editUtil, NotifyUtil notifyUtil) {
            this.editUtil = editUtil;
            this.notifyUtil = notifyUtil;
        }

        public Response<?> apply(ChangeResource rsrc, PublishChangeEditInput in) throws IOException, OrmException, RestApiException, UpdateException {
            Capable r = rsrc.getControl().getProjectControl().canPushToAtLeastOneRef();
            if (r != Capable.OK) {
                throw new AuthException(r.getMessage());
            }
            Optional<ChangeEdit> edit = this.editUtil.byChange(rsrc.getChange());
            if (!edit.isPresent()) {
                throw new ResourceConflictException(String.format("no edit exists for change %s", rsrc.getChange().getChangeId()));
            }
            if (in == null) {
                in = new PublishChangeEditInput();
            }
            this.editUtil.publish(edit.get(), in.notify, this.notifyUtil.resolveAccounts(in.notifyDetails));
            return Response.none();
        }
    }
}

