/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.HashtagsInput;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.change.HashtagsUtil;
import com.google.gerrit.server.extensions.events.HashtagsEdited;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.validators.HashtagValidationListener;
import com.google.gerrit.server.validators.ValidationException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SetHashtagsOp
implements BatchUpdateOp {
    private final NotesMigration notesMigration;
    private final ChangeMessagesUtil cmUtil;
    private final DynamicSet<HashtagValidationListener> validationListeners;
    private final HashtagsEdited hashtagsEdited;
    private final HashtagsInput input;
    private boolean fireEvent = true;
    private Change change;
    private Set<String> toAdd;
    private Set<String> toRemove;
    private ImmutableSortedSet<String> updatedHashtags;

    @AssistedInject
    SetHashtagsOp(NotesMigration notesMigration, ChangeMessagesUtil cmUtil, DynamicSet<HashtagValidationListener> validationListeners, HashtagsEdited hashtagsEdited, @Assisted @Nullable HashtagsInput input) {
        this.notesMigration = notesMigration;
        this.cmUtil = cmUtil;
        this.validationListeners = validationListeners;
        this.hashtagsEdited = hashtagsEdited;
        this.input = input;
    }

    public SetHashtagsOp setFireEvent(boolean fireEvent) {
        this.fireEvent = fireEvent;
        return this;
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws AuthException, BadRequestException, MethodNotAllowedException, OrmException, IOException {
        if (!this.notesMigration.readChanges()) {
            throw new MethodNotAllowedException("Cannot add hashtags; NoteDb is disabled");
        }
        if (this.input == null || this.input.add == null && this.input.remove == null) {
            this.updatedHashtags = ImmutableSortedSet.of();
            return false;
        }
        if (!ctx.getControl().canEditHashtags()) {
            throw new AuthException("Editing hashtags not permitted");
        }
        this.change = ctx.getChange();
        ChangeUpdate update = ctx.getUpdate(this.change.currentPatchSetId());
        ChangeNotes notes = (ChangeNotes)update.getNotes().load();
        ImmutableSet<String> existingHashtags = notes.getHashtags();
        HashSet<String> updated = new HashSet<String>();
        this.toAdd = new HashSet<String>(HashtagsUtil.extractTags(this.input.add));
        this.toRemove = new HashSet<String>(HashtagsUtil.extractTags(this.input.remove));
        try {
            for (HashtagValidationListener validator : this.validationListeners) {
                validator.validateHashtags(update.getChange(), this.toAdd, this.toRemove);
            }
        }
        catch (ValidationException e) {
            throw new BadRequestException(e.getMessage());
        }
        updated.addAll(existingHashtags);
        this.toAdd.removeAll(existingHashtags);
        this.toRemove.retainAll(existingHashtags);
        if (this.updated()) {
            updated.addAll(this.toAdd);
            updated.removeAll(this.toRemove);
            update.setHashtags(updated);
            this.addMessage(ctx, update);
        }
        this.updatedHashtags = ImmutableSortedSet.copyOf(updated);
        return true;
    }

    private void addMessage(ChangeContext ctx, ChangeUpdate update) throws OrmException {
        StringBuilder msg = new StringBuilder();
        this.appendHashtagMessage(msg, "added", this.toAdd);
        this.appendHashtagMessage(msg, "removed", this.toRemove);
        ChangeMessage cmsg = ChangeMessagesUtil.newMessage(ctx, msg.toString(), "autogenerated:gerrit:setHashtag");
        this.cmUtil.addChangeMessage(ctx.getDb(), update, cmsg);
    }

    private void appendHashtagMessage(StringBuilder b, String action, Set<String> hashtags) {
        if (SetHashtagsOp.isNullOrEmpty(hashtags)) {
            return;
        }
        if (b.length() > 0) {
            b.append("\n");
        }
        b.append("Hashtag");
        if (hashtags.size() > 1) {
            b.append("s");
        }
        b.append(" ");
        b.append(action);
        b.append(": ");
        b.append(Joiner.on(", ").join(Ordering.natural().sortedCopy(hashtags)));
    }

    @Override
    public void postUpdate(Context ctx) throws OrmException {
        if (this.updated() && this.fireEvent) {
            this.hashtagsEdited.fire(this.change, ctx.getAccount(), this.updatedHashtags, this.toAdd, this.toRemove, ctx.getWhen());
        }
    }

    public ImmutableSortedSet<String> getUpdatedHashtags() {
        Preconditions.checkState(this.updatedHashtags != null, "getUpdatedHashtags() only valid after executing op");
        return this.updatedHashtags;
    }

    private boolean updated() {
        return !SetHashtagsOp.isNullOrEmpty(this.toAdd) || !SetHashtagsOp.isNullOrEmpty(this.toRemove);
    }

    private static boolean isNullOrEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static interface Factory {
        public SetHashtagsOp create(HashtagsInput var1);
    }
}

