/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.ScheduleConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;

@Singleton
public class ChangeCleanupConfig {
    private static String SECTION = "changeCleanup";
    private static String KEY_ABANDON_AFTER = "abandonAfter";
    private static String KEY_ABANDON_IF_MERGEABLE = "abandonIfMergeable";
    private static String KEY_ABANDON_MESSAGE = "abandonMessage";
    private static String DEFAULT_ABANDON_MESSAGE = "Auto-Abandoned due to inactivity, see ${URL}Documentation/user-change-cleanup.html#auto-abandon\n\nIf this change is still wanted it should be restored.";
    private final ScheduleConfig scheduleConfig;
    private final long abandonAfter;
    private final boolean abandonIfMergeable;
    private final String abandonMessage;

    @Inject
    ChangeCleanupConfig(@GerritServerConfig Config cfg, @CanonicalWebUrl @Nullable String canonicalWebUrl) {
        this.scheduleConfig = new ScheduleConfig(cfg, SECTION);
        this.abandonAfter = this.readAbandonAfter(cfg);
        this.abandonIfMergeable = cfg.getBoolean(SECTION, null, KEY_ABANDON_IF_MERGEABLE, true);
        this.abandonMessage = this.readAbandonMessage(cfg, canonicalWebUrl);
    }

    private long readAbandonAfter(Config cfg) {
        long abandonAfter = ConfigUtil.getTimeUnit(cfg, SECTION, null, KEY_ABANDON_AFTER, 0L, TimeUnit.MILLISECONDS);
        return abandonAfter >= 0L ? abandonAfter : 0L;
    }

    private String readAbandonMessage(Config cfg, String webUrl) {
        String abandonMessage = cfg.getString(SECTION, null, KEY_ABANDON_MESSAGE);
        if (Strings.isNullOrEmpty(abandonMessage)) {
            abandonMessage = DEFAULT_ABANDON_MESSAGE;
        }
        if (!Strings.isNullOrEmpty(webUrl)) {
            abandonMessage = abandonMessage.replaceAll("\\$\\{URL\\}", webUrl);
        }
        return abandonMessage;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public long getAbandonAfter() {
        return this.abandonAfter;
    }

    public boolean getAbandonIfMergeable() {
        return this.abandonIfMergeable;
    }

    public String getAbandonMessage() {
        return this.abandonMessage;
    }
}

