/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.server.git.InsertedObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PackParser;

public class InMemoryInserter
extends ObjectInserter {
    private final ObjectReader reader;
    private final Map<ObjectId, InsertedObject> inserted = new LinkedHashMap<ObjectId, InsertedObject>();
    private final boolean closeReader;

    public InMemoryInserter(ObjectReader reader) {
        this.reader = Preconditions.checkNotNull(reader);
        this.closeReader = false;
    }

    public InMemoryInserter(Repository repo) {
        this.reader = repo.newObjectReader();
        this.closeReader = true;
    }

    @Override
    public ObjectId insert(int type, long length, InputStream in) throws IOException {
        return this.insert(InsertedObject.create(type, in));
    }

    @Override
    public ObjectId insert(int type, byte[] data) {
        return this.insert(type, data, 0, data.length);
    }

    @Override
    public ObjectId insert(int type, byte[] data, int off, int len) {
        return this.insert(InsertedObject.create(type, data, off, len));
    }

    public ObjectId insert(InsertedObject obj) {
        this.inserted.put(obj.id(), obj);
        return obj.id();
    }

    @Override
    public PackParser newPackParser(InputStream in) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectReader newReader() {
        return new Reader();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public ImmutableList<InsertedObject> getInsertedObjects() {
        return ImmutableList.copyOf(this.inserted.values());
    }

    public void clear() {
        this.inserted.clear();
    }

    private class Reader
    extends ObjectReader {
        private Reader() {
        }

        @Override
        public ObjectReader newReader() {
            return new Reader();
        }

        @Override
        public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
            HashSet<ObjectId> result = new HashSet<ObjectId>();
            for (ObjectId insId : InMemoryInserter.this.inserted.keySet()) {
                if (id.prefixCompare(insId) != 0) continue;
                result.add(insId);
            }
            result.addAll(InMemoryInserter.this.reader.resolve(id));
            return result;
        }

        @Override
        public ObjectLoader open(AnyObjectId objectId, int typeHint) throws IOException {
            InsertedObject obj = (InsertedObject)InMemoryInserter.this.inserted.get(objectId);
            if (obj == null) {
                return InMemoryInserter.this.reader.open(objectId, typeHint);
            }
            if (typeHint != -1 && obj.type() != typeHint) {
                throw new IncorrectObjectTypeException(objectId.copy(), typeHint);
            }
            return obj.newLoader();
        }

        @Override
        public Set<ObjectId> getShallowCommits() throws IOException {
            return InMemoryInserter.this.reader.getShallowCommits();
        }

        @Override
        public void close() {
        }

        @Override
        public ObjectInserter getCreatedFromInserter() {
            return InMemoryInserter.this;
        }
    }
}

