/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gerrit.common.FooterConstants;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.MergeConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.LabelId;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.ChangeAlreadyMergedException;
import com.google.gerrit.server.git.ChangeMessageModifier;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.InMemoryInserter;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.MergeIdenticalTreeException;
import com.google.gerrit.server.git.MergeSorter;
import com.google.gerrit.server.git.strategy.CommitMergeStatus;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoMergeBaseException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.ThreeWayMergeStrategy;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeUtil {
    private static final Logger log = LoggerFactory.getLogger(MergeUtil.class);
    private static final String R_HEADS_MASTER = "refs/heads/master";
    private final Provider<ReviewDb> db;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final Provider<String> urlProvider;
    private final ApprovalsUtil approvalsUtil;
    private final ProjectState project;
    private final boolean useContentMerge;
    private final boolean useRecursiveMerge;
    private final PluggableCommitMessageGenerator commitMessageGenerator;

    public static boolean useRecursiveMerge(Config cfg) {
        return cfg.getBoolean("core", null, "useRecursiveMerge", true);
    }

    public static ThreeWayMergeStrategy getMergeStrategy(Config cfg) {
        return MergeUtil.useRecursiveMerge(cfg) ? MergeStrategy.RECURSIVE : MergeStrategy.RESOLVE;
    }

    @AssistedInject
    MergeUtil(@GerritServerConfig Config serverConfig, Provider<ReviewDb> db, IdentifiedUser.GenericFactory identifiedUserFactory, @CanonicalWebUrl @Nullable Provider<String> urlProvider, ApprovalsUtil approvalsUtil, PluggableCommitMessageGenerator commitMessageGenerator, @Assisted ProjectState project) {
        this(serverConfig, db, identifiedUserFactory, urlProvider, approvalsUtil, project, commitMessageGenerator, project.isUseContentMerge());
    }

    @AssistedInject
    MergeUtil(@GerritServerConfig Config serverConfig, Provider<ReviewDb> db, IdentifiedUser.GenericFactory identifiedUserFactory, @CanonicalWebUrl @Nullable Provider<String> urlProvider, ApprovalsUtil approvalsUtil, @Assisted ProjectState project, PluggableCommitMessageGenerator commitMessageGenerator, @Assisted boolean useContentMerge) {
        this.db = db;
        this.identifiedUserFactory = identifiedUserFactory;
        this.urlProvider = urlProvider;
        this.approvalsUtil = approvalsUtil;
        this.project = project;
        this.useContentMerge = useContentMerge;
        this.useRecursiveMerge = MergeUtil.useRecursiveMerge(serverConfig);
        this.commitMessageGenerator = commitMessageGenerator;
    }

    public CodeReviewCommit getFirstFastForward(CodeReviewCommit mergeTip, RevWalk rw, List<CodeReviewCommit> toMerge) throws IntegrationException {
        Iterator<CodeReviewCommit> i = toMerge.iterator();
        while (i.hasNext()) {
            try {
                CodeReviewCommit n = i.next();
                if (mergeTip != null && !rw.isMergedInto(mergeTip, n)) continue;
                i.remove();
                return n;
            }
            catch (IOException e) {
                throw new IntegrationException("Cannot fast-forward test during merge", e);
            }
        }
        return mergeTip;
    }

    public List<CodeReviewCommit> reduceToMinimalMerge(MergeSorter mergeSorter, Collection<CodeReviewCommit> toSort, Set<CodeReviewCommit> incoming) throws IntegrationException {
        ArrayList<CodeReviewCommit> result = new ArrayList<CodeReviewCommit>();
        try {
            result.addAll(mergeSorter.sort(toSort, incoming));
        }
        catch (IOException e) {
            throw new IntegrationException("Branch head sorting failed", e);
        }
        Collections.sort(result, CodeReviewCommit.ORDER);
        return result;
    }

    public CodeReviewCommit createCherryPickFromCommit(Repository repo, ObjectInserter inserter, RevCommit mergeTip, RevCommit originalCommit, PersonIdent cherryPickCommitterIdent, String commitMsg, CodeReviewCommit.CodeReviewRevWalk rw, int parentIndex, boolean ignoreIdenticalTree) throws MissingObjectException, IncorrectObjectTypeException, IOException, MergeIdenticalTreeException, MergeConflictException {
        ThreeWayMerger m = this.newThreeWayMerger(repo, inserter);
        m.setBase(originalCommit.getParent(parentIndex));
        if (m.merge(mergeTip, originalCommit)) {
            ObjectId tree = m.getResultTreeId();
            if (tree.equals(mergeTip.getTree()) && !ignoreIdenticalTree) {
                throw new MergeIdenticalTreeException("identical tree");
            }
            CommitBuilder mergeCommit = new CommitBuilder();
            mergeCommit.setTreeId(tree);
            mergeCommit.setParentId(mergeTip);
            mergeCommit.setAuthor(originalCommit.getAuthorIdent());
            mergeCommit.setCommitter(cherryPickCommitterIdent);
            mergeCommit.setMessage(commitMsg);
            return rw.parseCommit(inserter.insert(mergeCommit));
        }
        throw new MergeConflictException("merge conflict");
    }

    public static RevCommit createMergeCommit(Repository repo, ObjectInserter inserter, RevCommit mergeTip, RevCommit originalCommit, String mergeStrategy, PersonIdent committerIndent, String commitMsg, RevWalk rw) throws IOException, MergeIdenticalTreeException, MergeConflictException {
        if (!MergeStrategy.THEIRS.getName().equals(mergeStrategy) && rw.isMergedInto(originalCommit, mergeTip)) {
            throw new ChangeAlreadyMergedException("'" + originalCommit.getName() + "' has already been merged");
        }
        Merger m = MergeUtil.newMerger(repo, inserter, mergeStrategy);
        if (m.merge(false, mergeTip, originalCommit)) {
            ObjectId tree = m.getResultTreeId();
            CommitBuilder mergeCommit = new CommitBuilder();
            mergeCommit.setTreeId(tree);
            mergeCommit.setParentIds((AnyObjectId)mergeTip, (AnyObjectId)originalCommit);
            mergeCommit.setAuthor(committerIndent);
            mergeCommit.setCommitter(committerIndent);
            mergeCommit.setMessage(commitMsg);
            return rw.parseCommit(inserter.insert(mergeCommit));
        }
        List<String> conflicts = ImmutableList.of();
        if (m instanceof ResolveMerger) {
            conflicts = ((ResolveMerger)m).getUnmergedPaths();
        }
        throw new MergeConflictException(MergeUtil.createConflictMessage(conflicts));
    }

    public static String createConflictMessage(List<String> conflicts) {
        StringBuilder sb = new StringBuilder("merge conflict(s)");
        for (String c : conflicts) {
            sb.append('\n' + c);
        }
        return sb.toString();
    }

    private String createDetailedCommitMessage(RevCommit n, ChangeControl ctl, PatchSet.Id psId) {
        String url;
        String siteUrl;
        Change c = ctl.getChange();
        List<FooterLine> footers = n.getFooterLines();
        StringBuilder msgbuf = new StringBuilder();
        msgbuf.append(n.getFullMessage());
        if (msgbuf.length() == 0) {
            msgbuf.append("<no commit message provided>");
        }
        if (msgbuf.charAt(msgbuf.length() - 1) != '\n') {
            msgbuf.append('\n');
        }
        if (footers.isEmpty()) {
            msgbuf.append('\n');
        }
        if (!MergeUtil.contains(footers, FooterConstants.CHANGE_ID, c.getKey().get())) {
            msgbuf.append(FooterConstants.CHANGE_ID.getName());
            msgbuf.append(": ");
            msgbuf.append(c.getKey().get());
            msgbuf.append('\n');
        }
        if ((siteUrl = this.urlProvider.get()) != null && !MergeUtil.contains(footers, FooterConstants.REVIEWED_ON, url = siteUrl + c.getId().get())) {
            msgbuf.append(FooterConstants.REVIEWED_ON.getName());
            msgbuf.append(": ");
            msgbuf.append(url);
            msgbuf.append('\n');
        }
        PatchSetApproval submitAudit = null;
        for (PatchSetApproval a : this.safeGetApprovals(ctl, psId)) {
            String tag;
            if (a.getValue() <= 0) continue;
            if (a.isLegacySubmit()) {
                if (submitAudit != null && a.getGranted().compareTo(submitAudit.getGranted()) <= 0) continue;
                submitAudit = a;
                continue;
            }
            Account acc = this.identifiedUserFactory.create(a.getAccountId()).getAccount();
            StringBuilder identbuf = new StringBuilder();
            if (acc.getFullName() != null && acc.getFullName().length() > 0) {
                if (identbuf.length() > 0) {
                    identbuf.append(' ');
                }
                identbuf.append(acc.getFullName());
            }
            if (acc.getPreferredEmail() != null && acc.getPreferredEmail().length() > 0) {
                if (MergeUtil.isSignedOffBy(footers, acc.getPreferredEmail())) continue;
                if (identbuf.length() > 0) {
                    identbuf.append(' ');
                }
                identbuf.append('<');
                identbuf.append(acc.getPreferredEmail());
                identbuf.append('>');
            }
            if (identbuf.length() == 0) continue;
            if (MergeUtil.isCodeReview(a.getLabelId())) {
                tag = "Reviewed-by";
            } else if (MergeUtil.isVerified(a.getLabelId())) {
                tag = "Tested-by";
            } else {
                LabelType lt = this.project.getLabelTypes().byLabel(a.getLabelId());
                if (lt == null) continue;
                tag = lt.getName();
            }
            if (MergeUtil.contains(footers, new FooterKey(tag), identbuf.toString())) continue;
            msgbuf.append(tag);
            msgbuf.append(": ");
            msgbuf.append((CharSequence)identbuf);
            msgbuf.append('\n');
        }
        return msgbuf.toString();
    }

    public String createCommitMessageOnSubmit(CodeReviewCommit n, RevCommit mergeTip) {
        return this.createCommitMessageOnSubmit(n, mergeTip, n.getControl(), n.getPatchsetId());
    }

    public String createCommitMessageOnSubmit(RevCommit n, RevCommit mergeTip, ChangeControl ctl, PatchSet.Id id) {
        return this.commitMessageGenerator.generate(n, mergeTip, ctl, this.createDetailedCommitMessage(n, ctl, id));
    }

    private static boolean isCodeReview(LabelId id) {
        return "Code-Review".equalsIgnoreCase(id.get());
    }

    private static boolean isVerified(LabelId id) {
        return "Verified".equalsIgnoreCase(id.get());
    }

    private Iterable<PatchSetApproval> safeGetApprovals(ChangeControl ctl, PatchSet.Id psId) {
        try {
            return this.approvalsUtil.byPatchSet(this.db.get(), ctl, psId);
        }
        catch (OrmException e) {
            log.error("Can't read approval records for " + psId, e);
            return Collections.emptyList();
        }
    }

    private static boolean contains(List<FooterLine> footers, FooterKey key, String val) {
        for (FooterLine line : footers) {
            if (!line.matches(key) || !val.equals(line.getValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean isSignedOffBy(List<FooterLine> footers, String email) {
        for (FooterLine line : footers) {
            if (!line.matches(FooterKey.SIGNED_OFF_BY) || !email.equals(line.getEmailAddress())) continue;
            return true;
        }
        return false;
    }

    public boolean canMerge(MergeSorter mergeSorter, Repository repo, CodeReviewCommit mergeTip, CodeReviewCommit toMerge) throws IntegrationException {
        boolean bl;
        if (this.hasMissingDependencies(mergeSorter, toMerge)) {
            return false;
        }
        InMemoryInserter ins = new InMemoryInserter(repo);
        Throwable throwable = null;
        try {
            bl = this.newThreeWayMerger(repo, ins).merge(mergeTip, toMerge);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    MergeUtil.$closeResource(throwable, ins);
                    throw throwable3;
                }
            }
            catch (LargeObjectException e) {
                log.warn("Cannot merge due to LargeObjectException: " + toMerge.name());
                return false;
            }
            catch (NoMergeBaseException e) {
                return false;
            }
            catch (IOException e) {
                throw new IntegrationException("Cannot merge " + toMerge.name(), e);
            }
        }
        MergeUtil.$closeResource(throwable, ins);
        return bl;
    }

    public boolean canFastForward(MergeSorter mergeSorter, CodeReviewCommit mergeTip, CodeReviewCommit.CodeReviewRevWalk rw, CodeReviewCommit toMerge) throws IntegrationException {
        if (this.hasMissingDependencies(mergeSorter, toMerge)) {
            return false;
        }
        try {
            return mergeTip == null || rw.isMergedInto(mergeTip, toMerge) || rw.isMergedInto(toMerge, mergeTip);
        }
        catch (IOException e) {
            throw new IntegrationException("Cannot fast-forward test during merge", e);
        }
    }

    public boolean canCherryPick(MergeSorter mergeSorter, Repository repo, CodeReviewCommit mergeTip, CodeReviewCommit.CodeReviewRevWalk rw, CodeReviewCommit toMerge) throws IntegrationException {
        if (mergeTip == null) {
            return true;
        }
        if (toMerge.getParentCount() == 0) {
            return false;
        }
        if (toMerge.getParentCount() == 1) {
            boolean bl;
            InMemoryInserter ins = new InMemoryInserter(repo);
            Throwable throwable = null;
            try {
                ThreeWayMerger m = this.newThreeWayMerger(repo, ins);
                m.setBase(toMerge.getParent(0));
                bl = m.merge(mergeTip, toMerge);
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        MergeUtil.$closeResource(throwable, ins);
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    throw new IntegrationException(String.format("Cannot merge commit %s with mergetip %s", toMerge.name(), mergeTip.name()), e);
                }
            }
            MergeUtil.$closeResource(throwable, ins);
            return bl;
        }
        return this.canFastForward(mergeSorter, mergeTip, rw, toMerge) || this.canMerge(mergeSorter, repo, mergeTip, toMerge);
    }

    public boolean hasMissingDependencies(MergeSorter mergeSorter, CodeReviewCommit toMerge) throws IntegrationException {
        try {
            return !mergeSorter.sort(Collections.singleton(toMerge)).contains(toMerge);
        }
        catch (IOException e) {
            throw new IntegrationException("Branch head sorting failed", e);
        }
    }

    public CodeReviewCommit mergeOneCommit(PersonIdent author, PersonIdent committer, Repository repo, CodeReviewCommit.CodeReviewRevWalk rw, ObjectInserter inserter, Branch.NameKey destBranch, CodeReviewCommit mergeTip, CodeReviewCommit n) throws IntegrationException {
        ThreeWayMerger m = this.newThreeWayMerger(repo, inserter);
        try {
            if (m.merge(mergeTip, n)) {
                return this.writeMergeCommit(author, committer, rw, inserter, destBranch, mergeTip, m.getResultTreeId(), n);
            }
            MergeUtil.failed(rw, mergeTip, n, CommitMergeStatus.PATH_CONFLICT);
        }
        catch (NoMergeBaseException e) {
            try {
                MergeUtil.failed(rw, mergeTip, n, MergeUtil.getCommitMergeStatus(e.getReason()));
            }
            catch (IOException e2) {
                throw new IntegrationException("Cannot merge " + n.name(), e);
            }
        }
        catch (IOException e) {
            throw new IntegrationException("Cannot merge " + n.name(), e);
        }
        return mergeTip;
    }

    private static CommitMergeStatus getCommitMergeStatus(NoMergeBaseException.MergeBaseFailureReason reason) {
        switch (reason) {
            default: {
                return CommitMergeStatus.MANUAL_RECURSIVE_MERGE;
            }
            case CONFLICTS_DURING_MERGE_BASE_CALCULATION: 
        }
        return CommitMergeStatus.PATH_CONFLICT;
    }

    private static CodeReviewCommit failed(CodeReviewCommit.CodeReviewRevWalk rw, CodeReviewCommit mergeTip, CodeReviewCommit n, CommitMergeStatus failure) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        CodeReviewCommit failed;
        rw.reset();
        rw.markStart(n);
        rw.markUninteresting(mergeTip);
        while ((failed = rw.next()) != null) {
            failed.setStatusCode(failure);
        }
        return failed;
    }

    public CodeReviewCommit writeMergeCommit(PersonIdent author, PersonIdent committer, CodeReviewCommit.CodeReviewRevWalk rw, ObjectInserter inserter, Branch.NameKey destBranch, CodeReviewCommit mergeTip, ObjectId treeId, CodeReviewCommit n) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        CodeReviewCommit crc;
        ArrayList<CodeReviewCommit> merged = new ArrayList<CodeReviewCommit>();
        rw.reset();
        rw.markStart(n);
        rw.markUninteresting(mergeTip);
        while ((crc = rw.next()) != null) {
            if (crc.getPatchsetId() == null) continue;
            merged.add(crc);
        }
        StringBuilder msgbuf = new StringBuilder().append(this.summarize(rw, merged));
        if (!R_HEADS_MASTER.equals(destBranch.get())) {
            msgbuf.append(" into ");
            msgbuf.append(destBranch.getShortName());
        }
        if (merged.size() > 1) {
            msgbuf.append("\n\n* changes:\n");
            for (CodeReviewCommit c : merged) {
                rw.parseBody(c);
                msgbuf.append("  ");
                msgbuf.append(c.getShortMessage());
                msgbuf.append("\n");
            }
        }
        CommitBuilder mergeCommit = new CommitBuilder();
        mergeCommit.setTreeId(treeId);
        mergeCommit.setParentIds((AnyObjectId)mergeTip, (AnyObjectId)n);
        mergeCommit.setAuthor(author);
        mergeCommit.setCommitter(committer);
        mergeCommit.setMessage(msgbuf.toString());
        CodeReviewCommit mergeResult = rw.parseCommit(inserter.insert(mergeCommit));
        mergeResult.setControl(n.getControl());
        return mergeResult;
    }

    private String summarize(RevWalk rw, List<CodeReviewCommit> merged) throws IOException {
        if (merged.size() == 1) {
            CodeReviewCommit c2 = merged.get(0);
            rw.parseBody(c2);
            return String.format("Merge \"%s\"", c2.getShortMessage());
        }
        LinkedHashSet<String> topics = new LinkedHashSet<String>(4);
        for (CodeReviewCommit c3 : merged) {
            if (Strings.isNullOrEmpty(c3.change().getTopic())) continue;
            topics.add(c3.change().getTopic());
        }
        if (topics.size() == 1) {
            return String.format("Merge changes from topic '%s'", Iterables.getFirst(topics, null));
        }
        if (topics.size() > 1) {
            return String.format("Merge changes from topics '%s'", Joiner.on("', '").join(topics));
        }
        return String.format("Merge changes %s%s", FluentIterable.from(merged).limit(5).transform(c -> c.change().getKey().abbreviate()).join(Joiner.on(',')), merged.size() > 5 ? ", ..." : "");
    }

    public ThreeWayMerger newThreeWayMerger(Repository repo, ObjectInserter inserter) {
        return MergeUtil.newThreeWayMerger(repo, inserter, this.mergeStrategyName());
    }

    public String mergeStrategyName() {
        return MergeUtil.mergeStrategyName(this.useContentMerge, this.useRecursiveMerge);
    }

    public static String mergeStrategyName(boolean useContentMerge, boolean useRecursiveMerge) {
        if (useContentMerge) {
            if (useRecursiveMerge) {
                return MergeStrategy.RECURSIVE.getName();
            }
            return MergeStrategy.RESOLVE.getName();
        }
        return MergeStrategy.SIMPLE_TWO_WAY_IN_CORE.getName();
    }

    public static ThreeWayMerger newThreeWayMerger(Repository repo, ObjectInserter inserter, String strategyName) {
        Merger m = MergeUtil.newMerger(repo, inserter, strategyName);
        Preconditions.checkArgument(m instanceof ThreeWayMerger, "merge strategy %s does not support three-way merging", (Object)strategyName);
        return (ThreeWayMerger)m;
    }

    public static Merger newMerger(Repository repo, final ObjectInserter inserter, String strategyName) {
        MergeStrategy strategy = MergeStrategy.get(strategyName);
        Preconditions.checkArgument(strategy != null, "invalid merge strategy: %s", (Object)strategyName);
        Merger m = strategy.newMerger(repo, true);
        m.setObjectInserter(new ObjectInserter.Filter(){

            @Override
            protected ObjectInserter delegate() {
                return inserter;
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
        return m;
    }

    public void markCleanMerges(RevWalk rw, RevFlag canMergeFlag, CodeReviewCommit mergeTip, Set<RevCommit> alreadyAccepted) throws IntegrationException {
        if (mergeTip == null) {
            return;
        }
        try {
            CodeReviewCommit c;
            rw.resetRetain(canMergeFlag);
            rw.sort(RevSort.TOPO);
            rw.sort(RevSort.REVERSE, true);
            rw.markStart(mergeTip);
            for (RevCommit c2 : alreadyAccepted) {
                if (Objects.equals(c2, mergeTip)) continue;
                rw.markUninteresting(c2);
            }
            while ((c = (CodeReviewCommit)rw.next()) != null) {
                if (c.getPatchsetId() == null || c.getStatusCode() != null) continue;
                c.setStatusCode(CommitMergeStatus.CLEAN_MERGE);
            }
        }
        catch (IOException e) {
            throw new IntegrationException("Cannot mark clean merges", e);
        }
    }

    public Set<Change.Id> findUnmergedChanges(Set<Change.Id> expected, CodeReviewCommit.CodeReviewRevWalk rw, RevFlag canMergeFlag, CodeReviewCommit oldTip, CodeReviewCommit mergeTip, Iterable<Change.Id> alreadyMerged) throws IntegrationException {
        if (mergeTip == null) {
            return expected;
        }
        try {
            CodeReviewCommit c;
            HashSet<Change.Id> found = Sets.newHashSetWithExpectedSize(expected.size());
            Iterables.addAll(found, alreadyMerged);
            rw.resetRetain(canMergeFlag);
            rw.sort(RevSort.TOPO);
            rw.markStart(mergeTip);
            if (oldTip != null) {
                rw.markUninteresting(oldTip);
            }
            while ((c = rw.next()) != null) {
                Change.Id id;
                if (c.getPatchsetId() == null || !expected.contains(id = c.getPatchsetId().getParentKey())) continue;
                found.add(id);
                if (found.size() != expected.size()) continue;
                return Collections.emptySet();
            }
            return Sets.difference(expected, found);
        }
        catch (IOException e) {
            throw new IntegrationException("Cannot check if changes were merged", e);
        }
    }

    public static CodeReviewCommit findAnyMergedInto(CodeReviewCommit.CodeReviewRevWalk rw, Iterable<CodeReviewCommit> commits, CodeReviewCommit tip) throws IOException {
        for (CodeReviewCommit c : commits) {
            if (!rw.isMergedInto(c, tip)) continue;
            return c;
        }
        return null;
    }

    public static RevCommit resolveCommit(Repository repo, RevWalk rw, String str) throws BadRequestException, ResourceNotFoundException, IOException {
        try {
            ObjectId commitId = repo.resolve(str);
            if (commitId == null) {
                throw new BadRequestException("Cannot resolve '" + str + "' to a commit");
            }
            return rw.parseCommit(commitId);
        }
        catch (AmbiguousObjectException | IncorrectObjectTypeException | RevisionSyntaxException e) {
            throw new BadRequestException(e.getMessage());
        }
        catch (MissingObjectException e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static interface Factory {
        public MergeUtil create(ProjectState var1);

        public MergeUtil create(ProjectState var1, boolean var2);
    }

    static class PluggableCommitMessageGenerator {
        private final DynamicSet<ChangeMessageModifier> changeMessageModifiers;

        @Inject
        PluggableCommitMessageGenerator(DynamicSet<ChangeMessageModifier> changeMessageModifiers) {
            this.changeMessageModifiers = changeMessageModifiers;
        }

        public String generate(RevCommit original, RevCommit mergeTip, ChangeControl ctl, String current) {
            Preconditions.checkNotNull(original.getRawBuffer());
            if (mergeTip != null) {
                Preconditions.checkNotNull(mergeTip.getRawBuffer());
            }
            for (ChangeMessageModifier changeMessageModifier : this.changeMessageModifiers) {
                current = changeMessageModifier.onSubmit(current, original, mergeTip, ctl.getChange().getDest());
                Preconditions.checkNotNull(current, changeMessageModifier.getClass().getName() + ".OnSubmit returned null instead of new commit message");
            }
            return current;
        }
    }
}

