/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.restapi.MergeConflictException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.change.RebaseChangeOp;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.MergeIdenticalTreeException;
import com.google.gerrit.server.git.MergeTip;
import com.google.gerrit.server.git.RebaseSorter;
import com.google.gerrit.server.git.strategy.CommitMergeStatus;
import com.google.gerrit.server.git.strategy.FastForwardOp;
import com.google.gerrit.server.git.strategy.SubmitDryRun;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.git.strategy.SubmitStrategyOp;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.RepoContext;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.ReceiveCommand;

public class RebaseSubmitStrategy
extends SubmitStrategy {
    private final boolean rebaseAlways;

    RebaseSubmitStrategy(SubmitStrategy.Arguments args, boolean rebaseAlways) {
        super(args);
        this.rebaseAlways = rebaseAlways;
    }

    @Override
    public List<SubmitStrategyOp> buildOps(Collection<CodeReviewCommit> toMerge) throws IntegrationException {
        List<CodeReviewCommit> sorted = this.sort(toMerge);
        ArrayList<SubmitStrategyOp> ops = new ArrayList<SubmitStrategyOp>(sorted.size());
        boolean first = true;
        for (CodeReviewCommit c : sorted) {
            if (c.getParentCount() <= 1) continue;
            sorted = this.args.mergeUtil.reduceToMinimalMerge(this.args.mergeSorter, sorted, this.args.incoming);
            break;
        }
        while (!sorted.isEmpty()) {
            CodeReviewCommit n = sorted.remove(0);
            if (first && this.args.mergeTip.getInitialTip() == null) {
                ops.add(new FastForwardOp(this.args, n));
            } else if (n.getParentCount() == 0) {
                ops.add(new RebaseRootOp(n));
            } else if (n.getParentCount() == 1) {
                ops.add(new RebaseOneOp(n));
            } else {
                ops.add(new RebaseMultipleParentsOp(n));
            }
            first = false;
        }
        return ops;
    }

    private void acceptMergeTip(MergeTip mergeTip) {
        this.args.alreadyAccepted.add(mergeTip.getCurrentTip());
    }

    private List<CodeReviewCommit> sort(Collection<CodeReviewCommit> toSort) throws IntegrationException {
        try {
            return new RebaseSorter(this.args.rw, this.args.mergeTip.getInitialTip(), this.args.alreadyAccepted, this.args.canMergeFlag, this.args.internalChangeQuery).sort(toSort);
        }
        catch (IOException e) {
            throw new IntegrationException("Commit sorting failed", e);
        }
    }

    static boolean dryRun(SubmitDryRun.Arguments args, CodeReviewCommit mergeTip, CodeReviewCommit toMerge) throws IntegrationException {
        return !args.mergeUtil.hasMissingDependencies(args.mergeSorter, toMerge) && args.mergeUtil.canMerge(args.mergeSorter, args.repo, mergeTip, toMerge);
    }

    private class RebaseMultipleParentsOp
    extends SubmitStrategyOp {
        private RebaseMultipleParentsOp(CodeReviewCommit toMerge) {
            super(RebaseSubmitStrategy.this.args, toMerge);
        }

        @Override
        public void updateRepoImpl(RepoContext ctx) throws IntegrationException, IOException {
            MergeTip mergeTip = this.args.mergeTip;
            if (this.args.rw.isMergedInto(mergeTip.getCurrentTip(), this.toMerge) && !this.args.submoduleOp.hasSubscription(this.args.destBranch)) {
                mergeTip.moveTipTo(this.toMerge, this.toMerge);
            } else {
                PersonIdent caller = ctx.getIdentifiedUser().newCommitterIdent(ctx.getWhen(), ctx.getTimeZone());
                CodeReviewCommit newTip = this.args.mergeUtil.mergeOneCommit(caller, caller, this.args.repo, this.args.rw, this.args.inserter, this.args.destBranch, mergeTip.getCurrentTip(), this.toMerge);
                mergeTip.moveTipTo(this.amendGitlink(newTip), this.toMerge);
            }
            this.args.mergeUtil.markCleanMerges(this.args.rw, this.args.canMergeFlag, mergeTip.getCurrentTip(), this.args.alreadyAccepted);
            RebaseSubmitStrategy.this.acceptMergeTip(mergeTip);
        }
    }

    private class RebaseOneOp
    extends SubmitStrategyOp {
        private RebaseChangeOp rebaseOp;
        private CodeReviewCommit newCommit;
        private PatchSet.Id newPatchSetId;

        private RebaseOneOp(CodeReviewCommit toMerge) {
            super(RebaseSubmitStrategy.this.args, toMerge);
        }

        @Override
        public void updateRepoImpl(RepoContext ctx) throws IntegrationException, InvalidChangeOperationException, RestApiException, IOException, OrmException {
            if (this.args.mergeUtil.canFastForward(this.args.mergeSorter, this.args.mergeTip.getCurrentTip(), this.args.rw, this.toMerge)) {
                if (!RebaseSubmitStrategy.this.rebaseAlways) {
                    this.args.mergeTip.moveTipTo(this.amendGitlink(this.toMerge), this.toMerge);
                    this.toMerge.setStatusCode(CommitMergeStatus.CLEAN_MERGE);
                    RebaseSubmitStrategy.this.acceptMergeTip(this.args.mergeTip);
                    return;
                }
                this.args.rw.parseBody(this.toMerge);
                this.newPatchSetId = ChangeUtil.nextPatchSetId(this.args.repo, this.toMerge.change().currentPatchSetId());
                CodeReviewCommit mergeTip = this.args.mergeTip.getCurrentTip();
                this.args.rw.parseBody(mergeTip);
                String cherryPickCmtMsg = this.args.mergeUtil.createCommitMessageOnSubmit(this.toMerge, mergeTip);
                PersonIdent committer = this.args.caller.newCommitterIdent(ctx.getWhen(), this.args.serverIdent.getTimeZone());
                try {
                    this.newCommit = this.args.mergeUtil.createCherryPickFromCommit(this.args.repo, this.args.inserter, this.args.mergeTip.getCurrentTip(), this.toMerge, committer, cherryPickCmtMsg, this.args.rw, 0, true);
                }
                catch (MergeConflictException mce) {
                    this.toMerge.setStatusCode(CommitMergeStatus.REBASE_MERGE_CONFLICT);
                    throw new IllegalStateException("MergeConflictException on message edit must not happen");
                }
                catch (MergeIdenticalTreeException mie) {
                    this.toMerge.setStatusCode(CommitMergeStatus.SKIPPED_IDENTICAL_TREE);
                    return;
                }
                ctx.addRefUpdate(new ReceiveCommand(ObjectId.zeroId(), this.newCommit, this.newPatchSetId.toRefName()));
            } else {
                PatchSet origPs = this.args.psUtil.get(ctx.getDb(), this.toMerge.getControl().getNotes(), this.toMerge.getPatchsetId());
                this.rebaseOp = this.args.rebaseFactory.create(this.toMerge.getControl(), origPs, this.args.mergeTip.getCurrentTip().name()).setFireRevisionCreated(false).setCopyApprovals(false).setValidatePolicy(CommitValidators.Policy.NONE).setCheckAddPatchSetPermission(false).setDetailedCommitMessage(RebaseSubmitStrategy.this.rebaseAlways).setPostMessage(false);
                try {
                    this.rebaseOp.updateRepo(ctx);
                }
                catch (MergeConflictException | NoSuchChangeException e) {
                    this.toMerge.setStatusCode(CommitMergeStatus.REBASE_MERGE_CONFLICT);
                    throw new IntegrationException("Cannot rebase " + this.toMerge.name() + ": " + e.getMessage(), e);
                }
                this.newCommit = this.args.rw.parseCommit(this.rebaseOp.getRebasedCommit());
                this.newPatchSetId = this.rebaseOp.getPatchSetId();
            }
            this.newCommit = this.amendGitlink(this.newCommit);
            this.newCommit.copyFrom(this.toMerge);
            this.newCommit.setPatchsetId(this.newPatchSetId);
            this.newCommit.setStatusCode(CommitMergeStatus.CLEAN_REBASE);
            this.args.mergeTip.moveTipTo(this.newCommit, this.newCommit);
            this.args.commitStatus.put(this.args.mergeTip.getCurrentTip());
            RebaseSubmitStrategy.this.acceptMergeTip(this.args.mergeTip);
        }

        @Override
        public PatchSet updateChangeImpl(ChangeContext ctx) throws NoSuchChangeException, ResourceConflictException, OrmException, IOException {
            PatchSet newPs;
            if (this.newCommit == null) {
                Preconditions.checkState(!RebaseSubmitStrategy.this.rebaseAlways, "RebaseAlways must never fast forward");
                return null;
            }
            if (this.rebaseOp != null) {
                this.rebaseOp.updateChange(ctx);
                newPs = this.rebaseOp.getPatchSet();
            } else {
                PatchSet prevPs = this.args.psUtil.current(ctx.getDb(), ctx.getNotes());
                newPs = this.args.psUtil.insert(ctx.getDb(), ctx.getRevWalk(), ctx.getUpdate(this.newPatchSetId), this.newPatchSetId, this.newCommit, false, prevPs != null ? prevPs.getGroups() : ImmutableList.of(), null, null);
            }
            ctx.getChange().setCurrentPatchSet(this.args.patchSetInfoFactory.get(ctx.getRevWalk(), this.newCommit, this.newPatchSetId));
            this.newCommit.setControl(ctx.getControl());
            return newPs;
        }

        @Override
        public void postUpdateImpl(Context ctx) throws OrmException {
            if (this.rebaseOp != null) {
                this.rebaseOp.postUpdate(ctx);
            }
        }
    }

    private class RebaseRootOp
    extends SubmitStrategyOp {
        private RebaseRootOp(CodeReviewCommit toMerge) {
            super(RebaseSubmitStrategy.this.args, toMerge);
        }

        @Override
        public void updateRepoImpl(RepoContext ctx) {
            this.toMerge.setStatusCode(CommitMergeStatus.CANNOT_REBASE_ROOT);
        }
    }
}

