/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.validators;

import com.google.gerrit.extensions.annotations.ExtensionPoint;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.validators.ValidationException;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

@ExtensionPoint
public interface OnSubmitValidationListener {
    public void preBranchUpdate(Arguments var1) throws ValidationException;

    public static class Arguments {
        private Project.NameKey project;
        private Repository repository;
        private ObjectReader objectReader;
        private Map<String, ReceiveCommand> commands;

        public Arguments(Project.NameKey project, Repository repository, ObjectReader objectReader, Map<String, ReceiveCommand> commands) {
            this.project = project;
            this.repository = repository;
            this.objectReader = objectReader;
            this.commands = commands;
        }

        public Project.NameKey getProject() {
            return this.project;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public RevWalk newRevWalk() {
            return new RevWalk(this.objectReader);
        }

        public Map<String, ReceiveCommand> getCommands() {
            return this.commands;
        }
    }
}

