/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupDetail;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupName;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupDetailFactory;
import com.google.gerrit.server.git.RenameGroupOp;
import com.google.gerrit.server.group.GroupResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Singleton
public class PutName
implements RestModifyView<GroupResource, Input> {
    private final Provider<ReviewDb> db;
    private final GroupCache groupCache;
    private final GroupDetailFactory.Factory groupDetailFactory;
    private final RenameGroupOp.Factory renameGroupOpFactory;
    private final Provider<IdentifiedUser> currentUser;

    @Inject
    PutName(Provider<ReviewDb> db, GroupCache groupCache, GroupDetailFactory.Factory groupDetailFactory, RenameGroupOp.Factory renameGroupOpFactory, Provider<IdentifiedUser> currentUser) {
        this.db = db;
        this.groupCache = groupCache;
        this.groupDetailFactory = groupDetailFactory;
        this.renameGroupOpFactory = renameGroupOpFactory;
        this.currentUser = currentUser;
    }

    public String apply(GroupResource rsrc, Input input) throws MethodNotAllowedException, AuthException, BadRequestException, ResourceConflictException, OrmException, NoSuchGroupException, IOException {
        if (rsrc.toAccountGroup() == null) {
            throw new MethodNotAllowedException();
        }
        if (!rsrc.getControl().isOwner()) {
            throw new AuthException("Not group owner");
        }
        if (input == null || Strings.isNullOrEmpty(input.name)) {
            throw new BadRequestException("name is required");
        }
        String newName = input.name.trim();
        if (newName.isEmpty()) {
            throw new BadRequestException("name is required");
        }
        if (rsrc.toAccountGroup().getName().equals(newName)) {
            return newName;
        }
        return this.renameGroup((AccountGroup)rsrc.toAccountGroup(), (String)newName).group.getName();
    }

    private GroupDetail renameGroup(AccountGroup group, String newName) throws ResourceConflictException, OrmException, NoSuchGroupException, IOException {
        AccountGroup.Id groupId = group.getId();
        AccountGroup.NameKey old = group.getNameKey();
        AccountGroup.NameKey key = new AccountGroup.NameKey(newName);
        try {
            AccountGroupName id = new AccountGroupName(key, groupId);
            this.db.get().accountGroupNames().insert(Collections.singleton(id));
        }
        catch (OrmException e) {
            AccountGroupName other = this.db.get().accountGroupNames().get(key);
            if (other != null) {
                if (other.getId().equals(groupId)) {
                    return this.groupDetailFactory.create(groupId).call();
                }
                throw new ResourceConflictException("group with name " + newName + "already exists");
            }
            throw e;
        }
        group.setNameKey(key);
        this.db.get().accountGroups().update(Collections.singleton(group));
        AccountGroupName priorName = this.db.get().accountGroupNames().get(old);
        if (priorName != null) {
            this.db.get().accountGroupNames().delete(Collections.singleton(priorName));
        }
        this.groupCache.evict(group);
        this.groupCache.evictAfterRename(old, key);
        ScheduledFuture<?> possiblyIgnoredError = this.renameGroupOpFactory.create(this.currentUser.get().newCommitterIdent(new Date(), TimeZone.getDefault()), group.getGroupUUID(), old.get(), newName).start(0L, TimeUnit.MILLISECONDS);
        return this.groupDetailFactory.create(groupId).call();
    }

    public static class Input {
        @DefaultInput
        public String name;
    }
}

