/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.index.GerritIndexStatus;
import com.google.gerrit.server.index.Index;
import com.google.gerrit.server.index.IndexCollection;
import com.google.gerrit.server.index.IndexDefinition;
import com.google.gerrit.server.index.OnlineReindexer;
import com.google.gerrit.server.index.ReindexerAlreadyRunningException;
import com.google.gerrit.server.index.Schema;
import com.google.inject.ProvisionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;

public abstract class AbstractVersionManager
implements LifecycleListener {
    protected final boolean onlineUpgrade;
    protected final String runReindexMsg;
    protected final SitePaths sitePaths;
    protected final Map<String, IndexDefinition<?, ?, ?>> defs;
    protected final Map<String, OnlineReindexer<?, ?, ?>> reindexers;

    protected AbstractVersionManager(@GerritServerConfig Config cfg, SitePaths sitePaths, Collection<IndexDefinition<?, ?, ?>> defs) {
        this.sitePaths = sitePaths;
        this.defs = Maps.newHashMapWithExpectedSize(defs.size());
        for (IndexDefinition<?, ?, ?> def : defs) {
            this.defs.put(def.getName(), def);
        }
        this.reindexers = Maps.newHashMapWithExpectedSize(defs.size());
        this.onlineUpgrade = cfg.getBoolean("index", null, "onlineUpgrade", true);
        this.runReindexMsg = "No index versions ready; run java -jar " + sitePaths.gerrit_war.toAbsolutePath() + " reindex";
    }

    @Override
    public void start() {
        GerritIndexStatus cfg = this.createIndexStatus();
        for (IndexDefinition<?, ?, ?> def : this.defs.values()) {
            this.initIndex(def, cfg);
        }
    }

    @Override
    public void stop() {
    }

    public synchronized boolean startReindexer(String name, boolean force) throws ReindexerAlreadyRunningException {
        OnlineReindexer<?, ?, ?> reindexer = this.reindexers.get(name);
        AbstractVersionManager.validateReindexerNotRunning(reindexer);
        if (force || !this.isLatestIndexVersion(name, reindexer)) {
            reindexer.start();
            return true;
        }
        return false;
    }

    public synchronized boolean activateLatestIndex(String name) throws ReindexerAlreadyRunningException {
        OnlineReindexer<?, ?, ?> reindexer = this.reindexers.get(name);
        AbstractVersionManager.validateReindexerNotRunning(reindexer);
        if (!this.isLatestIndexVersion(name, reindexer)) {
            reindexer.activateIndex();
            return true;
        }
        return false;
    }

    public boolean isKnownIndex(String name) {
        return this.defs.get(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K, V, I extends Index<K, V>> void initIndex(IndexDefinition<K, V, I> def, GerritIndexStatus cfg) {
        TreeMap<Integer, Version<V>> versions = this.scanVersions(def, cfg);
        Version search = null;
        ArrayList<Version<V>> write = Lists.newArrayListWithCapacity(2);
        for (Version v : versions.descendingMap().values()) {
            if (v.schema == null) continue;
            if (write.isEmpty() && this.onlineUpgrade) {
                write.add(v);
            }
            if (!v.ready) continue;
            search = v;
            if (write.contains(v)) break;
            write.add(v);
            break;
        }
        if (search == null) {
            throw new ProvisionException(this.runReindexMsg);
        }
        IndexDefinition.IndexFactory factory = def.getIndexFactory();
        I searchIndex = factory.create(search.schema);
        IndexCollection<K, V, I> indexes = def.getIndexCollection();
        indexes.setSearchIndex(searchIndex);
        for (Version version : write) {
            if (version.version != search.version) {
                indexes.addWriteIndex(factory.create(version.schema));
                continue;
            }
            indexes.addWriteIndex(searchIndex);
        }
        this.markNotReady(def.getName(), versions.values(), write);
        AbstractVersionManager abstractVersionManager = this;
        synchronized (abstractVersionManager) {
            if (!this.reindexers.containsKey(def.getName())) {
                int n = ((Version)write.get((int)0)).version;
                OnlineReindexer<K, V, I> reindexer = new OnlineReindexer<K, V, I>(def, n);
                this.reindexers.put(def.getName(), reindexer);
                if (this.onlineUpgrade && n != search.version) {
                    reindexer.start();
                }
            }
        }
    }

    protected GerritIndexStatus createIndexStatus() {
        try {
            return new GerritIndexStatus(this.sitePaths);
        }
        catch (IOException | ConfigInvalidException e) {
            throw this.fail(e);
        }
    }

    protected abstract <K, V, I extends Index<K, V>> TreeMap<Integer, Version<V>> scanVersions(IndexDefinition<K, V, I> var1, GerritIndexStatus var2);

    private <V> boolean isDirty(Collection<Version<V>> inUse, Version<V> v) {
        return !inUse.contains(v) && v.exists;
    }

    private boolean isLatestIndexVersion(String name, OnlineReindexer<?, ?, ?> reindexer) {
        int readVersion = this.defs.get(name).getIndexCollection().getSearchIndex().getSchema().getVersion();
        return reindexer == null || reindexer.getVersion() == readVersion;
    }

    private static void validateReindexerNotRunning(OnlineReindexer<?, ?, ?> reindexer) throws ReindexerAlreadyRunningException {
        if (reindexer != null && reindexer.isRunning()) {
            throw new ReindexerAlreadyRunningException();
        }
    }

    private <V> void markNotReady(String name, Iterable<Version<V>> versions, Collection<Version<V>> inUse) {
        GerritIndexStatus cfg = this.createIndexStatus();
        boolean dirty = false;
        for (Version<V> v : versions) {
            if (!this.isDirty(inUse, v)) continue;
            cfg.setReady(name, v.version, false);
            dirty = true;
        }
        if (dirty) {
            try {
                cfg.save();
            }
            catch (IOException e) {
                throw this.fail(e);
            }
        }
    }

    private ProvisionException fail(Throwable t) {
        ProvisionException e = new ProvisionException("Error scanning indexes");
        e.initCause(t);
        return e;
    }

    public static class Version<V> {
        public final Schema<V> schema;
        public final int version;
        public final boolean exists;
        public final boolean ready;

        public Version(Schema<V> schema, int version, boolean exists, boolean ready) {
            Preconditions.checkArgument(schema == null || schema.getVersion() == version);
            this.schema = schema;
            this.version = version;
            this.exists = exists;
            this.ready = ready;
        }
    }
}

