/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.collect.ImmutableSortedMap;
import com.google.gerrit.server.index.Index;
import com.google.gerrit.server.index.IndexCollection;
import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.index.SchemaDefinitions;
import com.google.gerrit.server.index.SiteIndexer;
import com.google.inject.Provider;

public abstract class IndexDefinition<K, V, I extends Index<K, V>> {
    private final SchemaDefinitions<V> schemaDefs;
    private final IndexCollection<K, V, I> indexCollection;
    private final IndexFactory<K, V, I> indexFactory;
    private final Provider<SiteIndexer<K, V, I>> siteIndexer;

    protected IndexDefinition(SchemaDefinitions<V> schemaDefs, IndexCollection<K, V, I> indexCollection, IndexFactory<K, V, I> indexFactory, Provider<SiteIndexer<K, V, I>> siteIndexer) {
        this.schemaDefs = schemaDefs;
        this.indexCollection = indexCollection;
        this.indexFactory = indexFactory;
        this.siteIndexer = siteIndexer;
    }

    public final String getName() {
        return this.schemaDefs.getName();
    }

    public final ImmutableSortedMap<Integer, Schema<V>> getSchemas() {
        return this.schemaDefs.getSchemas();
    }

    public final Schema<V> getLatest() {
        return this.schemaDefs.getLatest();
    }

    public final IndexCollection<K, V, I> getIndexCollection() {
        return this.indexCollection;
    }

    public final IndexFactory<K, V, I> getIndexFactory() {
        return this.indexFactory;
    }

    public final SiteIndexer<K, V, I> getSiteIndexer() {
        return this.siteIndexer.get();
    }

    public static interface IndexFactory<K, V, I extends Index<K, V>> {
        public I create(Schema<V> var1);
    }
}

