/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.receive;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.mail.EmailSettings;
import com.google.gerrit.server.mail.receive.ImapMailReceiver;
import com.google.gerrit.server.mail.receive.MailMessage;
import com.google.gerrit.server.mail.receive.MailProcessor;
import com.google.gerrit.server.mail.receive.Pop3MailReceiver;
import com.google.gerrit.server.mail.receive.Protocol;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MailReceiver
implements LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(MailReceiver.class);
    protected EmailSettings mailSettings;
    protected Set<String> pendingDeletion;
    private MailProcessor mailProcessor;
    private WorkQueue workQueue;
    private Timer timer;

    MailReceiver(EmailSettings mailSettings, MailProcessor mailProcessor, WorkQueue workQueue) {
        this.mailSettings = mailSettings;
        this.mailProcessor = mailProcessor;
        this.workQueue = workQueue;
        this.pendingDeletion = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public void start() {
        if (this.timer == null) {
            this.timer = new Timer();
        } else {
            this.timer.cancel();
        }
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                MailReceiver.this.handleEmails(true);
            }
        }, 0L, this.mailSettings.fetchInterval);
    }

    @Override
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void requestDeletion(String messageId) {
        this.pendingDeletion.add(messageId);
    }

    @VisibleForTesting
    public abstract void handleEmails(boolean var1);

    protected void dispatchMailProcessor(List<MailMessage> messages, boolean async) {
        for (MailMessage m : messages) {
            if (async) {
                Future<?> future = this.workQueue.getDefaultQueue().submit(() -> {
                    try {
                        this.mailProcessor.process(m);
                        this.requestDeletion(m.id());
                    }
                    catch (OrmException e) {
                        log.error("Mail: Can't process message " + m.id() + " . Won't delete.", e);
                    }
                });
                continue;
            }
            try {
                this.mailProcessor.process(m);
                this.requestDeletion(m.id());
            }
            catch (OrmException e) {
                log.error("Mail: Can't process messages. Won't delete.", e);
            }
        }
    }

    public static class Module
    extends LifecycleModule {
        private final EmailSettings mailSettings;

        @Inject
        Module(EmailSettings mailSettings) {
            this.mailSettings = mailSettings;
        }

        @Override
        protected void configure() {
            if (this.mailSettings.protocol == Protocol.NONE) {
                return;
            }
            this.listener().to(MailReceiver.class);
            switch (this.mailSettings.protocol) {
                case IMAP: {
                    this.bind(MailReceiver.class).to(ImapMailReceiver.class);
                    break;
                }
                case POP3: {
                    this.bind(MailReceiver.class).to(Pop3MailReceiver.class);
                    break;
                }
            }
        }
    }
}

